/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.io.IOUtils;
import org.gaul.s3proxy.crypto.Constants;
import org.jclouds.blobstore.domain.Blob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartPadding {
    private static final Logger logger = LoggerFactory.getLogger(PartPadding.class);
    private String delimiter;
    private IvParameterSpec iv;
    private int part;
    private long size;
    private short version;

    public static PartPadding readPartPaddingFromBlob(Blob blob) throws IOException {
        PartPadding partPadding = new PartPadding();
        try (InputStream is = blob.getPayload().openStream();){
            byte[] paddingBytes = IOUtils.toByteArray((InputStream)is);
            ByteBuffer bb = ByteBuffer.wrap(paddingBytes);
            byte[] delimiterBytes = new byte[Constants.PADDING_DELIMITER_LENGTH];
            bb.get(delimiterBytes);
            partPadding.delimiter = new String(delimiterBytes, StandardCharsets.UTF_8);
            byte[] ivBytes = new byte[16];
            bb.get(ivBytes);
            partPadding.iv = new IvParameterSpec(ivBytes);
            partPadding.part = bb.getInt();
            partPadding.size = bb.getLong();
            partPadding.version = bb.getShort();
            logger.debug("delimiter {}", (Object)partPadding.delimiter);
            logger.debug("iv {}", (Object)Arrays.toString(ivBytes));
            logger.debug("part {}", (Object)partPadding.part);
            logger.debug("size {}", (Object)partPadding.size);
            logger.debug("version {}", (Object)partPadding.version);
            PartPadding partPadding2 = partPadding;
            return partPadding2;
        }
    }

    public final String getDelimiter() {
        return this.delimiter;
    }

    public final IvParameterSpec getIv() {
        return this.iv;
    }

    public final int getPart() {
        return this.part;
    }

    public final long getSize() {
        return this.size;
    }
}

