/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy.junit;

import com.google.common.annotations.Beta;
import java.net.URI;
import org.gaul.s3proxy.AuthenticationType;
import org.gaul.s3proxy.junit.S3ProxyJunitCore;
import org.junit.rules.ExternalResource;

@Beta
public final class S3ProxyRule
extends ExternalResource {
    private final S3ProxyJunitCore core;

    private S3ProxyRule(Builder builder) {
        this.core = new S3ProxyJunitCore(builder.builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected void before() throws Throwable {
        this.core.beforeEach();
    }

    protected void after() {
        this.core.afterEach();
    }

    public URI getUri() {
        return this.core.getUri();
    }

    public String getAccessKey() {
        return this.core.getAccessKey();
    }

    public String getSecretKey() {
        return this.core.getSecretKey();
    }

    public static final class Builder {
        private final S3ProxyJunitCore.Builder builder = new S3ProxyJunitCore.Builder();

        private Builder() {
        }

        public Builder withCredentials(AuthenticationType authType, String accessKey, String secretKey) {
            this.builder.withCredentials(authType, accessKey, secretKey);
            return this;
        }

        public Builder withCredentials(String accessKey, String secretKey) {
            this.builder.withCredentials(accessKey, secretKey);
            return this;
        }

        public Builder withSecretStore(String path, String password) {
            this.builder.withSecretStore(path, password);
            return this;
        }

        public Builder withPort(int port) {
            this.builder.withPort(port);
            return this;
        }

        public Builder withBlobStoreProvider(String blobStoreProvider) {
            this.builder.withBlobStoreProvider(blobStoreProvider);
            return this;
        }

        public Builder ignoreUnknownHeaders() {
            this.builder.ignoreUnknownHeaders();
            return this;
        }

        public S3ProxyRule build() {
            return new S3ProxyRule(this);
        }
    }
}

