/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy.nio2blob;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.Tier;
import org.jclouds.blobstore.domain.internal.BlobBuilderImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.domain.internal.StorageMetadataImpl;
import org.jclouds.blobstore.internal.BaseBlobStore;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.location.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class Nio2BlobStore
extends BaseBlobStore {
    private static final Logger logger = LoggerFactory.getLogger(Nio2BlobStore.class);
    private static final String XATTR_CACHE_CONTROL = "user.cache-control";
    private static final String XATTR_CONTENT_DISPOSITION = "user.content-disposition";
    private static final String XATTR_CONTENT_ENCODING = "user.content-encoding";
    private static final String XATTR_CONTENT_LANGUAGE = "user.content-language";
    private static final String XATTR_CONTENT_MD5 = "user.content-md5";
    private static final String XATTR_CONTENT_TYPE = "user.content-type";
    private static final String XATTR_EXPIRES = "user.expires";
    private static final String XATTR_STORAGE_TIER = "user.storage-tier";
    private static final String XATTR_USER_METADATA_PREFIX = "user.user-metadata.";
    private static final String MULTIPART_PREFIX = ".mpus-";
    private static final byte[] DIRECTORY_MD5 = Hashing.md5().hashBytes(new byte[0]).asBytes();
    private final Supplier<Set<? extends Location>> locations;
    private final FileSystem fs;

    @Inject
    Nio2BlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, PayloadSlicer slicer, @Provider Supplier<Credentials> creds) {
        super(context, blobUtils, defaultLocation, locations, slicer);
        this.locations = Objects.requireNonNull(locations, "locations");
        this.fs = Jimfs.newFileSystem((Configuration)Configuration.unix().toBuilder().setAttributeViews("posix", new String[]{"user"}).setWorkingDirectory("/").build());
    }

    public Set<? extends Location> listAssignableLocations() {
        return (Set)this.locations.get();
    }

    public PageSet<? extends StorageMetadata> list() {
        ImmutableSortedSet.Builder set = ImmutableSortedSet.naturalOrder();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.fs.getPath("", new String[0]));){
            for (Path path : stream) {
                BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                Date lastModifiedTime = new Date(attr.lastModifiedTime().toMillis());
                Date creationTime = new Date(attr.creationTime().toMillis());
                set.add((Object)new StorageMetadataImpl(StorageType.CONTAINER, null, path.getFileName().toString(), null, null, null, creationTime, lastModifiedTime, Map.of(), null, Tier.STANDARD));
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return new PageSetImpl((Iterable)set.build(), null);
    }

    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        if (!this.containerExists(container)) {
            throw new ContainerNotFoundException(container, "");
        }
        String delimiter = options.getDelimiter();
        if ("".equals(delimiter)) {
            delimiter = null;
        } else if (delimiter != null && !delimiter.equals("/")) {
            throw new IllegalArgumentException("Delimiters other than / not supported");
        }
        Object prefix = options.getPrefix();
        Path dirPrefix = this.fs.getPath(container, new String[0]);
        if (prefix != null) {
            int idx = ((String)prefix).lastIndexOf(47);
            if (idx != -1) {
                dirPrefix = dirPrefix.resolve(((String)prefix).substring(0, idx));
            }
        } else {
            prefix = "";
        }
        prefix = "/" + container + "/" + (String)prefix;
        ImmutableSortedSet.Builder set = ImmutableSortedSet.naturalOrder();
        try {
            Nio2BlobStore.listHelper((ImmutableSortedSet.Builder<StorageMetadata>)set, container, dirPrefix, (String)prefix, delimiter);
            ImmutableSortedSet sorted = set.build();
            if (options.getMarker() != null) {
                boolean found = false;
                for (StorageMetadata blob : sorted) {
                    if (blob.getName().compareTo(options.getMarker()) <= 0) continue;
                    sorted = sorted.tailSet((Object)blob);
                    found = true;
                    break;
                }
                if (!found) {
                    sorted = ImmutableSortedSet.of();
                }
            }
            String marker = null;
            if (options.getMaxResults() != null) {
                StorageMetadata next;
                ImmutableSortedSet temp = ImmutableSortedSet.copyOf((Collection)sorted.stream().limit(options.getMaxResults().intValue()).collect(Collectors.toSet()));
                if (!temp.isEmpty() && (next = (StorageMetadata)sorted.higher((Object)((StorageMetadata)temp.last()))) != null) {
                    marker = ((StorageMetadata)temp.last()).getName();
                }
                sorted = temp;
            }
            return new PageSetImpl((Iterable)sorted, marker);
        }
        catch (IOException ioe) {
            logger.error("unexpected exception", (Throwable)ioe);
            throw new RuntimeException(ioe);
        }
    }

    private static void listHelper(ImmutableSortedSet.Builder<StorageMetadata> builder, String container, Path parent, String prefix, String delimiter) throws IOException {
        logger.debug("recursing at: {} with prefix: {}", (Object)parent, (Object)prefix);
        if (!Files.isDirectory(parent, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(parent);){
            for (Path path : stream) {
                Object eTag;
                logger.debug("examining: {}", (Object)path);
                if (!path.toString().startsWith(prefix.substring(1))) continue;
                if (Files.isDirectory(path, new LinkOption[0])) {
                    UserDefinedFileAttributeView view;
                    if (!"/".equals(delimiter)) {
                        Nio2BlobStore.listHelper(builder, container, path, prefix, delimiter);
                    }
                    if (((view = Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0])) == null || !Set.copyOf(view.list()).contains(XATTR_CONTENT_MD5)) && !"/".equals(delimiter)) continue;
                    String name = path.toString().substring((container + "/").length());
                    builder.add((Object)new StorageMetadataImpl(StorageType.RELATIVE_PATH, null, name + "/", null, null, null, null, null, Map.of(), null, Tier.STANDARD));
                    continue;
                }
                String name = path.toString().substring((container + "/").length());
                logger.debug("adding: {}", (Object)name);
                BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                Date lastModifiedTime = new Date(attr.lastModifiedTime().toMillis());
                Date creationTime = new Date(attr.creationTime().toMillis());
                UserDefinedFileAttributeView view = Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0]);
                Set<String> attributes = Set.copyOf(view.list());
                ByteBuffer buf = ByteBuffer.allocate(view.size(XATTR_CONTENT_MD5));
                view.read(XATTR_CONTENT_MD5, buf);
                byte[] etagBytes = buf.array();
                if (etagBytes.length == 16) {
                    HashCode hashCode = HashCode.fromBytes((byte[])buf.array());
                    eTag = "\"" + String.valueOf(hashCode) + "\"";
                } else {
                    eTag = new String(etagBytes, StandardCharsets.US_ASCII);
                }
                String tierString = Nio2BlobStore.readStringAttributeIfPresent(view, attributes, XATTR_STORAGE_TIER);
                Tier tier = tierString != null ? Tier.valueOf((String)tierString) : Tier.STANDARD;
                builder.add((Object)new StorageMetadataImpl(StorageType.BLOB, null, name, null, null, (String)eTag, creationTime, lastModifiedTime, Map.of(), Long.valueOf(attr.size()), tier));
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    public boolean containerExists(String container) {
        return Files.exists(this.fs.getPath(container, new String[0]), new LinkOption[0]);
    }

    public boolean createContainerInLocation(Location location, String container) {
        return this.createContainerInLocation(location, container, new CreateContainerOptions());
    }

    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        try {
            Files.createDirectory(this.fs.getPath(container, new String[0]), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException faee) {
            return false;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.setContainerAccess(container, options.isPublicRead() ? ContainerAccess.PUBLIC_READ : ContainerAccess.PRIVATE);
        return true;
    }

    public void deleteContainer(String container) {
        try {
            Files.deleteIfExists(this.fs.getPath(container, new String[0]));
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public boolean blobExists(String container, String key) {
        return this.blobMetadata(container, key) != null;
    }

    public Blob getBlob(String container, String key, GetOptions options) {
        if (!this.containerExists(container)) {
            throw new ContainerNotFoundException(container, "");
        }
        Path path = this.fs.getPath(container, key);
        logger.debug("Getting blob at: " + String.valueOf(path));
        try {
            Date unmodifiedSince;
            Date modifiedSince;
            long size;
            InputStream inputStream;
            String tierString;
            Object etagBytes;
            ByteBuffer buf;
            boolean isDirectory = Files.isDirectory(path, new LinkOption[0]);
            BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            UserDefinedFileAttributeView view = Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0]);
            Set<String> attributes = Set.copyOf(view.list());
            String cacheControl = Nio2BlobStore.readStringAttributeIfPresent(view, attributes, XATTR_CACHE_CONTROL);
            String contentDisposition = Nio2BlobStore.readStringAttributeIfPresent(view, attributes, XATTR_CONTENT_DISPOSITION);
            String contentEncoding = Nio2BlobStore.readStringAttributeIfPresent(view, attributes, XATTR_CONTENT_ENCODING);
            String contentLanguage = Nio2BlobStore.readStringAttributeIfPresent(view, attributes, XATTR_CONTENT_LANGUAGE);
            String contentType = isDirectory ? "application/x-directory" : Nio2BlobStore.readStringAttributeIfPresent(view, attributes, XATTR_CONTENT_TYPE);
            Date expires = null;
            HashCode hashCode = null;
            Object eTag = null;
            Tier tier = Tier.STANDARD;
            ImmutableMap.Builder userMetadata = ImmutableMap.builder();
            Date lastModifiedTime = new Date(attr.lastModifiedTime().toMillis());
            Date creationTime = new Date(attr.creationTime().toMillis());
            if (isDirectory) {
                if (!attributes.contains(XATTR_CONTENT_MD5)) {
                    return null;
                }
            } else if (attributes.contains(XATTR_CONTENT_MD5)) {
                buf = ByteBuffer.allocate(view.size(XATTR_CONTENT_MD5));
                view.read(XATTR_CONTENT_MD5, buf);
                etagBytes = buf.array();
                if (((byte[])etagBytes).length == 16) {
                    hashCode = HashCode.fromBytes((byte[])buf.array());
                    eTag = "\"" + String.valueOf(hashCode) + "\"";
                } else {
                    eTag = new String((byte[])etagBytes, StandardCharsets.US_ASCII);
                }
            }
            if (attributes.contains(XATTR_EXPIRES)) {
                buf = ByteBuffer.allocate(view.size(XATTR_EXPIRES));
                view.read(XATTR_EXPIRES, buf);
                buf.flip();
                expires = new Date(buf.asLongBuffer().get());
            }
            if ((tierString = Nio2BlobStore.readStringAttributeIfPresent(view, attributes, XATTR_STORAGE_TIER)) != null) {
                tier = Tier.valueOf((String)tierString);
            }
            etagBytes = attributes.iterator();
            while (etagBytes.hasNext()) {
                String attribute = (String)etagBytes.next();
                if (!attribute.startsWith(XATTR_USER_METADATA_PREFIX)) continue;
                String value = Nio2BlobStore.readStringAttributeIfPresent(view, attributes, attribute);
                userMetadata.put((Object)attribute.substring(XATTR_USER_METADATA_PREFIX.length()), (Object)value);
            }
            String contentRange = null;
            if (isDirectory) {
                inputStream = ByteSource.empty().openStream();
                size = 0L;
            } else {
                inputStream = Files.newInputStream(path, new OpenOption[0]);
                size = attr.size();
                if (options.getRanges().size() > 0) {
                    String range = (String)options.getRanges().get(0);
                    long offset = 0L;
                    long last = size;
                    if (range.startsWith("-")) {
                        offset = last - Long.parseLong(range.substring(1)) + 1L;
                        if (offset < 0L) {
                            offset = 0L;
                        }
                    } else if (range.endsWith("-")) {
                        offset = Long.parseLong(range.substring(0, range.length() - 1));
                    } else if (range.contains("-")) {
                        String[] firstLast = range.split("\\-");
                        offset = Long.parseLong(firstLast[0]);
                        last = Long.parseLong(firstLast[1]);
                    } else {
                        throw new HttpResponseException("illegal range: " + range, null, HttpResponse.builder().statusCode(416).build());
                    }
                    if (offset >= size) {
                        throw new HttpResponseException("illegal range: " + range, null, HttpResponse.builder().statusCode(416).build());
                    }
                    if (last + 1L > size) {
                        last = size - 1L;
                    }
                    ByteStreams.skipFully((InputStream)inputStream, (long)offset);
                    size = last - offset + 1L;
                    inputStream = ByteStreams.limit((InputStream)inputStream, (long)size);
                    contentRange = "bytes " + offset + "-" + last + "/" + attr.size();
                }
            }
            if (eTag != null) {
                HttpResponse response;
                eTag = Nio2BlobStore.maybeQuoteETag((String)eTag);
                if (options.getIfMatch() != null && !((String)eTag).equals(Nio2BlobStore.maybeQuoteETag(options.getIfMatch()))) {
                    response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.PRECONDITION_FAILED.getStatusCode()).addHeader("ETag", new String[]{eTag})).build();
                    throw new HttpResponseException(new HttpCommand(HttpRequest.builder().method("GET").endpoint("http://stub").build()), response);
                }
                if (options.getIfNoneMatch() != null && ((String)eTag).equals(Nio2BlobStore.maybeQuoteETag(options.getIfNoneMatch()))) {
                    response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.NOT_MODIFIED.getStatusCode()).addHeader("ETag", new String[]{eTag})).build();
                    throw new HttpResponseException(new HttpCommand(HttpRequest.builder().method("GET").endpoint("http://stub").build()), response);
                }
            }
            if (options.getIfModifiedSince() != null && lastModifiedTime.before(modifiedSince = options.getIfModifiedSince())) {
                HttpResponse.Builder response = HttpResponse.builder().statusCode(Response.Status.NOT_MODIFIED.getStatusCode());
                if (eTag != null) {
                    response.addHeader("ETag", new String[]{eTag});
                }
                throw new HttpResponseException(String.format("%1$s is before %2$s", lastModifiedTime, modifiedSince), null, response.build());
            }
            if (options.getIfUnmodifiedSince() != null && lastModifiedTime.after(unmodifiedSince = options.getIfUnmodifiedSince())) {
                HttpResponse.Builder response = HttpResponse.builder().statusCode(Response.Status.PRECONDITION_FAILED.getStatusCode());
                if (eTag != null) {
                    response.addHeader("ETag", new String[]{eTag});
                }
                throw new HttpResponseException(String.format("%1$s is after %2$s", lastModifiedTime, unmodifiedSince), null, response.build());
            }
            Blob blob = new BlobBuilderImpl().type(isDirectory ? StorageType.FOLDER : StorageType.BLOB).name(key).userMetadata((Map)userMetadata.build()).payload(inputStream).cacheControl(cacheControl).contentDisposition(contentDisposition).contentEncoding(contentEncoding).contentLanguage(contentLanguage).contentLength(size).contentMD5(hashCode).contentType(contentType).eTag((String)eTag).expires(expires).tier(tier).build();
            blob.getMetadata().setContainer(container);
            blob.getMetadata().setCreationDate(creationTime);
            blob.getMetadata().setLastModified(lastModifiedTime);
            blob.getMetadata().setSize(Long.valueOf(size));
            if (contentRange != null) {
                blob.getAllHeaders().put((Object)"Content-Range", (Object)contentRange);
            }
            if (hashCode != null) {
                blob.getMetadata().setETag(BaseEncoding.base16().lowerCase().encode(hashCode.asBytes()));
            }
            return blob;
        }
        catch (NoSuchFileException nsfe) {
            return null;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public String putBlob(String container, Blob blob) {
        return this.putBlob(container, blob, new PutOptions());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String putBlob(String container, Blob blob, PutOptions options) {
        if (!this.containerExists(container)) {
            throw new ContainerNotFoundException(container, "");
        }
        Path path = this.fs.getPath(container, blob.getMetadata().getName());
        Path tmpPath = this.fs.getPath(container, blob.getMetadata().getName() + "-" + String.valueOf(UUID.randomUUID()));
        logger.debug("Creating blob at: " + String.valueOf(path));
        if (blob.getMetadata().getName().endsWith("/")) {
            try {
                logger.debug("Creating directory blob: {}", (Object)path);
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException faee) {
                logger.debug("Parent directories already exist: {}", (Object)path.getParent());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            UserDefinedFileAttributeView view = Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0]);
            try {
                Nio2BlobStore.writeCommonMetadataAttr(view, blob);
                view.write(XATTR_CONTENT_MD5, ByteBuffer.wrap(DIRECTORY_MD5));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return BaseEncoding.base16().lowerCase().encode(DIRECTORY_MD5);
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException faee) {
            logger.debug("Parent directories already exist: {}", (Object)path.getParent());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        MutableContentMetadata metadata = blob.getMetadata().getContentMetadata();
        try (HashingInputStream is = new HashingInputStream(Hashing.md5(), blob.getPayload().openStream());){
            String string;
            block29: {
                OutputStream os = Files.newOutputStream(tmpPath, new OpenOption[0]);
                try {
                    long count = is.transferTo(os);
                    HashCode actualHashCode = is.hash();
                    HashCode expectedHashCode = metadata.getContentMD5AsHashCode();
                    if (expectedHashCode != null && !actualHashCode.equals((Object)expectedHashCode)) {
                        Files.delete(tmpPath);
                        throw Nio2BlobStore.returnResponseException(400);
                    }
                    UserDefinedFileAttributeView view = Files.getFileAttributeView(tmpPath, UserDefinedFileAttributeView.class, new LinkOption[0]);
                    if (view != null) {
                        try {
                            byte[] eTag = actualHashCode.asBytes();
                            view.write(XATTR_CONTENT_MD5, ByteBuffer.wrap(eTag));
                            Nio2BlobStore.writeStringAttributeIfPresent(view, XATTR_CACHE_CONTROL, metadata.getCacheControl());
                            Nio2BlobStore.writeStringAttributeIfPresent(view, XATTR_CONTENT_DISPOSITION, metadata.getContentDisposition());
                            Nio2BlobStore.writeStringAttributeIfPresent(view, XATTR_CONTENT_ENCODING, metadata.getContentEncoding());
                            Nio2BlobStore.writeStringAttributeIfPresent(view, XATTR_CONTENT_LANGUAGE, metadata.getContentLanguage());
                            Nio2BlobStore.writeStringAttributeIfPresent(view, XATTR_CONTENT_TYPE, metadata.getContentType());
                            Date expires = metadata.getExpires();
                            if (expires != null) {
                                ByteBuffer buf = ByteBuffer.allocate(8).putLong(expires.getTime());
                                buf.flip();
                                view.write(XATTR_EXPIRES, buf);
                            }
                            Nio2BlobStore.writeStringAttributeIfPresent(view, XATTR_STORAGE_TIER, blob.getMetadata().getTier().toString());
                            for (Map.Entry entry : blob.getMetadata().getUserMetadata().entrySet()) {
                                Nio2BlobStore.writeStringAttributeIfPresent(view, XATTR_USER_METADATA_PREFIX + (String)entry.getKey(), (String)entry.getValue());
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    Files.move(tmpPath, path, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                    string = "\"" + String.valueOf(actualHashCode) + "\"";
                    if (os == null) break block29;
                }
                catch (Throwable throwable) {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                os.close();
            }
            return string;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
        String string;
        block25: {
            Date lastModified;
            Blob blob = this.getBlob(fromContainer, fromName);
            if (blob == null) {
                throw new KeyNotFoundException(fromContainer, fromName, "while copying");
            }
            String eTag = blob.getMetadata().getETag();
            if (eTag != null) {
                eTag = Nio2BlobStore.maybeQuoteETag(eTag);
                if (options.ifMatch() != null && !Nio2BlobStore.maybeQuoteETag(options.ifMatch()).equals(eTag)) {
                    throw Nio2BlobStore.returnResponseException(412);
                }
                if (options.ifNoneMatch() != null && Nio2BlobStore.maybeQuoteETag(options.ifNoneMatch()).equals(eTag)) {
                    throw Nio2BlobStore.returnResponseException(412);
                }
            }
            if ((lastModified = blob.getMetadata().getLastModified()) != null) {
                if (options.ifModifiedSince() != null && lastModified.compareTo(options.ifModifiedSince()) <= 0) {
                    throw Nio2BlobStore.returnResponseException(412);
                }
                if (options.ifUnmodifiedSince() != null && lastModified.compareTo(options.ifUnmodifiedSince()) >= 0) {
                    throw Nio2BlobStore.returnResponseException(412);
                }
            }
            InputStream is = blob.getPayload().openStream();
            try {
                ContentMetadata contentMetadata;
                MutableContentMetadata metadata = blob.getMetadata().getContentMetadata();
                BlobBuilder.PayloadBlobBuilder builder = this.blobBuilder(toName).payload(is);
                Long contentLength = metadata.getContentLength();
                if (contentLength != null) {
                    builder.contentLength(contentLength.longValue());
                }
                if ((contentMetadata = options.contentMetadata()) != null) {
                    String contentType;
                    String contentLanguage;
                    String contentEncoding;
                    String contentDisposition;
                    String cacheControl = contentMetadata.getCacheControl();
                    if (cacheControl != null) {
                        builder.cacheControl(cacheControl);
                    }
                    if ((contentDisposition = contentMetadata.getContentDisposition()) != null) {
                        builder.contentDisposition(contentDisposition);
                    }
                    if ((contentEncoding = contentMetadata.getContentEncoding()) != null) {
                        builder.contentEncoding(contentEncoding);
                    }
                    if ((contentLanguage = contentMetadata.getContentLanguage()) != null) {
                        builder.contentLanguage(contentLanguage);
                    }
                    if ((contentType = contentMetadata.getContentType()) != null) {
                        builder.contentType(contentType);
                    }
                } else {
                    builder.cacheControl(metadata.getCacheControl()).contentDisposition(metadata.getContentDisposition()).contentEncoding(metadata.getContentEncoding()).contentLanguage(metadata.getContentLanguage()).contentType(metadata.getContentType());
                }
                Map userMetadata = options.userMetadata();
                if (userMetadata != null) {
                    builder.userMetadata(userMetadata);
                } else {
                    builder.userMetadata(blob.getMetadata().getUserMetadata());
                }
                string = this.putBlob(toContainer, builder.build());
                if (is == null) break block25;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            is.close();
        }
        return string;
    }

    public void removeBlob(String container, String key) {
        try {
            Path path = this.fs.getPath(container, key);
            Files.delete(path);
            Nio2BlobStore.removeEmptyParentDirectories(path.getParent());
        }
        catch (NoSuchFileException nsfe) {
            return;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public BlobMetadata blobMetadata(String container, String key) {
        Blob blob = this.getBlob(container, key);
        if (blob == null) {
            return null;
        }
        try {
            blob.getPayload().openStream().close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return blob != null ? BlobStoreUtils.copy((MutableBlobMetadata)blob.getMetadata()) : null;
    }

    protected boolean deleteAndVerifyContainerGone(String container) {
        this.deleteContainer(container);
        return !this.containerExists(container);
    }

    public ContainerAccess getContainerAccess(String container) {
        Set<PosixFilePermission> permissions;
        if (!this.containerExists(container)) {
            throw new ContainerNotFoundException(container, "");
        }
        Path path = this.fs.getPath(container, new String[0]);
        try {
            permissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return permissions.contains((Object)PosixFilePermission.OTHERS_READ) ? ContainerAccess.PUBLIC_READ : ContainerAccess.PRIVATE;
    }

    public void setContainerAccess(String container, ContainerAccess access) {
        if (!this.containerExists(container)) {
            throw new ContainerNotFoundException(container, "");
        }
        Path path = this.fs.getPath(container, new String[0]);
        try {
            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(path, new LinkOption[0]));
            if (access == ContainerAccess.PRIVATE) {
                permissions.remove((Object)PosixFilePermission.OTHERS_READ);
            } else if (access == ContainerAccess.PUBLIC_READ) {
                permissions.add(PosixFilePermission.OTHERS_READ);
            }
            Files.setPosixFilePermissions(path, permissions);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public BlobAccess getBlobAccess(String container, String key) {
        Set<PosixFilePermission> permissions;
        if (!this.containerExists(container)) {
            throw new ContainerNotFoundException(container, "");
        }
        if (!this.blobExists(container, key)) {
            throw new KeyNotFoundException(container, key, "");
        }
        Path path = this.fs.getPath(container, key);
        try {
            permissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return permissions.contains((Object)PosixFilePermission.OTHERS_READ) ? BlobAccess.PUBLIC_READ : BlobAccess.PRIVATE;
    }

    public void setBlobAccess(String container, String key, BlobAccess access) {
        if (!this.containerExists(container)) {
            throw new ContainerNotFoundException(container, "");
        }
        if (!this.blobExists(container, key)) {
            throw new KeyNotFoundException(container, key, "");
        }
        Path path = this.fs.getPath(container, key);
        try {
            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(path, new LinkOption[0]));
            if (access == BlobAccess.PRIVATE) {
                permissions.remove((Object)PosixFilePermission.OTHERS_READ);
            } else if (access == BlobAccess.PUBLIC_READ) {
                permissions.add(PosixFilePermission.OTHERS_READ);
            }
            Files.setPosixFilePermissions(path, permissions);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, PutOptions options) {
        String uploadId = UUID.randomUUID().toString();
        Blob blob = this.blobBuilder(MULTIPART_PREFIX + uploadId + "-" + blobMetadata.getName() + "-stub").payload(ByteSource.empty()).build();
        this.putBlob(container, blob);
        return MultipartUpload.create((String)container, (String)blobMetadata.getName(), (String)uploadId, (BlobMetadata)blobMetadata, (PutOptions)options);
    }

    public void abortMultipartUpload(MultipartUpload mpu) {
        List<MultipartPart> parts = this.listMultipartUpload(mpu);
        for (MultipartPart part : parts) {
            this.removeBlob(mpu.containerName(), MULTIPART_PREFIX + mpu.id() + "-" + mpu.blobName() + "-" + part.partNumber());
        }
        this.removeBlob(mpu.containerName(), MULTIPART_PREFIX + mpu.id() + "-" + mpu.blobName() + "-stub");
    }

    public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
        Tier tier;
        Date expires;
        String contentType;
        String contentLanguage;
        String contentEncoding;
        String contentDisposition;
        ImmutableList.Builder metas = ImmutableList.builder();
        long contentLength = 0L;
        Hasher md5Hasher = Hashing.md5().newHasher();
        for (MultipartPart part : parts) {
            BlobMetadata meta = this.blobMetadata(mpu.containerName(), MULTIPART_PREFIX + mpu.id() + "-" + mpu.blobName() + "-" + part.partNumber());
            contentLength += meta.getContentMetadata().getContentLength().longValue();
            metas.add((Object)meta);
            if (meta.getETag() == null) continue;
            String eTag = meta.getETag();
            if (eTag.startsWith("\"") && eTag.endsWith("\"") && eTag.length() >= 2) {
                eTag = eTag.substring(1, eTag.length() - 1);
            }
            md5Hasher.putBytes(BaseEncoding.base16().lowerCase().decode((CharSequence)eTag));
        }
        String mpuETag = "\"" + md5Hasher.hash() + "-" + parts.size() + "\"";
        BlobBuilder.PayloadBlobBuilder blobBuilder = this.blobBuilder(mpu.blobName()).userMetadata(mpu.blobMetadata().getUserMetadata()).payload((InputStream)new MultiBlobInputStream((BlobStore)this, (List<BlobMetadata>)metas.build())).contentLength(contentLength).eTag(mpuETag);
        String cacheControl = mpu.blobMetadata().getContentMetadata().getCacheControl();
        if (cacheControl != null) {
            blobBuilder.cacheControl(cacheControl);
        }
        if ((contentDisposition = mpu.blobMetadata().getContentMetadata().getContentDisposition()) != null) {
            blobBuilder.contentDisposition(contentDisposition);
        }
        if ((contentEncoding = mpu.blobMetadata().getContentMetadata().getContentEncoding()) != null) {
            blobBuilder.contentEncoding(contentEncoding);
        }
        if ((contentLanguage = mpu.blobMetadata().getContentMetadata().getContentLanguage()) != null) {
            blobBuilder.contentLanguage(contentLanguage);
        }
        if ((contentType = mpu.blobMetadata().getContentMetadata().getContentType()) != null) {
            blobBuilder.contentType(contentType);
        }
        if ((expires = mpu.blobMetadata().getContentMetadata().getExpires()) != null) {
            blobBuilder.expires(expires);
        }
        if ((tier = mpu.blobMetadata().getTier()) != null) {
            blobBuilder.tier(tier);
        }
        this.putBlob(mpu.containerName(), blobBuilder.build());
        for (MultipartPart part : parts) {
            this.removeBlob(mpu.containerName(), MULTIPART_PREFIX + mpu.id() + "-" + mpu.blobName() + "-" + part.partNumber());
        }
        this.removeBlob(mpu.containerName(), MULTIPART_PREFIX + mpu.id() + "-" + mpu.blobName() + "-stub");
        this.setBlobAccess(mpu.containerName(), mpu.blobName(), mpu.putOptions().getBlobAccess());
        return mpuETag;
    }

    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        String partName = MULTIPART_PREFIX + mpu.id() + "-" + mpu.blobName() + "-" + partNumber;
        Blob blob = this.blobBuilder(partName).payload(payload).build();
        String partETag = this.putBlob(mpu.containerName(), blob);
        BlobMetadata metadata = this.blobMetadata(mpu.containerName(), partName);
        Long partSize = metadata.getContentMetadata().getContentLength();
        return MultipartPart.create((int)partNumber, (long)partSize, (String)partETag, (Date)metadata.getLastModified());
    }

    public List<MultipartPart> listMultipartUpload(MultipartUpload mpu) {
        ImmutableList.Builder parts = ImmutableList.builder();
        ListContainerOptions options = new ListContainerOptions().prefix(MULTIPART_PREFIX + mpu.id() + "-" + mpu.blobName() + "-").recursive();
        while (true) {
            PageSet<? extends StorageMetadata> pageSet = this.list(mpu.containerName(), options);
            for (StorageMetadata sm : pageSet) {
                if (sm.getName().endsWith("-stub")) continue;
                int partNumber = Integer.parseInt(sm.getName().substring((MULTIPART_PREFIX + mpu.id() + "-" + mpu.blobName() + "-").length()));
                long partSize = sm.getSize();
                parts.add((Object)MultipartPart.create((int)partNumber, (long)partSize, (String)sm.getETag(), (Date)sm.getLastModified()));
            }
            if (pageSet.isEmpty() || pageSet.getNextMarker() == null) break;
            options.afterMarker(pageSet.getNextMarker());
        }
        return parts.build();
    }

    public List<MultipartUpload> listMultipartUploads(String container) {
        ImmutableList.Builder mpus = ImmutableList.builder();
        ListContainerOptions options = new ListContainerOptions().prefix(MULTIPART_PREFIX).recursive();
        int uuidLength = UUID.randomUUID().toString().length();
        while (true) {
            PageSet<? extends StorageMetadata> pageSet = this.list(container, options);
            for (StorageMetadata sm : pageSet) {
                if (!sm.getName().endsWith("-stub")) continue;
                String uploadId = sm.getName().substring(MULTIPART_PREFIX.length(), MULTIPART_PREFIX.length() + uuidLength);
                String blobName = sm.getName().substring(MULTIPART_PREFIX.length() + uuidLength + 1);
                int index = blobName.lastIndexOf(45);
                blobName = blobName.substring(0, index);
                mpus.add((Object)MultipartUpload.create((String)container, (String)blobName, (String)uploadId, null, null));
            }
            if (pageSet.isEmpty() || pageSet.getNextMarker() == null) break;
            options.afterMarker(pageSet.getNextMarker());
        }
        return mpus.build();
    }

    public long getMinimumMultipartPartSize() {
        return 1L;
    }

    public long getMaximumMultipartPartSize() {
        return 0x6400000L;
    }

    public int getMaximumNumberOfParts() {
        return 50000;
    }

    public InputStream streamBlob(String container, String name) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    private static String readStringAttributeIfPresent(UserDefinedFileAttributeView view, Set<String> attr, String name) throws IOException {
        if (!attr.contains(name)) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.allocate(view.size(name));
        view.read(name, buf);
        return new String(buf.array(), StandardCharsets.UTF_8);
    }

    private static void writeStringAttributeIfPresent(UserDefinedFileAttributeView view, String name, String value) throws IOException {
        if (value != null) {
            view.write(name, ByteBuffer.wrap(value.getBytes(StandardCharsets.UTF_8)));
        }
    }

    private static HttpResponseException returnResponseException(int code) {
        HttpResponse response = HttpResponse.builder().statusCode(code).build();
        return new HttpResponseException(new HttpCommand(HttpRequest.builder().method("GET").endpoint("http://stub").build()), response);
    }

    private static String maybeQuoteETag(String eTag) {
        if (!((String)eTag).startsWith("\"") && !((String)eTag).endsWith("\"")) {
            eTag = "\"" + (String)eTag + "\"";
        }
        return eTag;
    }

    private static void removeEmptyParentDirectories(Path path) throws IOException {
        UserDefinedFileAttributeView view;
        Path parent;
        while (!((parent = path.getParent()) == null || parent.equals(path.getRoot()) || (view = Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0])) != null && Set.copyOf(view.list()).contains(XATTR_CONTENT_MD5))) {
            try {
                logger.debug("deleting: {}", (Object)path);
                Files.delete(path);
            }
            catch (DirectoryNotEmptyException dnee) {
                break;
            }
            path = path.getParent();
        }
    }

    private static void writeCommonMetadataAttr(UserDefinedFileAttributeView view, Blob blob) throws IOException {
        MutableContentMetadata metadata = blob.getMetadata().getContentMetadata();
        Nio2BlobStore.writeStringAttributeIfPresent(view, XATTR_CACHE_CONTROL, metadata.getCacheControl());
        Nio2BlobStore.writeStringAttributeIfPresent(view, XATTR_CONTENT_DISPOSITION, metadata.getContentDisposition());
        Nio2BlobStore.writeStringAttributeIfPresent(view, XATTR_CONTENT_ENCODING, metadata.getContentEncoding());
        Nio2BlobStore.writeStringAttributeIfPresent(view, XATTR_CONTENT_LANGUAGE, metadata.getContentLanguage());
        Nio2BlobStore.writeStringAttributeIfPresent(view, XATTR_CONTENT_TYPE, metadata.getContentType());
        Date expires = metadata.getExpires();
        if (expires != null) {
            ByteBuffer buf = ByteBuffer.allocate(8).putLong(expires.getTime());
            buf.flip();
            view.write(XATTR_EXPIRES, buf);
        }
        Nio2BlobStore.writeStringAttributeIfPresent(view, XATTR_STORAGE_TIER, blob.getMetadata().getTier().toString());
        for (Map.Entry entry : blob.getMetadata().getUserMetadata().entrySet()) {
            Nio2BlobStore.writeStringAttributeIfPresent(view, XATTR_USER_METADATA_PREFIX + (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static final class MultiBlobInputStream
    extends InputStream {
        private final BlobStore blobStore;
        private final Iterator<BlobMetadata> metas;
        private InputStream current;

        MultiBlobInputStream(BlobStore blobStore, List<BlobMetadata> metas) {
            this.blobStore = blobStore;
            this.metas = metas.iterator();
        }

        @Override
        public int read() throws IOException {
            int result;
            while (true) {
                if (this.current == null) {
                    if (!this.metas.hasNext()) {
                        return -1;
                    }
                    BlobMetadata meta = this.metas.next();
                    this.current = this.blobStore.getBlob(meta.getContainer(), meta.getName()).getPayload().openStream();
                }
                if ((result = this.current.read()) != -1) break;
                this.current.close();
                this.current = null;
            }
            return result & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result;
            while (true) {
                if (this.current == null) {
                    if (!this.metas.hasNext()) {
                        return -1;
                    }
                    BlobMetadata meta = this.metas.next();
                    this.current = this.blobStore.getBlob(meta.getContainer(), meta.getName()).getPayload().openStream();
                }
                if ((result = this.current.read(b, off, len)) != -1) break;
                this.current.close();
                this.current = null;
            }
            return result;
        }

        @Override
        public void close() throws IOException {
            if (this.current != null) {
                this.current.close();
                this.current = null;
            }
        }
    }
}

