/*
 * Decompiled with CFR 0.152.
 */
package geb.waiting;

import geb.error.GebAssertionError;
import geb.waiting.Wait;

public class WaitTimeoutException
extends GebAssertionError {
    protected Object lastEvaluationValue;
    protected Wait wait;

    public WaitTimeoutException(Wait wait) {
        this(wait, null, null);
    }

    public WaitTimeoutException(Wait wait, Throwable cause) {
        this(wait, cause, null);
    }

    public WaitTimeoutException(Wait wait, Throwable cause, Object lastEvaluationValue) {
        super((Object)WaitTimeoutException.toMessage(wait, cause), cause);
        this.wait = wait;
        this.lastEvaluationValue = lastEvaluationValue;
    }

    private static String toMessage(Wait wait, Throwable cause) {
        StringBuilder message = new StringBuilder(String.format("condition did not pass in %s seconds", wait.getTimeout()));
        if (wait.getCustomMessage() != null) {
            message.append(String.format("(%s)", wait.getCustomMessage()));
        }
        if (cause != null) {
            if (wait.getIncludeCauseInExceptionMessage()) {
                message.append(String.format(". Failed with exception:%n%s", cause));
            } else {
                message.append(" (failed with exception)");
            }
        }
        return message.toString();
    }

    public Object getLastEvaluationValue() {
        return this.lastEvaluationValue;
    }
}

