/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.date;

import org.gedcomx.date.GedcomxDate;
import org.gedcomx.date.GedcomxDateDuration;
import org.gedcomx.date.GedcomxDateException;
import org.gedcomx.date.GedcomxDateSimple;
import org.gedcomx.date.GedcomxDateType;
import org.gedcomx.date.GedcomxDateUtil;

public class GedcomxDateRange
extends GedcomxDate {
    private boolean approximate = false;
    private GedcomxDateSimple start = null;
    private GedcomxDateDuration duration = null;
    private GedcomxDateSimple end = null;

    public GedcomxDateRange(String date) {
        if (date == null || date.length() < 1) {
            throw new GedcomxDateException("Invalid Range");
        }
        String range = date;
        if (date.charAt(0) == 'A') {
            this.approximate = true;
            range = date.substring(1);
        }
        if (!date.contains("/")) {
            throw new GedcomxDateException("Invalid Range: / is required");
        }
        String[] parts = range.split("/");
        if (parts.length < 1 || parts.length > 2) {
            throw new GedcomxDateException("Invalid Range: One or two parts are required");
        }
        if (!parts[0].equals("")) {
            try {
                this.start = new GedcomxDateSimple(parts[0]);
            }
            catch (GedcomxDateException e) {
                throw new GedcomxDateException(e.getMessage() + " in Range Start Date");
            }
        }
        if (parts.length == 2) {
            if (parts[1].charAt(0) == 'P') {
                if (this.start == null) {
                    throw new GedcomxDateException("Invalid Range: A range may not end with a duration if missing a start date");
                }
                try {
                    this.duration = new GedcomxDateDuration(parts[1]);
                }
                catch (GedcomxDateException e) {
                    throw new GedcomxDateException(e.getMessage() + " in Range End Duration");
                }
                this.end = GedcomxDateUtil.addDuration(this.start, this.duration);
            } else {
                try {
                    this.end = new GedcomxDateSimple(parts[1]);
                }
                catch (GedcomxDateException e) {
                    throw new GedcomxDateException(e.getMessage() + " in Range End Date");
                }
                if (this.start != null) {
                    this.duration = GedcomxDateUtil.getDuration(this.start, this.end);
                }
            }
        }
    }

    public GedcomxDateSimple getStart() {
        return this.start;
    }

    public GedcomxDateDuration getDuration() {
        return this.duration;
    }

    public GedcomxDateSimple getEnd() {
        return this.end;
    }

    @Override
    public GedcomxDateType getType() {
        return GedcomxDateType.RANGE;
    }

    @Override
    public boolean isApproximate() {
        return this.approximate;
    }

    @Override
    public String toFormalString() {
        StringBuilder range = new StringBuilder();
        if (this.approximate) {
            range.append('A');
        }
        if (this.start != null) {
            range.append(this.start.toFormalString());
        }
        range.append('/');
        if (this.duration != null) {
            range.append(this.duration.toFormalString());
        } else if (this.end != null) {
            range.append(this.end.toFormalString());
        }
        return range.toString();
    }
}

