/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.date;

import org.gedcomx.date.GedcomxDate;
import org.gedcomx.date.GedcomxDateDuration;
import org.gedcomx.date.GedcomxDateException;
import org.gedcomx.date.GedcomxDateRange;
import org.gedcomx.date.GedcomxDateSimple;
import org.gedcomx.date.GedcomxDateType;
import org.gedcomx.date.GedcomxDateUtil;

public class GedcomxDateRecurring
extends GedcomxDate {
    private Integer count = null;
    private GedcomxDateRange range;
    private GedcomxDateSimple end = null;

    public GedcomxDateRecurring(String date) {
        if (date == null || date.length() < 3) {
            throw new GedcomxDateException("Invalid Recurring Date");
        }
        if (date.charAt(0) != 'R') {
            throw new GedcomxDateException("Invalid Recurring Date: Must start with R");
        }
        String[] parts = date.split("/");
        if (parts.length != 3) {
            throw new GedcomxDateException("Invalid Recurring Date: Must contain 3 parts");
        }
        if (parts[1].equals("") || parts[2].equals("")) {
            throw new GedcomxDateException("Invalid Recurring Date: Range must have a start and an end");
        }
        String countNum = parts[0].substring(1);
        char[] countNumChars = parts[0].substring(1).toCharArray();
        if (countNumChars.length > 0) {
            for (char c : countNumChars) {
                if (Character.isDigit(c)) continue;
                throw new GedcomxDateException("Invalid Recurring Date: Malformed Count");
            }
            this.count = Integer.valueOf(countNum);
        }
        try {
            this.range = new GedcomxDateRange(parts[1] + "/" + parts[2]);
        }
        catch (GedcomxDateException e) {
            throw new GedcomxDateException(e.getMessage() + " in Recurring Range");
        }
        if (this.count != null) {
            this.end = this.getNth(this.count);
        }
    }

    public Integer getCount() {
        return this.count;
    }

    public GedcomxDateRange getRange() {
        return this.range;
    }

    public GedcomxDateSimple getStart() {
        return this.range.getStart();
    }

    public GedcomxDateDuration getDuration() {
        return this.range.getDuration();
    }

    public GedcomxDateSimple getEnd() {
        return this.end;
    }

    public GedcomxDateSimple getNth(Integer count) {
        GedcomxDateDuration duration = GedcomxDateUtil.multiplyDuration(this.range.getDuration(), count);
        return GedcomxDateUtil.addDuration(this.range.getStart(), duration);
    }

    @Override
    public GedcomxDateType getType() {
        return GedcomxDateType.RECURRING;
    }

    @Override
    public boolean isApproximate() {
        return false;
    }

    @Override
    public String toFormalString() {
        if (this.count != null) {
            return "R" + this.count + "/" + this.range.toFormalString();
        }
        return "R/" + this.range.toFormalString();
    }
}

