/*
 * Decompiled with CFR 0.152.
 */
package org.genantics.array;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.genantics.access.ConditionalVisitor;
import org.genantics.access.DefaultIterator;
import org.genantics.access.Visitor;
import org.genantics.array.IndexedAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Array<V>
implements IndexedAccess<V> {
    private static final int ElEMENTS_LENGTH = 32;
    private static final int ELEMENTS_SHIFT = 5;
    private static final int ELEMENTS_MASK = 31;
    public static final Array EMPTY = new Empty();

    public static Array newArray(int size, Object initialValue) {
        if (size < 0) {
            throw new ArrayIndexOutOfBoundsException("" + size);
        }
        if (size == 0) {
            return EMPTY;
        }
        int height = 0;
        for (int n = size; n != 0; n >>= 5) {
            ++height;
        }
        int[] sizeSoFar = new int[1];
        return Array.createAndFill(size, initialValue, height, sizeSoFar);
    }

    private static Array createAndFill(int size, Object initialValue, int height, int[] sizeSoFar) {
        if (height == 1) {
            Values values = new Values();
            int max = Math.min(32, sizeSoFar[0]);
            for (int i = 0; i < max; ++i) {
                values.elements[i] = initialValue;
            }
            values.size = max;
            sizeSoFar[0] = sizeSoFar[0] + max;
            return values;
        }
        References references = new References();
        int startSize = sizeSoFar[0];
        for (int i = 0; i < 32 && sizeSoFar[0] < size; ++i) {
            references.refs[i] = Array.createAndFill(size, initialValue, height - 1, sizeSoFar);
        }
        references.size = sizeSoFar[0] - startSize;
        references.shift = 5 * height;
        references.mask = (1 << references.shift) - 1;
        return references;
    }

    protected abstract ArrayState getNext(int var1, Stack<ArrayState> var2);

    protected abstract ArrayState getPrev(int var1, Stack<ArrayState> var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class References<V>
    extends Array<V> {
        Array[] refs = new Array[32];
        int size;
        int shift;
        int mask;

        References() {
        }

        References(References other) {
            System.arraycopy(other.refs, 0, this.refs, 0, 32);
            this.size = other.size;
            this.shift = other.shift;
            this.mask = other.mask;
        }

        @Override
        protected ArrayState getNext(int index, Stack<ArrayState> stack) {
            if (++index < this.size) {
                stack.push(new ArrayState(this, index));
                Array array = this.refs[index >>> this.shift];
                return array.getNext(-1, stack);
            }
            if (stack.isEmpty()) {
                return null;
            }
            ArrayState state = stack.pop();
            return state.array.getNext(state.index, stack);
        }

        @Override
        protected ArrayState getPrev(int index, Stack<ArrayState> stack) {
            if (index < 0) {
                index = this.size;
            }
            if (--index >= 0) {
                stack.push(new ArrayState(this, index));
                Array array = this.refs[index >>> this.shift];
                return array.getNext(-1, stack);
            }
            if (stack.isEmpty()) {
                return null;
            }
            ArrayState state = stack.pop();
            return state.array.getNext(state.index, stack);
        }

        private void checkIndex(int i) {
            if (i < 0 || i > this.size) {
                throw new ArrayIndexOutOfBoundsException("" + i + " for array size " + this.size);
            }
        }

        @Override
        public V get(int i) {
            this.checkIndex(i);
            Array lower = this.refs[i >>> this.shift];
            return lower.get(i & this.mask);
        }

        @Override
        public Array<V> set(int i, V value) {
            this.checkIndex(i);
            int index = i >>> this.shift;
            Array lower = this.refs[index];
            Array<V> newLower = lower.set(i & this.mask, value);
            References<V> newThis = new References<V>(this);
            newThis.refs[index] = newLower;
            return newThis;
        }

        @Override
        public int find(V value) {
            int max = this.size >>> this.shift;
            for (int i = 0; i < max; ++i) {
                int result = this.refs[i].find(value);
                if (result < 0) continue;
                return result;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean contains(V value) {
            return this.find(value) >= 0;
        }

        @Override
        public Iterator<V> iterator() {
            return new ArrayIterator();
        }

        @Override
        public Iterator<V> reverseIterator() {
            return new ReverseArrayIterator();
        }

        @Override
        public void visit(Visitor<V> visitor) {
            int max = this.size >>> this.shift;
            for (int i = 0; i < max; ++i) {
                this.refs[i].visit(visitor);
            }
        }

        @Override
        public boolean visit(ConditionalVisitor<V> visitor) {
            int max = this.size >>> this.shift;
            for (int i = 0; i < max; ++i) {
                if (!this.refs[i].visit(visitor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void reverseVisit(Visitor<V> visitor) {
            int max = this.size >>> this.shift;
            for (int i = max - 1; i >= 0; --i) {
                this.refs[i].visit(visitor);
            }
        }

        @Override
        public boolean reverseVisit(ConditionalVisitor<V> visitor) {
            int max = this.size >>> this.shift;
            for (int i = max - 1; i >= 0; --i) {
                if (!this.refs[i].visit(visitor)) continue;
                return true;
            }
            return false;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ReverseArrayIterator
        extends DefaultIterator<V> {
            ArrayState current;
            Stack<ArrayState> stack = new Stack();

            public ReverseArrayIterator() {
                this.current = References.this.getPrev(-1, this.stack);
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public V next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                Object tmp = this.current.array.get(this.current.index);
                this.current = this.current.array.getPrev(this.current.index, this.stack);
                return tmp;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ArrayIterator
        extends DefaultIterator<V> {
            ArrayState current;
            Stack<ArrayState> stack = new Stack();

            public ArrayIterator() {
                this.current = References.this.getNext(-1, this.stack);
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public V next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                Object tmp = this.current.array.get(this.current.index);
                this.current = this.current.array.getNext(this.current.index, this.stack);
                return tmp;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Values<V>
    extends Array<V> {
        Object[] elements = new Object[32];
        int size;

        private Values() {
        }

        private Values(Values<V> other) {
            this.size = other.size;
            System.arraycopy(other.elements, 0, this.elements, 0, this.size);
        }

        @Override
        protected ArrayState getNext(int index, Stack<ArrayState> stack) {
            if (++index < this.size) {
                return new ArrayState(this, index);
            }
            if (stack.isEmpty()) {
                return null;
            }
            ArrayState state = stack.pop();
            return state.array.getNext(state.index, stack);
        }

        @Override
        protected ArrayState getPrev(int index, Stack<ArrayState> stack) {
            if (index < 0) {
                index = this.size;
            }
            if (--index >= 0) {
                return new ArrayState(this, index);
            }
            if (stack.isEmpty()) {
                return null;
            }
            ArrayState state = stack.pop();
            return state.array.getNext(state.index, stack);
        }

        private void checkIndex(int i) {
            if (i > this.size) {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public V get(int i) {
            this.checkIndex(i);
            return (V)this.elements[i];
        }

        public void checkNull(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public Array<V> set(int i, V value) {
            this.checkIndex(i);
            this.checkNull(value);
            Values<V> values = new Values<V>(this);
            values.elements[i] = value;
            return values;
        }

        @Override
        public int find(V value) {
            this.checkNull(value);
            for (int i = 0; i < this.size; ++i) {
                if (!value.equals(this.elements[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean contains(V value) {
            return this.find(value) >= 0;
        }

        @Override
        public Iterator<V> iterator() {
            return new DefaultIterator<V>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < Values.this.size;
                }

                @Override
                public V next() {
                    if (this.i == Values.this.size) {
                        throw new NoSuchElementException();
                    }
                    return Values.this.elements[this.i++];
                }
            };
        }

        @Override
        public Iterator<V> reverseIterator() {
            return new DefaultIterator<V>(){
                int i;
                {
                    this.i = Values.this.size - 1;
                }

                @Override
                public boolean hasNext() {
                    return this.i >= 0;
                }

                @Override
                public V next() {
                    if (this.i < 0) {
                        throw new NoSuchElementException();
                    }
                    return Values.this.elements[this.i--];
                }
            };
        }

        @Override
        public void visit(Visitor<V> visitor) {
            for (int i = 0; i < this.size; ++i) {
                visitor.visit(this.elements[i]);
            }
        }

        @Override
        public boolean visit(ConditionalVisitor<V> visitor) {
            for (int i = 0; i < this.size; ++i) {
                if (!visitor.visit(this.elements[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public void reverseVisit(Visitor<V> visitor) {
            for (int i = this.size - 1; i >= 0; --i) {
                visitor.visit(this.elements[i]);
            }
        }

        @Override
        public boolean reverseVisit(ConditionalVisitor<V> visitor) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!visitor.visit(this.elements[i])) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Empty<V>
    extends Array<V> {
        protected Empty() {
        }

        @Override
        protected ArrayState getNext(int index, Stack<ArrayState> stack) {
            return null;
        }

        @Override
        protected ArrayState getPrev(int index, Stack<ArrayState> stack) {
            return null;
        }

        @Override
        public V get(int i) {
            throw new ArrayIndexOutOfBoundsException("" + i);
        }

        @Override
        public Array<V> set(int i, V value) {
            throw new ArrayIndexOutOfBoundsException("" + i);
        }

        @Override
        public int find(V value) {
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(V value) {
            return false;
        }

        @Override
        public Iterator<V> iterator() {
            return new DefaultIterator<V>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public V next() {
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public Iterator<V> reverseIterator() {
            return this.iterator();
        }

        @Override
        public void visit(Visitor<V> visitor) {
        }

        @Override
        public boolean visit(ConditionalVisitor<V> visitor) {
            return false;
        }

        @Override
        public void reverseVisit(Visitor<V> visitor) {
        }

        @Override
        public boolean reverseVisit(ConditionalVisitor<V> visitor) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ArrayState {
        Array<V> array;
        int index;

        public ArrayState(Array<V> array2, int index) {
            this.array = array2;
            this.index = index;
        }
    }
}

