/*
 * Decompiled with CFR 0.152.
 */
package org.genantics.list;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.genantics.access.ConditionalVisitor;
import org.genantics.access.DefaultIterator;
import org.genantics.access.Visitor;
import org.genantics.list.CList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodedList<V>
implements CList<V> {
    private static final int ELEMENTS_LENGTH = 14;
    Object[] elements = new Object[14];
    CList<V> rest;
    int size;
    int restSize;

    protected CodedList(V element, CList<V> list) {
        if (list == CList.NIL) {
            this.rest = list;
        } else {
            CodedList other = (CodedList)list;
            if (other.size < other.elements.length) {
                this.elements = other.elements;
                this.size = other.size;
                this.rest = other.rest;
                this.restSize = other.restSize;
            } else {
                this.rest = other;
                this.restSize = other.restSize + other.size;
            }
        }
        this.elements[this.size++] = element;
    }

    protected CodedList(V element, CodedList<V> list, int pos) {
        this.elements = list.elements;
        this.size = pos;
        this.rest = list.rest;
        this.restSize = list.restSize;
        this.elements[this.size++] = element;
    }

    protected CodedList(CodedList<V> other) {
        this.elements = other.elements;
        this.size = other.size;
        this.rest = other.rest;
        this.restSize = other.restSize;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this.size + this.restSize;
    }

    @Override
    public boolean contains(V element) {
        return this.contains(element, this.size);
    }

    protected boolean contains(V element, int pos) {
        CodedList list = this;
        while (list != CList.NIL) {
            for (int i = pos - 1; i >= 0; --i) {
                if (!element.equals(list.elements[i])) continue;
                return true;
            }
            list = (CodedList)list.rest;
            pos = list.size;
        }
        return false;
    }

    @Override
    public CList<V> cons(V element) {
        return new CodedList<V>(element, this);
    }

    @Override
    public V head() {
        return (V)this.elements[this.size - 1];
    }

    @Override
    public CList<V> tail() {
        if (this.size > 1) {
            return new CodedSlice(this.size - 1);
        }
        return this.rest;
    }

    protected void visit(Visitor<V> visitor, int pos) {
        CodedList list = this;
        while (list != CList.NIL) {
            for (int i = pos - 1; i >= 0; --i) {
                visitor.visit(list.elements[i]);
            }
            list = (CodedList)list.rest;
            pos = list.size;
        }
    }

    protected boolean visit(ConditionalVisitor<V> visitor, int pos) {
        CodedList list = this;
        while (list != CList.NIL) {
            for (int i = pos - 1; i >= 0; --i) {
                if (!visitor.visit(list.elements[i])) continue;
                return true;
            }
            list = (CodedList)list.rest;
            pos = list.size;
        }
        return false;
    }

    protected void reverseVisit(Visitor<V> visitor, int pos, CList<V> last) {
        if (this.rest != NIL) {
            ((CodedList)this.rest).reverseVisit(visitor, pos, last);
        }
        int max = last == this ? pos : this.size;
        for (int i = 0; i < max; ++i) {
            visitor.visit(this.elements[i]);
        }
    }

    protected boolean reverseVisit(ConditionalVisitor<V> visitor, int pos, CList<V> last) {
        if (this.rest != NIL && ((CodedList)this.rest).reverseVisit(visitor, pos, last)) {
            return true;
        }
        int max = last == this ? pos : this.size;
        for (int i = 0; i < max; ++i) {
            if (!visitor.visit(this.elements[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(Visitor<V> visitor) {
        this.visit(visitor, this.size);
    }

    @Override
    public boolean visit(ConditionalVisitor<V> visitor) {
        return this.visit(visitor, this.size);
    }

    @Override
    public void reverseVisit(Visitor<V> visitor) {
        this.reverseVisit(visitor, this.size, this);
    }

    @Override
    public boolean reverseVisit(ConditionalVisitor<V> visitor) {
        return this.reverseVisit(visitor, this.size, this);
    }

    protected void toCollection(Collection<V> collection, int pos) {
        CodedList list = this;
        while (list != CList.NIL) {
            for (int i = pos - 1; i >= 0; --i) {
                collection.add(list.elements[i]);
            }
            list = (CodedList)list.rest;
            pos = list.size;
        }
    }

    @Override
    public void toCollection(Collection<V> collection) {
        this.toCollection(collection, this.size);
    }

    @Override
    public Iterator<V> iterator() {
        return new CListIterator(this, this.size);
    }

    @Override
    public Iterator<V> reverseIterator() {
        return new CListIterator(this, this.size);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CodedSlice<V>
    implements CList<V> {
        int pos;

        CodedSlice(int pos) {
            this.pos = pos;
        }

        @Override
        public CList<V> cons(V element) {
            return new CodedList<V>(element, CodedList.this, this.pos);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return this.pos + CodedList.this.restSize;
        }

        @Override
        public V head() {
            return (V)CodedList.this.elements[this.pos - 1];
        }

        @Override
        public CList<V> tail() {
            if (this.pos > 1) {
                return new CodedSlice<V>(this.pos - 1);
            }
            return CodedList.this.rest;
        }

        @Override
        public boolean contains(V element) {
            return CodedList.this.contains(element, this.pos);
        }

        @Override
        public Iterator<V> iterator() {
            return new CListIterator(CodedList.this, this.pos);
        }

        @Override
        public Iterator<V> reverseIterator() {
            return new CListReverseIterator(CodedList.this, this.pos);
        }

        @Override
        public void visit(Visitor<V> visitor) {
            CodedList.this.visit(visitor, this.pos);
        }

        @Override
        public boolean visit(ConditionalVisitor<V> visitor) {
            return CodedList.this.visit(visitor, this.pos);
        }

        @Override
        public void reverseVisit(Visitor<V> visitor) {
            CodedList.this.reverseVisit(visitor, this.pos, CodedList.this);
        }

        @Override
        public boolean reverseVisit(ConditionalVisitor<V> visitor) {
            return CodedList.this.reverseVisit(visitor, this.pos, CodedList.this);
        }

        @Override
        public void toCollection(Collection<V> collection) {
            CodedList.this.toCollection(collection, this.pos);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CListReverseIterator<V>
    extends DefaultIterator<V> {
        CList<V> current;
        int saveMax;
        int max;
        int pos;
        Stack<CList<V>> stack = new Stack();

        CListReverseIterator(CList<V> current, int pos) {
            this.current = current;
            this.saveMax = pos;
            CodedList last = (CodedList)current;
            while (last.rest != CList.NIL) {
                this.stack.push(last);
                last = (CodedList)last.rest;
            }
            this.max = last == current ? this.saveMax : last.size;
        }

        @Override
        public boolean hasNext() {
            if (this.current != CList.NIL && this.pos == this.max) {
                if (this.stack.isEmpty()) {
                    this.current = CList.NIL;
                } else {
                    this.current = this.stack.pop();
                    CodedList cur = (CodedList)this.current;
                    this.max = this.stack.isEmpty() ? this.saveMax : cur.size;
                    this.pos = 0;
                }
            }
            return this.current != CList.NIL;
        }

        @Override
        public V next() {
            if (this.current == CList.NIL) {
                throw new NoSuchElementException();
            }
            return (V)((CodedList)this.current).elements[this.pos++];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CListIterator<V>
    extends DefaultIterator<V> {
        CList<V> current;
        int pos;

        CListIterator(CList<V> current, int pos) {
            this.pos = CodedList.this.size;
            this.current = current;
            this.pos = pos;
        }

        @Override
        public boolean hasNext() {
            if (this.current != CList.NIL && this.pos == 0) {
                this.current = ((CodedList)this.current).rest;
                if (this.current != CList.NIL) {
                    this.pos = ((CodedList)this.current).size;
                }
            }
            return this.current != CList.NIL;
        }

        @Override
        public V next() {
            if (this.current == CList.NIL) {
                throw new NoSuchElementException();
            }
            return (V)((CodedList)this.current).elements[this.pos--];
        }
    }
}

