/*
 * Decompiled with CFR 0.152.
 */
package org.genantics.list;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.genantics.access.ConditionalVisitor;
import org.genantics.access.Visitor;
import org.genantics.list.CList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsList<V>
implements CList<V> {
    V element;
    ConsList<V> next;

    public ConsList(V element, ConsList<V> next) {
        this.element = element;
        this.next = next;
    }

    @Override
    public ConsList<V> cons(V element) {
        return new ConsList<V>(element, this);
    }

    @Override
    public V head() {
        return this.element;
    }

    @Override
    public CList<V> tail() {
        return this.next;
    }

    @Override
    public boolean contains(V value) {
        if (this.element.equals(value)) {
            return true;
        }
        if (this.next != null) {
            return this.next.contains(value);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        this.toString(sb);
        sb.append("]");
        return sb.toString();
    }

    private void toString(StringBuilder sb) {
        sb.append(this.element.toString());
        if (this.next != null) {
            sb.append(" ");
            super.toString(sb);
        }
    }

    @Override
    public void toCollection(Collection<V> collection) {
        ConsList<V> list = this;
        while (list != null) {
            collection.add(this.element);
            list = list.next;
        }
    }

    @Override
    public void visit(Visitor<V> visitor) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean visit(ConditionalVisitor<V> visitor) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        int size = 0;
        CList<V> list = this;
        while (!list.isEmpty()) {
            ++size;
            list = list.tail();
        }
        return size;
    }

    @Override
    public Iterator<V> reverseIterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void reverseVisit(Visitor<V> visitor) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean reverseVisit(ConditionalVisitor<V> visitor) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Iterator<V> iterator() {
        return new ConsListIterator(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConsListIterator<V>
    implements Iterator<V> {
        ConsList<V> list = null;

        public ConsListIterator(ConsList<V> list) {
        }

        @Override
        public boolean hasNext() {
            return this.list != null;
        }

        @Override
        public V next() {
            if (this.list == null) {
                throw new NoSuchElementException();
            }
            V head = this.list.head();
            this.list = this.list.next;
            return head;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

