/*
 * Decompiled with CFR 0.152.
 */
package org.genantics.set;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.genantics.access.ConditionalVisitor;
import org.genantics.access.DefaultIterator;
import org.genantics.access.Filter;
import org.genantics.access.Visitor;
import org.genantics.set.Keyed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyedSet<K extends Comparable<K>, T extends Keyed<K>>
implements Iterable<T> {
    protected T member;
    protected KeyedSet<K, T> left;
    protected KeyedSet<K, T> right;
    protected int height;
    public static final KeyedSet EMPTY = new Empty();

    public KeyedSet(Iterable<T> iterable) {
        KeyedSet<K, Keyed> set = EMPTY;
        for (Keyed t : iterable) {
            set = set.add(t);
        }
        this.copy(set);
    }

    private void copy(KeyedSet<K, T> set) {
        this.member = set.member;
        this.left = set.left;
        this.right = set.right;
        this.height = set.height;
    }

    protected KeyedSet(T element, KeyedSet<K, T> left, KeyedSet<K, T> right) {
        this.member = element;
        this.left = left;
        this.right = right;
        this.init();
    }

    protected KeyedSet<K, T> newTree(T element, KeyedSet<K, T> left, KeyedSet<K, T> right) {
        return new KeyedSet<K, T>(element, left, right);
    }

    protected void init() {
        this.height = Math.max(this.left.height, this.right.height) + 1;
    }

    int getHeight() {
        return this.height;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyedSet)) {
            return false;
        }
        if (o == EMPTY) {
            return false;
        }
        try {
            KeyedSet other = (KeyedSet)o;
            return this.equalElements(this.iterator(), other.iterator());
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    private boolean equalElements(Iterator<T> ita, Iterator<T> itb) {
        Keyed tb;
        Keyed ta;
        do {
            boolean isb;
            boolean isa;
            if ((isa = ita.hasNext()) != (isb = itb.hasNext())) {
                return false;
            }
            if (isa) continue;
            return true;
        } while ((ta = (Keyed)ita.next()).equals(tb = (Keyed)itb.next()));
        return false;
    }

    public int hashCode() {
        HashVisitor visitor = new HashVisitor();
        this.visitFwd(visitor);
        return visitor.value();
    }

    public int size() {
        return this.left.size() + 1 + this.right.size();
    }

    public boolean containsKey(K key) {
        int cmp = key.compareTo(this.member.getKey());
        if (cmp == 0) {
            return true;
        }
        if (cmp < 0) {
            return this.left.containsKey(key);
        }
        return this.right.containsKey(key);
    }

    public T getFirst() {
        if (this.left == EMPTY) {
            return this.member;
        }
        return this.left.getFirst();
    }

    public T getLast() {
        if (this.right == EMPTY) {
            return this.member;
        }
        return this.right.getLast();
    }

    public KeyedSet<K, T> deleteFirst() {
        if (this.left == EMPTY) {
            if (this.right == EMPTY) {
                return EMPTY;
            }
            return this.right;
        }
        return this.balanceTree(this.newTree(this.member, this.left.deleteFirst(), this.right));
    }

    public KeyedSet<K, T> deleteLast() {
        if (this.right == EMPTY) {
            if (this.left == EMPTY) {
                return EMPTY;
            }
            return this.left;
        }
        return this.balanceTree(this.newTree(this.member, this.left, this.right.deleteLast()));
    }

    public Iterable<K> keys() {
        return new KeyIterable();
    }

    public Iterable<K> reverseKeys() {
        return new ReverseKeyIterable();
    }

    protected int getBalance() {
        return this.left.height - this.right.height;
    }

    boolean isBalanced() {
        int balance = this.getBalance();
        boolean balanced = balance >= -1 && balance <= 1 && this.left.isBalanced() && this.right.isBalanced();
        return balanced;
    }

    boolean isOrdered() {
        Object memberKey = this.member.getKey();
        return this.isEmpty() || (this.left.isEmpty() || this.left.member.getKey().compareTo(memberKey) < 0 && this.left.isOrdered()) && (this.right.isEmpty() || memberKey.compareTo(this.right.member.getKey()) < 0 && this.right.isOrdered());
    }

    protected KeyedSet<K, T> setLeft(KeyedSet<K, T> left) {
        return new KeyedSet<K, T>(this.member, left, this.right);
    }

    protected KeyedSet<K, T> setRight(KeyedSet<K, T> right) {
        return new KeyedSet<K, T>(this.member, this.left, right);
    }

    public boolean contains(T value) {
        if (value == null) {
            return false;
        }
        return this.containsKey(value);
    }

    protected boolean containsKey(T value) {
        if (value.equals(this.member)) {
            return true;
        }
        int cmp = value.getKey().compareTo(this.member.getKey());
        if (cmp < 0) {
            return this.left.containsKey(value);
        }
        if (cmp > 0) {
            return this.right.containsKey(value);
        }
        return value.equals(this.member);
    }

    public boolean isEmpty() {
        return false;
    }

    public KeyedSet<K, T> add(T element) {
        boolean[] added = new boolean[2];
        return this.addElement(element, added);
    }

    public KeyedSet<K, T> add(T element, boolean[] added) {
        if (element == null) {
            throw new NullPointerException();
        }
        added[1] = false;
        added[0] = false;
        return this.addElement(element, added);
    }

    protected KeyedSet<K, T> addElement(T element, boolean[] added) {
        int cmp = element.getKey().compareTo(this.member.getKey());
        KeyedSet<K, T> node = null;
        if (cmp < 0) {
            KeyedSet<K, T> newLeft = this.left.addElement(element, added);
            if (!added[0] && !added[1]) {
                return this;
            }
            node = this.newTree(this.member, newLeft, this.right);
        } else if (cmp > 0) {
            KeyedSet<K, T> newRight = this.right.addElement(element, added);
            if (!added[0] && !added[1]) {
                return this;
            }
            node = this.newTree(this.member, this.left, newRight);
        } else {
            if (!element.equals(this.member)) {
                added[1] = true;
                return this.newTree(element, this.left, this.right);
            }
            return this;
        }
        return this.balanceTree(node);
    }

    public T get(K key) {
        int cmp = key.compareTo(this.member.getKey());
        if (cmp == 0) {
            return this.member;
        }
        if (cmp < 0) {
            return this.left.get(key);
        }
        return this.right.get(key);
    }

    public KeyedSet<K, T> delete(K key) {
        return this.delete(key, new boolean[1]);
    }

    public KeyedSet<K, T> delete(K key, boolean[] deleted) {
        deleted[0] = false;
        return this.deleteKey(key, deleted);
    }

    protected KeyedSet<K, T> deleteKey(K key, boolean[] deleted) {
        int cmp = key.compareTo(this.member.getKey());
        KeyedSet<K, T> node = this;
        if (cmp < 0) {
            KeyedSet<K, T> newLeft = this.left.deleteKey(key, deleted);
            if (!deleted[0]) {
                return node;
            }
            node = this.newTree(this.member, newLeft, this.right);
        } else if (cmp > 0) {
            KeyedSet<K, T> newRight = this.right.deleteKey(key, deleted);
            if (!deleted[0]) {
                return node;
            }
            node = this.newTree(this.member, this.left, newRight);
        } else {
            deleted[0] = true;
            if (this.left.isEmpty() && this.right.isEmpty()) {
                return EMPTY;
            }
            if (this.left.isEmpty()) {
                return this.right;
            }
            if (this.right.isEmpty()) {
                return this.left;
            }
            KeyedSet<K, T> high = this.left;
            while (!high.right.isEmpty()) {
                high = high.right;
            }
            node = high == this.left ? this.newTree(this.left.member, this.left.left, this.right) : this.newTree(high.member, this.removeHigh(this.left, high), this.right);
        }
        return this.balanceTree(node);
    }

    protected KeyedSet<K, T> balanceTree(KeyedSet<K, T> node) {
        int balance = node.getBalance();
        if (balance > 1) {
            if (node.left.getBalance() < 0) {
                node = node.setLeft(this.rotateLeft(node.left));
            }
            node = this.rotateRight(node);
        } else if (balance < -1) {
            if (node.right.getBalance() > 0) {
                node = node.setRight(this.rotateRight(node.right));
            }
            node = this.rotateLeft(node);
        }
        return node;
    }

    private KeyedSet<K, T> rotateLeft(KeyedSet<K, T> a) {
        KeyedSet<K, T> b = a.right;
        return b.setLeft(a.setRight(b.left));
    }

    private KeyedSet<K, T> rotateRight(KeyedSet<K, T> c) {
        KeyedSet<K, T> b = c.left;
        return b.setRight(c.setLeft(b.right));
    }

    public KeyedSet<K, T> remove(T element) {
        return this.removeElement(element, new boolean[1]);
    }

    public KeyedSet<K, T> remove(T element, boolean[] removed) {
        removed[0] = false;
        return this.removeElement(element, removed);
    }

    protected KeyedSet<K, T> removeElement(T element, boolean[] removed) {
        int cmp = element.getKey().compareTo(this.member.getKey());
        KeyedSet<K, T> node = this;
        if (cmp < 0) {
            KeyedSet<K, T> newLeft = this.left.removeElement(element, removed);
            if (!removed[0]) {
                return node;
            }
            node = this.newTree(this.member, newLeft, this.right);
        } else if (cmp > 0) {
            KeyedSet<K, T> newRight = this.right.removeElement(element, removed);
            if (!removed[0]) {
                return node;
            }
            node = this.newTree(this.member, this.left, newRight);
        } else {
            if (!element.equals(this.member)) {
                return node;
            }
            removed[0] = true;
            if (this.left.isEmpty() && this.right.isEmpty()) {
                return EMPTY;
            }
            if (this.left.isEmpty()) {
                return this.right;
            }
            if (this.right.isEmpty()) {
                return this.left;
            }
            KeyedSet<K, T> high = this.left;
            while (!high.right.isEmpty()) {
                high = high.right;
            }
            node = high == this.left ? this.newTree(this.left.member, this.left.left, this.right) : this.newTree(high.member, this.removeHigh(this.left, high), this.right);
        }
        return this.balanceTree(node);
    }

    protected KeyedSet<K, T> removeHigh(KeyedSet<K, T> node, KeyedSet<K, T> high) {
        if (node == high) {
            return node.left;
        }
        node = node.setRight(this.removeHigh(node.right, high));
        return this.balanceTree(node);
    }

    @Override
    public Iterator<T> iterator() {
        return new ValueIterator();
    }

    TreeIterator treeIterator() {
        return new TreeIterator();
    }

    public Iterator<T> reverseIterator() {
        return new ReverseValueIterator();
    }

    public Iterable<T> elements() {
        return new ValueIterable();
    }

    public Iterable<T> reverseElements() {
        return new ReverseValueIterable();
    }

    public KeyedSet<K, T> addAll(Iterable<T> iterable) {
        KeyedSet<K, Keyed> tree = this;
        for (Keyed t : iterable) {
            tree = tree.add(t);
        }
        return tree;
    }

    public KeyedSet<K, T> removeAll(Iterable<T> iterable) {
        KeyedSet<K, Keyed> tree = this;
        boolean[] removed = new boolean[1];
        for (Keyed t : iterable) {
            tree = tree.remove(t, removed);
        }
        return tree;
    }

    public KeyedSet<K, T> retainAll(Iterable<T> iterable) {
        KeyedSet<K, Keyed> tree = EMPTY;
        for (Keyed t : iterable) {
            if (!this.contains(t)) continue;
            tree = tree.add(t);
        }
        return tree;
    }

    public void visitFwd(Visitor visitor) {
        this.left.visitFwd(visitor);
        visitor.visit(this.member);
        this.right.visitFwd(visitor);
    }

    public boolean visitFwd(ConditionalVisitor visitor) {
        return this.left.visitFwd(visitor) || visitor.visit(this.member) || this.right.visitFwd(visitor);
    }

    public void visitRev(Visitor visitor) {
        this.right.visitRev(visitor);
        visitor.visit(this.member);
        this.left.visitRev(visitor);
    }

    public boolean visitRev(ConditionalVisitor visitor) {
        return this.right.visitRev(visitor) || visitor.visit(this.member) || this.left.visitRev(visitor);
    }

    public KeyedSet<K, T> filter(Filter filter) {
        FilterVisitor visitor = new FilterVisitor(filter);
        this.visitFwd(visitor);
        return visitor.value();
    }

    public void collect(Collection<T> collection) {
        Collector visitor = new Collector(collection);
        this.visitFwd(visitor);
    }

    public boolean containsAll(Iterable<T> elements) {
        for (Keyed t : elements) {
            if (this.contains(t)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(Iterable<T> elements) {
        for (T o : elements) {
            if (!this.contains((Keyed)o)) continue;
            return true;
        }
        return false;
    }

    public KeyedSet<K, T> clear() {
        return EMPTY;
    }

    public String toString() {
        return "(" + this.left.toString() + this.member.toString() + this.right.toString() + ")";
    }

    public void prettyPrint() {
        this.prettyPrint("");
    }

    protected void prettyPrint(String indent) {
        if (!this.right.isEmpty()) {
            this.right.prettyPrint(indent + "  ");
        }
        System.out.println(indent + this.member.toString() + "-" + this.height);
        if (!this.left.isEmpty()) {
            this.left.prettyPrint(indent + "  ");
        }
    }

    static {
        KeyedSet.EMPTY.left = EMPTY;
        KeyedSet.EMPTY.right = EMPTY;
        KeyedSet.EMPTY.height = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Empty<T extends Keyed<K>, K extends Comparable<K>>
    extends KeyedSet<K, T> {
        protected Empty() {
            super(null, EMPTY, EMPTY);
        }

        @Override
        protected void init() {
        }

        @Override
        public boolean equals(Object o) {
            return o == EMPTY;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean containsKey(K key) {
            return false;
        }

        @Override
        public T getFirst() {
            return null;
        }

        @Override
        public T getLast() {
            return null;
        }

        @Override
        public KeyedSet<K, T> deleteFirst() {
            return this;
        }

        @Override
        public KeyedSet<K, T> deleteLast() {
            return this;
        }

        @Override
        boolean isBalanced() {
            return true;
        }

        @Override
        boolean isOrdered() {
            return true;
        }

        @Override
        protected boolean containsKey(T value) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        protected KeyedSet<K, T> addElement(T element, boolean[] added) {
            added[0] = true;
            return this.newTree(element, EMPTY, EMPTY);
        }

        @Override
        public T get(K key) {
            return null;
        }

        @Override
        protected KeyedSet<K, T> deleteKey(K key, boolean[] deleted) {
            return this;
        }

        @Override
        protected KeyedSet<K, T> removeElement(T value, boolean[] removed) {
            return this;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public T next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Iterator<T> reverseIterator() {
            return this.iterator();
        }

        @Override
        public Iterable<T> elements() {
            return this;
        }

        @Override
        public Iterable<T> reverseElements() {
            return this;
        }

        @Override
        public KeyedSet<K, T> removeAll(Iterable<T> iterable) {
            return this;
        }

        @Override
        public KeyedSet<K, T> retainAll(Iterable<T> iterable) {
            return this;
        }

        @Override
        public void visitFwd(Visitor visitor) {
        }

        @Override
        public boolean visitFwd(ConditionalVisitor visitor) {
            return false;
        }

        @Override
        public void visitRev(Visitor visitor) {
        }

        @Override
        public boolean visitRev(ConditionalVisitor visitor) {
            return false;
        }

        @Override
        public KeyedSet<K, T> filter(Filter filter) {
            return this;
        }

        @Override
        public void collect(Collection<T> collection) {
        }

        @Override
        public boolean containsAll(Iterable<T> elements) {
            return !elements.iterator().hasNext();
        }

        @Override
        public boolean containsAny(Iterable<T> elements) {
            return false;
        }

        @Override
        public String toString() {
            return "()";
        }

        @Override
        public void prettyPrint() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Collector
    implements Visitor<T> {
        private final Collection<T> collection;

        public Collector(Collection<T> collection) {
            this.collection = collection;
        }

        @Override
        public void visit(T t) {
            this.collection.add(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilterVisitor
    implements Visitor<T> {
        KeyedSet<K, T> set = EMPTY;
        private final Filter<T> filter;

        public FilterVisitor(Filter<T> filter) {
            this.filter = filter;
        }

        @Override
        public void visit(T t) {
            if (this.filter.accept(t)) {
                this.set = this.set.add(t);
            }
        }

        public KeyedSet<K, T> value() {
            return this.set;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ReverseValueIterable
    implements Iterable<T> {
        protected ReverseValueIterable() {
        }

        @Override
        public Iterator<T> iterator() {
            return new ReverseValueIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ReverseValueIterator
    implements Iterator<T> {
        ReverseTreeIterator it;

        protected ReverseValueIterator() {
            this.it = new ReverseTreeIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return ((KeyedSet)this.it.next()).member;
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ReverseTreeIterable
    implements Iterable<KeyedSet<K, T>> {
        protected ReverseTreeIterable() {
        }

        @Override
        public Iterator<KeyedSet<K, T>> iterator() {
            return new ReverseTreeIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ReverseTreeIterator
    implements Iterator<KeyedSet<K, T>> {
        KeyedSet<K, T> current;
        int visited = 0;
        Stack<TreeState> stack = new Stack();

        public ReverseTreeIterator() {
            this.current = this.loopTraversal(KeyedSet.this);
        }

        protected KeyedSet<K, T> loopTraversal(KeyedSet<K, T> node) {
            block6: while (true) {
                switch (this.visited) {
                    case 0: {
                        if (node.right != EMPTY) {
                            this.stack.push(new TreeState(node, 3));
                            node = node.right;
                            this.visited = 0;
                            continue block6;
                        }
                    }
                    case 3: {
                        this.visited = 2;
                        return node;
                    }
                    case 2: {
                        if (node.left != EMPTY) {
                            this.stack.push(new TreeState(node, 1));
                            node = node.left;
                            this.visited = 0;
                            continue block6;
                        }
                    }
                    case 1: {
                        if (this.stack.isEmpty()) {
                            return null;
                        }
                        TreeState treeState = this.stack.pop();
                        node = treeState.tree;
                        this.visited = treeState.visited;
                        continue block6;
                    }
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public KeyedSet<K, T> next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            KeyedSet tmp = this.current;
            this.current = this.loopTraversal(this.current);
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ValueIterable
    implements Iterable<T> {
        protected ValueIterable() {
        }

        @Override
        public Iterator<T> iterator() {
            return new ValueIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ValueIterator
    implements Iterator<T> {
        TreeIterator it;

        protected ValueIterator() {
            this.it = new TreeIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return ((KeyedSet)this.it.next()).member;
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TreeIterable
    implements Iterable<KeyedSet<K, T>> {
        protected TreeIterable() {
        }

        @Override
        public Iterator<KeyedSet<K, T>> iterator() {
            return new TreeIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TreeIterator
    implements Iterator<KeyedSet<K, T>> {
        KeyedSet<K, T> current;
        int visited = 0;
        Stack<TreeState> stack = new Stack();

        public TreeIterator() {
            this.current = this.loopTraversal(KeyedSet.this);
        }

        protected KeyedSet<K, T> loopTraversal(KeyedSet<K, T> node) {
            block6: while (true) {
                switch (this.visited) {
                    case 0: {
                        if (node.left != EMPTY) {
                            this.stack.push(new TreeState(node, 1));
                            node = node.left;
                            this.visited = 0;
                            continue block6;
                        }
                    }
                    case 1: {
                        this.visited = 2;
                        return node;
                    }
                    case 2: {
                        if (node.right != EMPTY) {
                            this.stack.push(new TreeState(node, 3));
                            node = node.right;
                            this.visited = 0;
                            continue block6;
                        }
                    }
                    case 3: {
                        if (this.stack.isEmpty()) {
                            return null;
                        }
                        TreeState treeState = this.stack.pop();
                        node = treeState.tree;
                        this.visited = treeState.visited;
                        continue block6;
                    }
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public KeyedSet<K, T> next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            KeyedSet tmp = this.current;
            this.current = this.loopTraversal(this.current);
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TreeState {
        public static final int NONE = 0;
        public static final int LEFT = 1;
        public static final int THIS = 2;
        public static final int RIGHT = 3;
        KeyedSet<K, T> tree;
        int visited;

        public TreeState(KeyedSet<K, T> tree, int visited) {
            this.tree = tree;
            this.visited = visited;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReverseKeyIterable
    implements Iterable {
        private ReverseKeyIterable() {
        }

        public Iterator<K> iterator() {
            return new KeyIterator(KeyedSet.this.reverseIterator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterable
    implements Iterable {
        private KeyIterable() {
        }

        public Iterator<K> iterator() {
            return new KeyIterator(KeyedSet.this.iterator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends DefaultIterator<K> {
        private final Iterator<T> it;

        KeyIterator(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public K next() {
            return ((Keyed)this.it.next()).getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HashVisitor
    implements Visitor<T> {
        int hash = 0;

        private HashVisitor() {
        }

        @Override
        public void visit(T t) {
            this.hash = this.hash * 31 + t.hashCode();
        }

        public int value() {
            return this.hash;
        }
    }
}

