/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.reasoner;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geneontology.reasoner.OWLExtendedReasoner;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.OWLReasonerBase;
import org.semanticweb.owlapi.util.Version;

public class ExpressionMaterializingReasoner
extends OWLReasonerBase
implements OWLExtendedReasoner {
    private OWLReasoner wrappedReasoner;
    private final OWLDataFactory dataFactory;
    private final OWLOntology rootOntology;
    private final OWLOntology expandedOntology;
    final OWLOntologyManager manager;
    final Set<OWLObjectProperty> cachedProperties;
    private final Map<OWLClass, OWLObjectSomeValuesFrom> cxMap;
    private boolean includeImports = false;

    protected ExpressionMaterializingReasoner(OWLOntology rootOntology, OWLReasonerFactory reasonerFactory, OWLReasonerConfiguration configuration, BufferingMode bufferingMode) {
        super(rootOntology, configuration, bufferingMode);
        try {
            this.rootOntology = rootOntology;
            this.manager = rootOntology.getOWLOntologyManager();
            this.dataFactory = this.manager.getOWLDataFactory();
            this.expandedOntology = this.createExpandedOntologyStub(rootOntology);
            this.wrappedReasoner = BufferingMode.NON_BUFFERING == bufferingMode ? reasonerFactory.createReasoner(this.expandedOntology, configuration) : reasonerFactory.createNonBufferingReasoner(this.expandedOntology, configuration);
        }
        catch (UnknownOWLOntologyException e) {
            throw new RuntimeException("Could not setup reasoner", e);
        }
        catch (OWLOntologyCreationException e) {
            throw new RuntimeException("Could not setup reasoner", e);
        }
        this.cachedProperties = new HashSet<OWLObjectProperty>();
        this.cxMap = new HashMap<OWLClass, OWLObjectSomeValuesFrom>();
    }

    private OWLOntology createExpandedOntologyStub(OWLOntology rootOntology) throws OWLOntologyCreationException {
        IRI rootOntologyIRI;
        OWLOntology expandedOntology = this.manager.createOntology(IRI.generateDocumentIRI());
        OWLOntologyID rootId = rootOntology.getOntologyID();
        if (rootId == null) {
            rootOntologyIRI = IRI.generateDocumentIRI();
            this.manager.applyChange((OWLOntologyChange)new SetOntologyID(rootOntology, rootOntologyIRI));
        } else {
            Optional optional = rootId.getOntologyIRI();
            if (!optional.isPresent()) {
                rootOntologyIRI = IRI.generateDocumentIRI();
                this.manager.applyChange((OWLOntologyChange)new SetOntologyID(rootOntology, rootOntologyIRI));
            } else {
                rootOntologyIRI = (IRI)optional.get();
            }
        }
        AddImport ai = new AddImport(expandedOntology, this.dataFactory.getOWLImportsDeclaration(rootOntologyIRI));
        this.manager.applyChange((OWLOntologyChange)ai);
        return expandedOntology;
    }

    public ExpressionMaterializingReasoner(OWLOntology ont, OWLReasonerFactory reasonerFactory) {
        this(ont, reasonerFactory, (OWLReasonerConfiguration)new SimpleConfiguration(), BufferingMode.BUFFERING);
    }

    public ExpressionMaterializingReasoner(OWLOntology ont, OWLReasonerFactory reasonerFactory, BufferingMode bufferingMode) {
        this(ont, reasonerFactory, (OWLReasonerConfiguration)new SimpleConfiguration(), bufferingMode);
    }

    public OWLReasoner getWrappedReasoner() {
        return this.wrappedReasoner;
    }

    public void setIncludeImports(boolean includeImports) {
        this.includeImports = includeImports;
    }

    public boolean isIncludeImports() {
        return this.includeImports;
    }

    public void materializeExpressions() {
        this.materializeExpressions(this.rootOntology.getObjectPropertiesInSignature(Imports.fromBoolean((boolean)this.includeImports)));
    }

    public void materializeExpressions(Collection<OWLObjectProperty> properties) {
        for (OWLObjectProperty p : properties) {
            if (this.cachedProperties.contains(p)) continue;
            this.materializeExpressions(p);
        }
        this.flush();
    }

    public void materializeExpressions(OWLObjectProperty p) {
        if (this.cachedProperties.contains(p)) {
            return;
        }
        this.materializeExpressionsInternal(p);
        this.flush();
    }

    private void materializeExpressionsInternal(OWLObjectProperty p) {
        for (OWLClass baseClass : this.rootOntology.getClassesInSignature(Imports.fromBoolean((boolean)this.includeImports))) {
            if (this.cxMap.containsKey(baseClass)) continue;
            OWLObjectSomeValuesFrom x = this.dataFactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)p, (OWLClassExpression)baseClass);
            IRI xciri = IRI.create((String)(baseClass.getIRI() + "__" + this.saveIRItoString(p.getIRI())));
            OWLClass xc = this.dataFactory.getOWLClass(xciri);
            OWLEquivalentClassesAxiom eca = this.dataFactory.getOWLEquivalentClassesAxiom((OWLClassExpression)xc, (OWLClassExpression)x);
            String lbl = p.getIRI().getShortForm() + " " + baseClass.getIRI().getShortForm();
            this.manager.addAxiom(this.expandedOntology, (OWLAxiom)this.dataFactory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)xciri, this.dataFactory.getOWLAnnotation(this.dataFactory.getRDFSLabel(), (OWLAnnotationValue)this.dataFactory.getOWLLiteral(lbl))));
            this.cxMap.put(xc, x);
            this.manager.addAxiom(this.expandedOntology, (OWLAxiom)eca);
            this.manager.addAxiom(this.expandedOntology, (OWLAxiom)this.dataFactory.getOWLDeclarationAxiom((OWLEntity)xc));
        }
        this.cachedProperties.add(p);
    }

    private CharSequence saveIRItoString(IRI iri) {
        StringBuilder sb = new StringBuilder();
        String s = iri.toString();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ':' || c == '/') {
                c = '_';
            }
            sb.append(c);
        }
        return sb;
    }

    @Override
    public Set<OWLClassExpression> getSuperClassExpressions(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        HashSet<OWLClassExpression> ces = new HashSet<OWLClassExpression>();
        this.wrappedReasoner.flush();
        for (OWLClass c : this.wrappedReasoner.getSuperClasses(ce, direct).getFlattened()) {
            if (this.cxMap.containsKey(c)) {
                ces.add((OWLClassExpression)this.cxMap.get(c));
                continue;
            }
            ces.add((OWLClassExpression)c);
        }
        return ces;
    }

    @Override
    public Set<OWLClass> getSuperClassesOver(OWLClassExpression ce, OWLObjectProperty p, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.materializeExpressions(p);
        HashSet<OWLClass> nxs = new HashSet<OWLClass>();
        for (OWLClass c : this.wrappedReasoner.getSuperClasses(ce, false).getFlattened()) {
            OWLObjectSomeValuesFrom x;
            if (!this.cxMap.containsKey(c) || !(x = this.cxMap.get(c)).getProperty().equals(p)) continue;
            nxs.add(c);
        }
        if (direct) {
            HashSet<OWLClass> ics = new HashSet<OWLClass>();
            for (OWLClass c : nxs) {
                for (OWLClass sc : this.wrappedReasoner.getSuperClasses((OWLClassExpression)c, false).getFlattened()) {
                    if (!nxs.contains(sc)) continue;
                    ics.add(sc);
                }
            }
            nxs.removeAll(ics);
        }
        HashSet<OWLClass> rcs = new HashSet<OWLClass>();
        for (OWLClass c : nxs) {
            OWLObjectSomeValuesFrom x = this.cxMap.get(c);
            OWLClass v = (OWLClass)x.getFiller();
            rcs.add(v);
        }
        return rcs;
    }

    public String getReasonerName() {
        return "Expression Materializing Reasoner";
    }

    public Version getReasonerVersion() {
        return this.wrappedReasoner.getReasonerVersion();
    }

    public BufferingMode getBufferingMode() {
        return this.wrappedReasoner.getBufferingMode();
    }

    public void flush() {
        this.wrappedReasoner.flush();
    }

    public List<OWLOntologyChange> getPendingChanges() {
        return this.wrappedReasoner.getPendingChanges();
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        return this.wrappedReasoner.getPendingAxiomAdditions();
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        return this.wrappedReasoner.getPendingAxiomRemovals();
    }

    public OWLOntology getRootOntology() {
        return this.wrappedReasoner.getRootOntology();
    }

    public void interrupt() {
        this.wrappedReasoner.interrupt();
    }

    public void precomputeInferences(InferenceType ... inferenceTypes) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        this.wrappedReasoner.precomputeInferences(inferenceTypes);
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        return this.wrappedReasoner.isPrecomputed(inferenceType);
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return this.wrappedReasoner.getPrecomputableInferenceTypes();
    }

    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.isConsistent();
    }

    public boolean isSatisfiable(OWLClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        return this.wrappedReasoner.isSatisfiable(classExpression);
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        return this.wrappedReasoner.getUnsatisfiableClasses();
    }

    public boolean isEntailed(OWLAxiom axiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        return this.wrappedReasoner.isEntailed(axiom);
    }

    public boolean isEntailed(Set<? extends OWLAxiom> axioms) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        return this.wrappedReasoner.isEntailed(axioms);
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return this.wrappedReasoner.isEntailmentCheckingSupported(axiomType);
    }

    public Node<OWLClass> getTopClassNode() {
        return this.wrappedReasoner.getTopClassNode();
    }

    public Node<OWLClass> getBottomClassNode() {
        return this.wrappedReasoner.getBottomClassNode();
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, boolean direct) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException, ClassExpressionNotInProfileException {
        return this.wrappedReasoner.getSubClasses(ce, direct);
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getSuperClasses(ce, direct);
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getEquivalentClasses(ce);
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression ce) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException {
        return this.wrappedReasoner.getDisjointClasses(ce);
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        return this.wrappedReasoner.getTopObjectPropertyNode();
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        return this.wrappedReasoner.getBottomObjectPropertyNode();
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getSubObjectProperties(pe, direct);
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getSuperObjectProperties(pe, direct);
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getEquivalentObjectProperties(pe);
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getDisjointObjectProperties(pe);
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getInverseObjectProperties(pe);
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getObjectPropertyDomains(pe, direct);
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getObjectPropertyRanges(pe, direct);
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        return this.wrappedReasoner.getTopDataPropertyNode();
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        return this.wrappedReasoner.getBottomDataPropertyNode();
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getSubDataProperties(pe, direct);
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getSuperDataProperties(pe, direct);
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getEquivalentDataProperties(pe);
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getDisjointDataProperties(pe);
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getDataPropertyDomains(pe, direct);
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getTypes(ind, direct);
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getInstances(ce, direct);
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual ind, OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getObjectPropertyValues(ind, pe);
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual ind, OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getDataPropertyValues(ind, pe);
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getSameIndividuals(ind);
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.wrappedReasoner.getDifferentIndividuals(ind);
    }

    public long getTimeOut() {
        return this.wrappedReasoner.getTimeOut();
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.wrappedReasoner.getFreshEntityPolicy();
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.wrappedReasoner.getIndividualNodeSetPolicy();
    }

    public void dispose() {
        this.wrappedReasoner.dispose();
    }

    protected void handleChanges(Set<OWLAxiom> addAxioms, Set<OWLAxiom> removeAxioms) {
    }
}

