/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.owlapi;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.geneontology.obographs.core.io.OgJsonGenerator;
import org.geneontology.obographs.core.io.OgYamlGenerator;
import org.geneontology.obographs.core.model.GraphDocument;
import org.geneontology.obographs.owlapi.FromOwl;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;

public class RunEngine {
    @Parameter(names={"-v", "--verbose"}, description="Level of verbosity")
    private Integer verbose = 1;
    @Parameter(names={"-o", "--out"}, description="output json/yaml file")
    private String outpath;
    @Parameter(names={"-t", "--to"}, description="output format: json or yaml")
    private String outformat;
    @Parameter(description="Files")
    private List<String> files = new ArrayList<String>();
    OWLOntologyManager manager;

    public static void main(String ... args) throws OWLOntologyCreationException, IOException, OWLOntologyStorageException {
        RunEngine main = new RunEngine();
        new JCommander((Object)main, args);
        main.run();
    }

    public void run() throws OWLOntologyCreationException, IOException {
        block8: {
            FromOwl fromOwl = new FromOwl();
            File file = new File(this.files.get(0));
            OWLOntology ont = this.loadOWL(file);
            GraphDocument gd = fromOwl.generateGraphDocument(ont);
            try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(this.outpath, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
                if (this.outformat == null || this.outformat.equals("json")) {
                    OgJsonGenerator.write((Writer)writer, (Object)gd);
                    break block8;
                }
                if (this.outformat.equals("yaml")) {
                    OgYamlGenerator.write((Writer)writer, (Object)gd);
                    break block8;
                }
                throw new IOException("no such format " + this.outformat);
            }
        }
    }

    private OWLOntologyManager getOWLOntologyManager() {
        if (this.manager == null) {
            this.manager = OWLManager.createOWLOntologyManager();
        }
        return this.manager;
    }

    public OWLOntology loadOWL(IRI iri) throws OWLOntologyCreationException {
        return this.getOWLOntologyManager().loadOntology(iri);
    }

    public OWLOntology loadOWL(File file) throws OWLOntologyCreationException {
        IRI iri = IRI.create((File)file);
        return this.getOWLOntologyManager().loadOntologyFromOntologyDocument(iri);
    }
}

