/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.owlapi;

import com.github.jsonldjava.core.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.geneontology.obographs.core.model.AbstractNode;
import org.geneontology.obographs.core.model.Edge;
import org.geneontology.obographs.core.model.Graph;
import org.geneontology.obographs.core.model.GraphDocument;
import org.geneontology.obographs.core.model.Meta;
import org.geneontology.obographs.core.model.Node;
import org.geneontology.obographs.core.model.NodeOrEdge;
import org.geneontology.obographs.core.model.axiom.DomainRangeAxiom;
import org.geneontology.obographs.core.model.axiom.EquivalentNodesSet;
import org.geneontology.obographs.core.model.axiom.ExistentialRestrictionExpression;
import org.geneontology.obographs.core.model.axiom.LogicalDefinitionAxiom;
import org.geneontology.obographs.core.model.axiom.PropertyChainAxiom;
import org.geneontology.obographs.core.model.meta.AbstractSynonymPropertyValue;
import org.geneontology.obographs.core.model.meta.BasicPropertyValue;
import org.geneontology.obographs.core.model.meta.DefinitionPropertyValue;
import org.geneontology.obographs.core.model.meta.SynonymPropertyValue;
import org.geneontology.obographs.core.model.meta.XrefPropertyValue;
import org.geneontology.obographs.owlapi.PrefixHelper;
import org.geneontology.obographs.owlapi.SynonymVocabulary;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FromOwl {
    private static final Logger LOGGER = LoggerFactory.getLogger(FromOwl.class);
    public static final String SUBCLASS_OF = "is_a";
    public static final String SUBPROPERTY_OF = "subPropertyOf";
    public static final String INVERSE_OF = "inverseOf";
    public static final String TYPE = "type";
    private final PrefixHelper prefixHelper = new PrefixHelper();
    private final Context context = this.prefixHelper.getContext();

    public GraphDocument generateGraphDocument(OWLOntology baseOntology) {
        ArrayList<Graph> graphs = new ArrayList<Graph>();
        for (OWLOntology ont : baseOntology.getImportsClosure()) {
            graphs.add(this.generateGraph(ont));
        }
        return new GraphDocument.Builder().graphs(graphs).build();
    }

    public Graph generateGraph(OWLOntology ontology) {
        SynonymVocabulary synonymVocabulary = new SynonymVocabulary();
        OWLOntologyID ontId = ontology.getOntologyID();
        String graphId = ontId.getOntologyIRI().isPresent() ? this.getNodeId((IRI)ontId.getOntologyIRI().get()) : "";
        String version = ontId.getVersionIRI().isPresent() ? this.getNodeId((IRI)ontId.getVersionIRI().get()) : "";
        Meta graphAnnotationsMeta = this.buildMeta(ontology.getAnnotations(), version);
        OboGraphBuilder oboGraphBuilder = new OboGraphBuilder(graphId, graphAnnotationsMeta);
        ArrayList sortedAxioms = new ArrayList(ontology.getAxioms());
        Collections.sort(sortedAxioms);
        for (OWLAxiom ax : sortedAxioms) {
            Object p;
            Meta meta = this.buildMeta(ax);
            if (ax instanceof OWLDeclarationAxiom) {
                OWLDeclarationAxiom dax = (OWLDeclarationAxiom)ax;
                OWLEntity e = dax.getEntity();
                String id = e.getIRI().toString();
                if (e instanceof OWLClass) {
                    oboGraphBuilder.addNodeType(id, AbstractNode.RDFTYPES.CLASS);
                    continue;
                }
                if (e instanceof OWLDataProperty) {
                    oboGraphBuilder.addNodeType(id, AbstractNode.PropertyType.DATA);
                    continue;
                }
                if (e instanceof OWLObjectProperty) {
                    oboGraphBuilder.addNodeType(id, AbstractNode.PropertyType.OBJECT);
                    continue;
                }
                if (e instanceof OWLAnnotationProperty) {
                    oboGraphBuilder.addNodeType(id, AbstractNode.PropertyType.ANNOTATION);
                    continue;
                }
                if (!(e instanceof OWLNamedIndividual)) continue;
                oboGraphBuilder.addNodeType(id, AbstractNode.RDFTYPES.INDIVIDUAL);
                continue;
            }
            if (ax instanceof OWLLogicalAxiom) {
                String obj;
                String subj;
                if (ax instanceof OWLSubClassOfAxiom) {
                    OWLSubClassOfAxiom sca = (OWLSubClassOfAxiom)ax;
                    OWLClassExpression subc = sca.getSubClass();
                    OWLClassExpression supc = sca.getSuperClass();
                    if (subc.isAnonymous()) continue;
                    if (subc.isNamed()) {
                        String subj2 = this.getClassId((OWLClass)subc);
                        oboGraphBuilder.addNodeType(subj2, AbstractNode.RDFTYPES.CLASS);
                        if (supc.isAnonymous()) {
                            Edge edge;
                            if (supc instanceof OWLObjectSomeValuesFrom) {
                                ExistentialRestrictionExpression r = this.getRestriction(supc);
                                if (r == null) {
                                    oboGraphBuilder.addUntranslatedAxiom((OWLAxiom)sca);
                                    continue;
                                }
                                oboGraphBuilder.addEdge(subj2, r.getPropertyId(), r.getFillerId(), meta);
                                continue;
                            }
                            if (!(supc instanceof OWLObjectAllValuesFrom)) continue;
                            OWLObjectAllValuesFrom avf = (OWLObjectAllValuesFrom)supc;
                            OWLObjectPropertyExpression property = avf.getProperty();
                            if (property instanceof OWLObjectProperty) {
                                if (((OWLClassExpression)avf.getFiller()).isNamed()) {
                                    String propertyId = this.getPropertyId(property);
                                    DomainRangeAxiom domainRangeAxiom = oboGraphBuilder.getDomainRangeAxiomBuilder(propertyId).build();
                                    edge = this.buildEdge(subj2, domainRangeAxiom.getPredicateId(), this.getClassId(((OWLClassExpression)avf.getFiller()).asOWLClass()), meta);
                                    oboGraphBuilder.addPropertyEdgeDefinitions(propertyId, edge);
                                    continue;
                                }
                                oboGraphBuilder.addUntranslatedAxiom((OWLAxiom)sca);
                                continue;
                            }
                            if (!(property instanceof OWLObjectInverseOf)) continue;
                            OWLObjectInverseOf iop = (OWLObjectInverseOf)property;
                            if (((OWLClassExpression)avf.getFiller()).isNamed() && iop.isNamed()) {
                                String pid = this.getPropertyId(iop.getInverse());
                                edge = this.buildEdge(subj2, INVERSE_OF, pid, meta);
                                oboGraphBuilder.addPropertyEdgeDefinitions(pid, edge);
                                continue;
                            }
                            oboGraphBuilder.addUntranslatedAxiom((OWLAxiom)sca);
                            continue;
                        }
                        oboGraphBuilder.addEdge(subj2, SUBCLASS_OF, this.getClassId((OWLClass)supc), meta);
                        continue;
                    }
                    oboGraphBuilder.addUntranslatedAxiom((OWLAxiom)sca);
                    continue;
                }
                if (ax instanceof OWLClassAssertionAxiom) {
                    OWLClassAssertionAxiom ca = (OWLClassAssertionAxiom)ax;
                    subj = this.getIndividualId(ca.getIndividual());
                    OWLClassExpression cx = ca.getClassExpression();
                    if (cx.isAnonymous()) {
                        oboGraphBuilder.addUntranslatedAxiom((OWLAxiom)ca);
                        continue;
                    }
                    obj = this.getClassId(cx.asOWLClass());
                    oboGraphBuilder.addEdge(subj, TYPE, obj, meta);
                    oboGraphBuilder.addNodeId(subj);
                    oboGraphBuilder.addNodeId(obj);
                    continue;
                }
                if (ax instanceof OWLObjectPropertyAssertionAxiom) {
                    OWLObjectPropertyAssertionAxiom opa = (OWLObjectPropertyAssertionAxiom)ax;
                    subj = this.getIndividualId(opa.getSubject());
                    obj = this.getIndividualId((OWLIndividual)opa.getObject());
                    if (((OWLObjectPropertyExpression)opa.getProperty()).isAnonymous()) {
                        oboGraphBuilder.addUntranslatedAxiom((OWLAxiom)opa);
                    } else {
                        String pred = this.getPropertyId((OWLObjectPropertyExpression)opa.getProperty());
                        oboGraphBuilder.addEdge(subj, pred, obj, meta);
                    }
                    oboGraphBuilder.addNodeId(subj);
                    continue;
                }
                if (ax instanceof OWLEquivalentClassesAxiom) {
                    OWLClassExpression anonX;
                    OWLEquivalentClassesAxiom eca = (OWLEquivalentClassesAxiom)ax;
                    List xs = eca.getClassExpressionsAsList();
                    List anonXs = xs.stream().filter(IsAnonymous::isAnonymous).collect(Collectors.toUnmodifiableList());
                    List namedXs = xs.stream().filter(IsAnonymous::isNamed).collect(Collectors.toUnmodifiableList());
                    if (anonXs.isEmpty()) {
                        Set xClassIds = namedXs.stream().map(x -> this.getClassId((OWLClass)x)).collect(Collectors.toCollection(LinkedHashSet::new));
                        EquivalentNodesSet enset = new EquivalentNodesSet.Builder().nodeIds((Iterable)xClassIds).meta(this.nullIfEmpty(meta)).build();
                        oboGraphBuilder.addEquivalentNodesSet(enset);
                        continue;
                    }
                    if (anonXs.size() != 1 || namedXs.size() != 1 || !((anonX = (OWLClassExpression)anonXs.get(0)) instanceof OWLObjectIntersectionOf)) continue;
                    Set ixs = ((OWLObjectIntersectionOf)anonX).getOperands();
                    OBOClassDef classDef = this.getClassDef(ixs);
                    if (classDef != null && !classDef.restrs.contains(null)) {
                        LogicalDefinitionAxiom lda = new LogicalDefinitionAxiom.Builder().definedClassId(this.getClassId((OWLClass)namedXs.get(0))).genusIds(classDef.genusClassIds).restrictions(classDef.restrs).build();
                        oboGraphBuilder.addLogicalDefinitionAxiom(lda);
                        continue;
                    }
                    oboGraphBuilder.addUntranslatedAxiom((OWLAxiom)eca);
                    continue;
                }
                if (ax instanceof OWLObjectPropertyAxiom) {
                    String propertyId;
                    OWLClassExpression rc;
                    OWLObjectPropertyRangeAxiom rax;
                    if (ax instanceof OWLSubObjectPropertyOfAxiom) {
                        OWLSubObjectPropertyOfAxiom spa = (OWLSubObjectPropertyOfAxiom)ax;
                        if (!((OWLObjectPropertyExpression)spa.getSubProperty()).isNamed() || !((OWLObjectPropertyExpression)spa.getSuperProperty()).isNamed()) continue;
                        subj = this.getPropertyId((OWLObjectPropertyExpression)spa.getSubProperty());
                        obj = this.getPropertyId((OWLObjectPropertyExpression)spa.getSuperProperty());
                        oboGraphBuilder.addEdge(subj, SUBPROPERTY_OF, obj, meta);
                        continue;
                    }
                    if (ax instanceof OWLInverseObjectPropertiesAxiom) {
                        OWLInverseObjectPropertiesAxiom ipa = (OWLInverseObjectPropertiesAxiom)ax;
                        if (!ipa.getFirstProperty().isNamed() || !ipa.getSecondProperty().isNamed()) continue;
                        String p1 = this.getPropertyId(ipa.getFirstProperty());
                        String p2 = this.getPropertyId(ipa.getSecondProperty());
                        oboGraphBuilder.addEdge(p1, INVERSE_OF, p2, meta);
                        continue;
                    }
                    if (ax instanceof OWLSubPropertyChainOfAxiom) {
                        OWLSubPropertyChainOfAxiom spc = (OWLSubPropertyChainOfAxiom)ax;
                        if (!spc.getSuperProperty().isNamed()) continue;
                        p = this.getPropertyId(spc.getSuperProperty());
                        List cpids = spc.getPropertyChain().stream().map(cp -> cp.isAnonymous() ? null : this.getPropertyId((OWLObjectPropertyExpression)cp)).collect(Collectors.toList());
                        if (!cpids.stream().noneMatch(Objects::isNull)) continue;
                        oboGraphBuilder.addPropertyChainAxiom(new PropertyChainAxiom.Builder().predicateId((String)p).chainPredicateIds(cpids).build());
                        continue;
                    }
                    if (ax instanceof OWLObjectPropertyRangeAxiom) {
                        rax = (OWLObjectPropertyRangeAxiom)ax;
                        rc = (OWLClassExpression)rax.getRange();
                        if (!rc.isNamed()) continue;
                        propertyId = this.getPropertyId((OWLObjectPropertyExpression)rax.getProperty());
                        oboGraphBuilder.addPropertyRangeClassId(propertyId, this.getClassId(rc.asOWLClass()));
                        continue;
                    }
                    if (!(ax instanceof OWLObjectPropertyDomainAxiom) || !(rc = (rax = (OWLObjectPropertyDomainAxiom)ax).getDomain()).isNamed()) continue;
                    propertyId = this.getPropertyId((OWLObjectPropertyExpression)rax.getProperty());
                    oboGraphBuilder.addPropertyDomainClassId(propertyId, this.getClassId(rc.asOWLClass()));
                    continue;
                }
                oboGraphBuilder.addUntranslatedAxiom(ax);
                continue;
            }
            if (!(ax instanceof OWLAnnotationAssertionAxiom)) continue;
            OWLAnnotationAssertionAxiom aaa = (OWLAnnotationAssertionAxiom)ax;
            p = aaa.getProperty();
            OWLAnnotationSubject s = aaa.getSubject();
            if (s instanceof IRI) {
                IRI pIRI = p.getIRI();
                String subj = this.getNodeId((IRI)s);
                OWLAnnotationValue v = aaa.getValue();
                String lv = null;
                if (v instanceof OWLLiteral) {
                    lv = ((OWLLiteral)v).getLiteral();
                }
                if (p.isLabel() && lv != null) {
                    oboGraphBuilder.addNodeLabel(subj, lv);
                    continue;
                }
                if (this.isDefinitionProperty(pIRI) && lv != null) {
                    DefinitionPropertyValue def = new DefinitionPropertyValue.Builder().val(lv).xrefs((Iterable)meta.getXrefsValues()).meta(this.buildBasicPropertyValueMeta(meta)).build();
                    oboGraphBuilder.addNodeDefinitionPropertyValue(subj, def);
                    continue;
                }
                if (this.isHasXrefProperty(pIRI) && lv != null) {
                    XrefPropertyValue xref = new XrefPropertyValue.Builder().val(lv).meta(this.buildBasicPropertyValueMeta(meta)).build();
                    oboGraphBuilder.addNodeXrefPropertyValue(subj, xref);
                    continue;
                }
                if (p.isDeprecated() && aaa.isDeprecatedIRIAssertion()) {
                    oboGraphBuilder.setNodeDeprecated(subj, true);
                    continue;
                }
                if (p.isComment() && lv != null) {
                    oboGraphBuilder.addNodeComment(subj, lv);
                    continue;
                }
                if (this.isOboInOwlIdProperty(pIRI)) continue;
                if (this.isInSubsetProperty(pIRI)) {
                    oboGraphBuilder.addNodeSubset(subj, v.toString());
                    continue;
                }
                if (synonymVocabulary.contains(pIRI.toString()) && lv != null) {
                    AbstractSynonymPropertyValue.SCOPES scope = synonymVocabulary.get(pIRI.toString());
                    String synonymType = "";
                    for (OWLAnnotation a : aaa.getAnnotations()) {
                        if (!a.getProperty().getIRI().toString().equals("http://www.geneontology.org/formats/oboInOwl#hasSynonymType")) continue;
                        synonymType = a.getValue().toString();
                    }
                    SynonymPropertyValue syn = new SynonymPropertyValue.Builder().pred(scope.pred()).synonymType(synonymType).val(lv).xrefs((Iterable)meta.getXrefsValues()).meta(this.buildBasicPropertyValueMeta(meta)).build();
                    oboGraphBuilder.addNodeSynonymPropertyValue(subj, syn);
                    continue;
                }
                String val = v instanceof IRI ? ((IRI)v).toString() : (v instanceof OWLLiteral ? ((OWLLiteral)v).getLiteral() : (v instanceof OWLAnonymousIndividual ? ((OWLAnonymousIndividual)v).getID().toString() : ""));
                BasicPropertyValue basicPropertyValue = new BasicPropertyValue.Builder().pred(this.getPropertyId((OWLProperty)p)).val(val).meta(this.buildBasicPropertyValueMeta(meta)).build();
                oboGraphBuilder.addNodeBasicPropertyValue(subj, basicPropertyValue);
                continue;
            }
            oboGraphBuilder.addUntranslatedAxiom((OWLAxiom)aaa);
        }
        List<OWLAxiom> untranslatedAxioms = oboGraphBuilder.untranslatedAxioms();
        if (!untranslatedAxioms.isEmpty()) {
            LOGGER.warn("{} contains {} untranslated axioms:", (Object)graphId, (Object)untranslatedAxioms.size());
            untranslatedAxioms.forEach(axiom -> LOGGER.warn("{}", axiom));
        }
        return oboGraphBuilder.buildGraph();
    }

    private Meta buildMeta(OWLAxiom ax) {
        return this.buildMeta(ax.getAnnotations());
    }

    private Meta buildMeta(Set<OWLAnnotation> anns) {
        return this.buildMeta(anns, null);
    }

    private Meta buildMeta(Set<OWLAnnotation> anns, @Nullable String version) {
        Meta.Builder builder = new Meta.Builder();
        for (OWLAnnotation ann : anns) {
            String val;
            OWLAnnotationProperty p = ann.getProperty();
            OWLAnnotationValue v = ann.getValue();
            String string = val = v instanceof IRI ? ((IRI)v).toString() : ((OWLLiteral)v).getLiteral();
            if (ann.isDeprecatedIRIAnnotation()) {
                builder.deprecated(true);
                continue;
            }
            if (this.isHasXrefProperty(p.getIRI())) {
                builder.addXref(new XrefPropertyValue.Builder().val(val).build());
                continue;
            }
            if (this.isInSubsetProperty(p.getIRI())) {
                builder.addSubset(val);
                continue;
            }
            if (this.isHasSynonymTypeProperty(p.getIRI())) {
                builder.addSubset(val);
                continue;
            }
            builder.addBasicPropertyValue(new BasicPropertyValue.Builder().pred(this.getPropertyId((OWLProperty)p)).val(val).build());
        }
        if (version != null) {
            builder.version(version);
        }
        return builder.build();
    }

    private Meta buildBasicPropertyValueMeta(Meta existingMeta) {
        List basicPropertyValues = existingMeta.getBasicPropertyValues();
        return basicPropertyValues.isEmpty() ? null : new Meta.Builder().addAllBasicPropertyValues((Iterable)basicPropertyValues).build();
    }

    private Meta nullIfEmpty(Meta meta) {
        return NodeOrEdge.EMPTY_META.equals((Object)meta) ? null : meta;
    }

    private Edge buildEdge(String subj, String pred, String obj, @Nullable Meta meta) {
        return this.buildEdge(subj, pred, obj, meta, null);
    }

    private Edge buildEdge(String subj, String pred, String obj, @Nullable Meta meta, List<ExistentialRestrictionExpression> gciQualifiers) {
        if (NodeOrEdge.EMPTY_META.equals((Object)meta)) {
            return new Edge.Builder().sub(subj).pred(pred).obj(obj).build();
        }
        return new Edge.Builder().sub(subj).pred(pred).obj(obj).meta(meta).build();
    }

    @Nullable
    private ExistentialRestrictionExpression getRestriction(OWLClassExpression x) {
        if (x instanceof OWLObjectSomeValuesFrom) {
            OWLObjectSomeValuesFrom r = (OWLObjectSomeValuesFrom)x;
            OWLObjectPropertyExpression p = r.getProperty();
            OWLClassExpression f = (OWLClassExpression)r.getFiller();
            if (p instanceof OWLObjectProperty && !f.isAnonymous()) {
                return new ExistentialRestrictionExpression.Builder().propertyId(this.getPropertyId((OWLObjectProperty)p)).fillerId(this.getClassId((OWLClass)f)).build();
            }
        }
        return null;
    }

    @Nullable
    private OBOClassDef getClassDef(Set<OWLClassExpression> ixs) {
        OBOClassDef def = new OBOClassDef();
        boolean isLDA = true;
        for (OWLClassExpression ix : ixs) {
            if (!ix.isAnonymous()) {
                def.genusClassIds.add(this.getClassId((OWLClass)ix));
                continue;
            }
            if (ix instanceof OWLObjectSomeValuesFrom) {
                ExistentialRestrictionExpression restriction = this.getRestriction(ix);
                if (restriction == null) continue;
                def.restrs.add(restriction);
                continue;
            }
            isLDA = false;
            break;
        }
        return isLDA && !def.restrs.contains(null) ? def : null;
    }

    private String getPropertyId(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.getPropertyId(owlObjectPropertyExpression.asOWLObjectProperty());
    }

    private String getPropertyId(OWLObjectProperty p) {
        return p.getIRI().toString();
    }

    private String getPropertyId(OWLProperty p) {
        return p.getIRI().toString();
    }

    private String getClassId(OWLClass c) {
        return c.getIRI().toString();
    }

    private String getIndividualId(OWLIndividual owlIndividual) {
        if (owlIndividual instanceof OWLNamedIndividual) {
            return owlIndividual.asOWLNamedIndividual().getIRI().toString();
        }
        return owlIndividual.asOWLAnonymousIndividual().getID().toString();
    }

    private String getNodeId(IRI s) {
        return s.toString();
    }

    public boolean isDefinitionProperty(IRI iri) {
        return iri.toString().equals("http://purl.obolibrary.org/obo/IAO_0000115");
    }

    public boolean isHasXrefProperty(IRI iri) {
        return iri.toString().equals("http://www.geneontology.org/formats/oboInOwl#hasDbXref");
    }

    public boolean isInSubsetProperty(IRI iri) {
        return iri.toString().equals("http://www.geneontology.org/formats/oboInOwl#inSubset");
    }

    public boolean isHasSynonymTypeProperty(IRI iri) {
        return iri.toString().equals("http://www.geneontology.org/formats/oboInOwl#hasSynonymType");
    }

    public boolean isOboInOwlIdProperty(IRI iri) {
        return iri.toString().equals("http://www.geneontology.org/formats/oboInOwl#id");
    }

    static class OboGraphBuilder {
        private final String graphId;
        private final Meta meta;
        private final List<Edge> edges = new ArrayList<Edge>();
        private final List<EquivalentNodesSet> ensets = new ArrayList<EquivalentNodesSet>();
        private final List<LogicalDefinitionAxiom> ldas = new ArrayList<LogicalDefinitionAxiom>();
        private final Set<String> nodeIds = new LinkedHashSet<String>();
        private final Map<String, AbstractNode.RDFTYPES> nodeTypeMap = new LinkedHashMap<String, AbstractNode.RDFTYPES>();
        private final Map<String, String> nodeLabelMap = new LinkedHashMap<String, String>();
        private final Map<String, DomainRangeAxiom.Builder> domainRangeBuilderMap = new LinkedHashMap<String, DomainRangeAxiom.Builder>();
        private final List<PropertyChainAxiom> pcas = new ArrayList<PropertyChainAxiom>();
        private final Map<String, Meta.Builder> nodeMetaBuilderMap = new LinkedHashMap<String, Meta.Builder>();
        private final Set<OWLAxiom> untranslatedAxioms = new LinkedHashSet<OWLAxiom>();
        private final LinkedHashMap<String, AbstractNode.PropertyType> nodePropertyTypeMap = new LinkedHashMap();

        public OboGraphBuilder(String graphId, @Nullable Meta graphMeta) {
            this.graphId = graphId == null ? "" : graphId;
            this.meta = this.nullIfEmpty(graphMeta);
        }

        @Nullable
        private Meta nullIfEmpty(@Nullable Meta meta) {
            return NodeOrEdge.EMPTY_META.equals((Object)meta) ? null : meta;
        }

        public void addNodeId(String nodeId) {
            this.nodeIds.add(nodeId);
        }

        public void addNodeType(String nodeId, AbstractNode.RDFTYPES rdftypes) {
            this.nodeIds.add(nodeId);
            this.nodeTypeMap.put(nodeId, rdftypes);
        }

        public void addNodeType(String nodeId, AbstractNode.PropertyType propertyType) {
            this.nodeIds.add(nodeId);
            this.nodeTypeMap.put(nodeId, AbstractNode.RDFTYPES.PROPERTY);
            this.nodePropertyTypeMap.put(nodeId, propertyType);
        }

        public void addNodeLabel(String nodeId, String label) {
            this.nodeIds.add(nodeId);
            this.nodeLabelMap.put(nodeId, label);
        }

        public void addEdge(Edge edge) {
            if (edge != null) {
                this.edges.add(edge);
            }
        }

        public void addEdge(String subj, String pred, String obj, @Nullable Meta meta) {
            this.edges.add(this.buildEdge(subj, pred, obj, meta));
        }

        private Edge buildEdge(String subj, String pred, String obj, @Nullable Meta meta) {
            if (meta == null || NodeOrEdge.EMPTY_META.equals((Object)meta)) {
                return new Edge.Builder().sub(subj).pred(pred).obj(obj).build();
            }
            return new Edge.Builder().sub(subj).pred(pred).obj(obj).meta(meta).build();
        }

        public void addNodeDefinitionPropertyValue(String nodeId, DefinitionPropertyValue def) {
            Meta.Builder nb = this.getMetaBuilderForId(nodeId);
            nb.definition(def);
            this.nodeIds.add(nodeId);
        }

        public void addNodeXrefPropertyValue(String nodeId, XrefPropertyValue xrefPropertyValue) {
            Meta.Builder nb = this.getMetaBuilderForId(nodeId);
            nb.addXref(xrefPropertyValue);
            this.nodeIds.add(nodeId);
        }

        public void setNodeDeprecated(String nodeId, boolean isDeprecated) {
            Meta.Builder nb = this.getMetaBuilderForId(nodeId);
            nb.deprecated(isDeprecated);
            this.nodeIds.add(nodeId);
        }

        public void addNodeComment(String nodeId, String comment) {
            Meta.Builder nb = this.getMetaBuilderForId(nodeId);
            nb.addComment(comment);
            this.nodeIds.add(nodeId);
        }

        public void addNodeSubset(String nodeId, String subset) {
            Meta.Builder nb = this.getMetaBuilderForId(nodeId);
            nb.addSubset(subset);
            this.nodeIds.add(nodeId);
        }

        public void addNodeSynonymPropertyValue(String nodeId, SynonymPropertyValue syn) {
            Meta.Builder nb = this.getMetaBuilderForId(nodeId);
            nb.addSynonym(syn);
            this.nodeIds.add(nodeId);
        }

        public void addNodeBasicPropertyValue(String nodeId, BasicPropertyValue basicPropertyValue) {
            Meta.Builder nb = this.getMetaBuilderForId(nodeId);
            nb.addBasicPropertyValue(basicPropertyValue);
            this.nodeIds.add(nodeId);
        }

        private Meta.Builder getMetaBuilderForId(String id) {
            return this.nodeMetaBuilderMap.computeIfAbsent(id, k -> new Meta.Builder());
        }

        public void addUntranslatedAxiom(OWLAxiom owlAxiom) {
            this.untranslatedAxioms.add(owlAxiom);
        }

        public void addPropertyEdgeDefinitions(String propertyId, Edge edge) {
            DomainRangeAxiom.Builder b = this.getDomainRangeAxiomBuilder(propertyId);
            b.addAllValuesFromEdge(edge);
        }

        public void addPropertyDomainClassId(String propertyId, String domainClassId) {
            DomainRangeAxiom.Builder b = this.getDomainRangeAxiomBuilder(propertyId);
            b.addDomainClassId(domainClassId);
        }

        public void addPropertyRangeClassId(String propertyId, String rangeClassId) {
            DomainRangeAxiom.Builder b = this.getDomainRangeAxiomBuilder(propertyId);
            b.addRangeClassId(rangeClassId);
        }

        private DomainRangeAxiom.Builder getDomainRangeAxiomBuilder(String propertyId) {
            return this.domainRangeBuilderMap.computeIfAbsent(propertyId, id -> new DomainRangeAxiom.Builder().predicateId(id));
        }

        public void addLogicalDefinitionAxiom(LogicalDefinitionAxiom logicalDefinitionAxiom) {
            this.ldas.add(logicalDefinitionAxiom);
        }

        public void addPropertyChainAxiom(PropertyChainAxiom propertyChainAxiom) {
            this.pcas.add(propertyChainAxiom);
        }

        public void addEquivalentNodesSet(EquivalentNodesSet equivalentNodesSet) {
            this.ensets.add(equivalentNodesSet);
        }

        public List<OWLAxiom> untranslatedAxioms() {
            return List.copyOf(this.untranslatedAxioms);
        }

        public Graph buildGraph() {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (String n : this.nodeIds) {
                Node.Builder nb = new Node.Builder().id(n).label(this.nodeLabelMap.getOrDefault(n, ""));
                if (this.nodeMetaBuilderMap.containsKey(n)) {
                    Meta nodeMeta = this.nodeMetaBuilderMap.get(n).build();
                    nb.meta(this.nullIfEmpty(nodeMeta));
                }
                if (this.nodeTypeMap.containsKey(n)) {
                    AbstractNode.RDFTYPES type = this.nodeTypeMap.get(n);
                    nb.type(type);
                    if (type == AbstractNode.RDFTYPES.PROPERTY) {
                        AbstractNode.PropertyType propertyType = this.nodePropertyTypeMap.get(n);
                        nb.propertyType(propertyType);
                    }
                }
                nodes.add(nb.build());
            }
            List domainRangeAxioms = this.domainRangeBuilderMap.values().stream().map(DomainRangeAxiom.Builder::build).collect(Collectors.toList());
            return new Graph.Builder().id(this.graphId).meta(this.meta).nodes(nodes).edges(this.edges).equivalentNodesSets(this.ensets).logicalDefinitionAxioms(this.ldas).domainRangeAxioms(domainRangeAxioms).propertyChainAxioms(this.pcas).build();
        }
    }

    static class OBOClassDef {
        final List<String> genusClassIds = new ArrayList<String>();
        final List<ExistentialRestrictionExpression> restrs = new ArrayList<ExistentialRestrictionExpression>();

        OBOClassDef() {
        }
    }
}

