package org.geneontology.owl.differ

import org.geneontology.owl.differ.Differ.BasicDiff
import org.geneontology.owl.differ.render.BasicDiffRenderer
import org.geneontology.owl.differ.shortform.{DoubleShortFormProvider, OBOShortenerShortFormProvider}
import org.semanticweb.owlapi.apibinding.OWLManager
import org.semanticweb.owlapi.model.{OWLAnnotationProperty, OWLOntology}
import org.semanticweb.owlapi.util.{AnnotationValueShortFormProvider, QNameShortFormProvider, SimpleIRIShortFormProvider}

import scala.collection.JavaConverters._

object ROBOTDiff {

  private val factory = OWLManager.getOWLDataFactory
  private val rdfsLabel = factory.getRDFSLabel

  def render(diff: BasicDiff, renderingOnt: OWLOntology): String = {
    val labelProvider = new AnnotationValueShortFormProvider(
      renderingOnt.getOWLOntologyManager,
      new QNameShortFormProvider(),
      new SimpleIRIShortFormProvider(),
      List(rdfsLabel).asJava,
      Map.empty[OWLAnnotationProperty, java.util.List[String]].asJava
    )
    val iriProvider = new OBOShortenerShortFormProvider(new QNameShortFormProvider())
    val doubleProvider = new DoubleShortFormProvider(iriProvider, labelProvider)
    BasicDiffRenderer.render(diff, doubleProvider)
  }

}
