/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.owl.differ.render;

import com.google.common.base.Optional;
import java.io.Serializable;
import org.apache.commons.text.StringEscapeUtils;
import org.geneontology.owl.differ.Differ;
import org.geneontology.owl.differ.Differ$GCIGrouping$;
import org.geneontology.owl.differ.Differ$OntologyAnnotationGrouping$;
import org.geneontology.owl.differ.Differ$OntologyImportGrouping$;
import org.geneontology.owl.differ.Differ$RuleGrouping$;
import org.geneontology.owl.differ.ManchesterSyntaxOWLObjectRenderer;
import org.geneontology.owl.differ.Util$;
import org.geneontology.owl.differ.Util$OptionalOption$;
import org.geneontology.owl.differ.shortform.HTMLLinkShortFormProvider;
import org.geneontology.owl.differ.shortform.HTMLSafeIRIShortFormProvider;
import org.geneontology.owl.differ.shortform.HTMLSafeShortFormProvider;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.util.AnnotationValueShortFormProvider;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleIRIShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class HTMLDiffRenderer$ {
    public static final HTMLDiffRenderer$ MODULE$ = new HTMLDiffRenderer$();
    private static final OWLDataFactory factory = OWLManager.getOWLDataFactory();
    private static final OWLAnnotationProperty rdfsLabel = MODULE$.factory().getRDFSLabel();

    private OWLDataFactory factory() {
        return factory;
    }

    private OWLAnnotationProperty rdfsLabel() {
        return rdfsLabel;
    }

    public String render(Differ.GroupedDiff diff, OWLOntologySetProvider renderingOntologyProvider) {
        HTMLSafeShortFormProvider shortFormProvider = new HTMLSafeShortFormProvider((ShortFormProvider)new AnnotationValueShortFormProvider(renderingOntologyProvider, (ShortFormProvider)new SimpleShortFormProvider(), (IRIShortFormProvider)new HTMLSafeIRIShortFormProvider((IRIShortFormProvider)new SimpleIRIShortFormProvider()), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OWLAnnotationProperty[]{this.rdfsLabel()}))).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava()));
        HTMLLinkShortFormProvider htmlLinkShortFormProvider = new HTMLLinkShortFormProvider(shortFormProvider);
        ManchesterSyntaxOWLObjectRenderer labelRenderer = new ManchesterSyntaxOWLObjectRenderer();
        labelRenderer.setShortFormProvider(shortFormProvider);
        ManchesterSyntaxOWLObjectRenderer htmlRenderer = new ManchesterSyntaxOWLObjectRenderer();
        htmlRenderer.setShortFormProvider(htmlLinkShortFormProvider);
        scala.collection.immutable.Map groupsToLabels = ((IterableOnceOps)diff.groups().keys().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            Differ.Grouping grouping = x0$1;
            if (grouping instanceof Differ.IRIGrouping) {
                Differ.IRIGrouping iRIGrouping = (Differ.IRIGrouping)grouping;
                IRI iri = iRIGrouping.term();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)iRIGrouping), (Object)labelRenderer.render((OWLObject)MODULE$.factory().getOWLClass(iri)));
            } else if (Differ$GCIGrouping$.MODULE$.equals(grouping)) {
                Differ.Grouping grouping2 = grouping;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)grouping2), (Object)"GCIs");
            } else if (Differ$RuleGrouping$.MODULE$.equals(grouping)) {
                Differ.Grouping grouping3 = grouping;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)grouping3), (Object)"Rules");
            } else if (grouping instanceof Differ.NonIRIGrouping) {
                Differ.NonIRIGrouping nonIRIGrouping = (Differ.NonIRIGrouping)grouping;
                OWLObject obj = nonIRIGrouping.obj();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonIRIGrouping), (Object)labelRenderer.render(obj));
            } else if (Differ$OntologyImportGrouping$.MODULE$.equals(grouping)) {
                Differ.Grouping grouping4 = grouping;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)grouping4), (Object)"Ontology imports");
            } else if (Differ$OntologyAnnotationGrouping$.MODULE$.equals(grouping)) {
                Differ.Grouping grouping5 = grouping;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)grouping5), (Object)"Ontology annotations");
            } else {
                throw new MatchError((Object)grouping);
            }
            return tuple2;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Differ$OntologyImportGrouping$ differ$OntologyImportGrouping$ = Differ$OntologyImportGrouping$.MODULE$;
        Differ$OntologyAnnotationGrouping$ differ$OntologyAnnotationGrouping$ = Differ$OntologyAnnotationGrouping$.MODULE$;
        List sortedGroups = ((List)diff.groups().$minus((Object)Differ$OntologyImportGrouping$.MODULE$).$minus((Object)Differ$OntologyAnnotationGrouping$.MODULE$).keys().toList().sortBy((Function1)groupsToLabels, (Ordering)Ordering.String$.MODULE$)).$colon$colon((Object)differ$OntologyAnnotationGrouping$).$colon$colon((Object)differ$OntologyImportGrouping$);
        String content = sortedGroups.map((Function1 & Serializable)group -> {
            String string;
            scala.collection.immutable.Seq removed = (scala.collection.immutable.Seq)((IterableOnceOps)((IterableOps)diff.groups().apply(group)).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.added()))).toSeq().sortBy((Function1 & Serializable)modifiedItem -> HTMLDiffRenderer$.sortKey$1(modifiedItem), (Ordering)Ordering.String$.MODULE$);
            scala.collection.immutable.Seq added = (scala.collection.immutable.Seq)((IterableOnceOps)((IterableOps)diff.groups().apply(group)).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.added()))).toSeq().sortBy((Function1 & Serializable)modifiedItem -> HTMLDiffRenderer$.sortKey$1(modifiedItem), (Ordering)Ordering.String$.MODULE$);
            String removedList = removed.nonEmpty() ? this.changeList$1("Removed", (scala.collection.immutable.Seq)removed.map((Function1 & Serializable)x$5 -> x$5.owlObject()), htmlRenderer) : "";
            String addedList = added.nonEmpty() ? this.changeList$1("Added", (scala.collection.immutable.Seq)added.map((Function1 & Serializable)x$6 -> x$6.owlObject()), htmlRenderer) : "";
            String header = (String)groupsToLabels.apply(group);
            Differ.Grouping grouping = group;
            if (grouping instanceof Differ.IRIGrouping) {
                Differ.IRIGrouping iRIGrouping = (Differ.IRIGrouping)grouping;
                IRI iri = iRIGrouping.term();
                string = new StringBuilder(2).append("- ").append((CharSequence)iri).toString();
            } else {
                string = "";
            }
            String headerIRI = string;
            return HTMLDiffRenderer$.frameElement$1(header, headerIRI, removedList, addedList);
        }).mkString("\n\n");
        return new StringBuilder(666).append("\n<!DOCTYPE html>\n<html>\n<head>\n\t<meta charset=\"utf-8\">\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n  <style>\ndiv.frame {\n    margin-top: 2.5em;\n}\n.status-header {\n    font-style: italic;\n    margin-top: 0;\n    margin-bottom: 0;\n}\n.frame > ul {\n    margin-top: 0.3em;\n}\nh3 {\n    margin-bottom: 0.5em;\n}\n.frame-iri {\n    color: gray;\n    font-size: 80%;\n}\n</style>\n\t<title>OWL diff</title>\n</head>\n<body>\n\n<h2>Ontology comparison</h2>\n<h3>Left</h3>\n<ul>\n<li>Ontology IRI: ").append(this.optionalIRI((Optional<IRI>)diff.left().getOntologyIRI())).append("</li>\n<li>Version IRI: ").append(this.optionalIRI((Optional<IRI>)diff.left().getVersionIRI())).append("</li>\n<li>Loaded from: ").append(StringEscapeUtils.escapeHtml4((String)diff.leftSource().toQuotedString())).append("</li>\n</ul>\n<h3>Right</h3>\n<ul>\n<li>Ontology IRI: ").append(this.optionalIRI((Optional<IRI>)diff.right().getOntologyIRI())).append("</li>\n<li>Version IRI: ").append(this.optionalIRI((Optional<IRI>)diff.right().getVersionIRI())).append("</li>\n<li>Loaded from: ").append(StringEscapeUtils.escapeHtml4((String)diff.rightSource().toQuotedString())).append("</li>\n</ul>\n").append(content).append("\n</body>\n      ").toString();
    }

    private String optionalIRI(Optional<IRI> iriOpt) {
        return (String)Util$OptionalOption$.MODULE$.toOption$extension(Util$.MODULE$.OptionalOption(iriOpt)).map((Function1 & Serializable)iri -> StringEscapeUtils.escapeHtml4((String)iri.toQuotedString())).getOrElse((Function0 & Serializable)() -> "<i>None</i>");
    }

    private final String htmlForObject$1(OWLObject obj, ManchesterSyntaxOWLObjectRenderer htmlRenderer$1) {
        Tuple2 tuple2;
        OWLObject oWLObject = obj;
        if (oWLObject instanceof HasAnnotations) {
            OWLAxiom oWLAxiom;
            OWLObject oWLObject2 = oWLObject;
            String inner = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaSetConverter(((HasAnnotations)oWLObject2).getAnnotations()).asScala()).map((Function1 & Serializable)x$1 -> this.htmlForObject$1((OWLObject)x$1, htmlRenderer$1))).mkString("\n");
            OWLObject oWLObject3 = obj;
            if (oWLObject3 instanceof OWLAxiom) {
                OWLAxiom oWLAxiom2 = (OWLAxiom)oWLObject3;
                oWLAxiom = oWLAxiom2.getAxiomWithoutAnnotations();
            } else if (oWLObject3 instanceof OWLAnnotation) {
                OWLAnnotation oWLAnnotation = (OWLAnnotation)oWLObject3;
                oWLAxiom = this.factory().getOWLAnnotation(oWLAnnotation.getProperty(), oWLAnnotation.getValue());
            } else {
                oWLAxiom = obj;
            }
            OWLAxiom objWithoutAnnotations = oWLAxiom;
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(9).append("<ul>").append(inner).append("</ul>").toString()), (Object)objWithoutAnnotations);
        } else {
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)obj);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String annotations = (String)tuple22._1();
        OWLObject objToRender = (OWLObject)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)annotations, (Object)objToRender);
        Tuple2 tuple24 = tuple23;
        String annotations2 = (String)tuple24._1();
        OWLObject objToRender2 = (OWLObject)tuple24._2();
        return new StringBuilder(38).append("<li><span class=\"axiom\">").append(htmlRenderer$1.render(objToRender2)).append("</span> ").append(annotations2).append(" </li>").toString();
    }

    private final String changeList$1(String header, scala.collection.immutable.Seq axioms, ManchesterSyntaxOWLObjectRenderer htmlRenderer$1) {
        return new StringBuilder(85).append("\n        <h4 class=\"status-header\">").append(header).append("</h4>\n        <ul>\n        ").append(((IterableOnceOps)axioms.map((Function1 & Serializable)obj -> this.htmlForObject$1((OWLObject)obj, htmlRenderer$1))).mkString("\n")).append("\n        </ul>\n        ").toString();
    }

    private static final String frameElement$1(String header, String headerIRI, String removedList, String addedList) {
        return new StringBuilder(102).append("<div class=\"frame\">\n        <h3>").append(header).append(" <span class=\"frame-iri\">").append(headerIRI).append("</span></h3>\n        ").append(removedList).append("\n        ").append(addedList).append("\n        </div>").toString();
    }

    private static final String sortKey$1(Differ.ModifiedOntologyContent modifiedItem) {
        String string;
        Differ.ModifiedOntologyContent modifiedOntologyContent = modifiedItem;
        if (modifiedOntologyContent instanceof Differ.ModifiedAnnotation) {
            Differ.ModifiedAnnotation modifiedAnnotation = (Differ.ModifiedAnnotation)modifiedOntologyContent;
            OWLAnnotation item = modifiedAnnotation.item();
            string = item.toString();
        } else if (modifiedOntologyContent instanceof Differ.ModifiedImport) {
            Differ.ModifiedImport modifiedImport = (Differ.ModifiedImport)modifiedOntologyContent;
            OWLImportsDeclaration item = modifiedImport.item();
            string = item.toString();
        } else if (modifiedOntologyContent instanceof Differ.ModifiedAxiom) {
            Differ.ModifiedAxiom modifiedAxiom = (Differ.ModifiedAxiom)modifiedOntologyContent;
            OWLAxiom item = modifiedAxiom.item();
            string = item.getAxiomType().getName();
        } else {
            throw new MatchError((Object)modifiedOntologyContent);
        }
        return string;
    }

    private HTMLDiffRenderer$() {
    }
}

