/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.owl.differ.render;

import com.google.common.base.Optional;
import java.io.Serializable;
import org.geneontology.owl.differ.Differ;
import org.geneontology.owl.differ.Differ$GCIGrouping$;
import org.geneontology.owl.differ.Differ$OntologyAnnotationGrouping$;
import org.geneontology.owl.differ.Differ$OntologyImportGrouping$;
import org.geneontology.owl.differ.Differ$RuleGrouping$;
import org.geneontology.owl.differ.ManchesterSyntaxOWLObjectRenderer;
import org.geneontology.owl.differ.Util$;
import org.geneontology.owl.differ.Util$OptionalOption$;
import org.geneontology.owl.differ.shortform.MarkdownLinkShortFormProvider;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.OWLObjectRenderer;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.util.AnnotationValueShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class MarkdownGroupedDiffRenderer$ {
    public static final MarkdownGroupedDiffRenderer$ MODULE$ = new MarkdownGroupedDiffRenderer$();
    private static final OWLDataFactory factory = OWLManager.getOWLDataFactory();
    private static final OWLAnnotationProperty rdfsLabel = MODULE$.factory().getRDFSLabel();

    private OWLDataFactory factory() {
        return factory;
    }

    private OWLAnnotationProperty rdfsLabel() {
        return rdfsLabel;
    }

    public String render(Differ.GroupedDiff diff, OWLOntologySetProvider renderingOntologyProvider) {
        AnnotationValueShortFormProvider labelProvider = new AnnotationValueShortFormProvider((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OWLAnnotationProperty[]{this.rdfsLabel()}))).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava(), renderingOntologyProvider);
        MarkdownLinkShortFormProvider markdownLinkProvider = new MarkdownLinkShortFormProvider((ShortFormProvider)labelProvider);
        ManchesterSyntaxOWLObjectRenderer labelRenderer = new ManchesterSyntaxOWLObjectRenderer();
        labelRenderer.setShortFormProvider((ShortFormProvider)labelProvider);
        ManchesterSyntaxOWLObjectRenderer markdownRenderer = new ManchesterSyntaxOWLObjectRenderer();
        markdownRenderer.setShortFormProvider(markdownLinkProvider);
        scala.collection.immutable.Map groupsToLabels = ((IterableOnceOps)diff.groups().keys().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            Differ.Grouping grouping = x0$1;
            if (grouping instanceof Differ.IRIGrouping) {
                Differ.IRIGrouping iRIGrouping = (Differ.IRIGrouping)grouping;
                IRI iri = iRIGrouping.term();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)iRIGrouping), (Object)labelRenderer.render((OWLObject)MODULE$.factory().getOWLClass(iri)));
            } else if (Differ$GCIGrouping$.MODULE$.equals(grouping)) {
                Differ.Grouping grouping2 = grouping;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)grouping2), (Object)"GCIs");
            } else if (Differ$RuleGrouping$.MODULE$.equals(grouping)) {
                Differ.Grouping grouping3 = grouping;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)grouping3), (Object)"Rules");
            } else if (grouping instanceof Differ.NonIRIGrouping) {
                Differ.NonIRIGrouping nonIRIGrouping = (Differ.NonIRIGrouping)grouping;
                OWLObject obj = nonIRIGrouping.obj();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonIRIGrouping), (Object)labelRenderer.render(obj));
            } else if (Differ$OntologyImportGrouping$.MODULE$.equals(grouping)) {
                Differ.Grouping grouping4 = grouping;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)grouping4), (Object)"Ontology imports");
            } else if (Differ$OntologyAnnotationGrouping$.MODULE$.equals(grouping)) {
                Differ.Grouping grouping5 = grouping;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)grouping5), (Object)"Ontology annotations");
            } else {
                throw new MatchError((Object)grouping);
            }
            return tuple2;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Differ$OntologyImportGrouping$ differ$OntologyImportGrouping$ = Differ$OntologyImportGrouping$.MODULE$;
        Differ$OntologyAnnotationGrouping$ differ$OntologyAnnotationGrouping$ = Differ$OntologyAnnotationGrouping$.MODULE$;
        List sortedGroups = ((List)diff.groups().$minus((Object)Differ$OntologyImportGrouping$.MODULE$).$minus((Object)Differ$OntologyAnnotationGrouping$.MODULE$).keys().toList().sortBy((Function1)groupsToLabels, (Ordering)Ordering.String$.MODULE$)).$colon$colon((Object)differ$OntologyAnnotationGrouping$).$colon$colon((Object)differ$OntologyImportGrouping$);
        String content = sortedGroups.map((Function1 & Serializable)group -> {
            None$ none$;
            scala.collection.immutable.Seq removed = (scala.collection.immutable.Seq)((IterableOnceOps)((IterableOps)diff.groups().apply(group)).filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.added()))).toSeq().sortBy((Function1 & Serializable)modifiedItem -> MarkdownGroupedDiffRenderer$.sortKey$1(modifiedItem), (Ordering)Ordering.String$.MODULE$);
            scala.collection.immutable.Seq added = (scala.collection.immutable.Seq)((IterableOnceOps)((IterableOps)diff.groups().apply(group)).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.added()))).toSeq().sortBy((Function1 & Serializable)modifiedItem -> MarkdownGroupedDiffRenderer$.sortKey$1(modifiedItem), (Ordering)Ordering.String$.MODULE$);
            String removedList = removed.nonEmpty() ? MODULE$.changeList("Removed", (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)((IterableOps)removed.map((Function1 & Serializable)x$3 -> x$3.owlObject())).map((Function1 & Serializable)item -> MODULE$.markdownForObject((OWLObject)item, markdownRenderer, MODULE$.markdownForObject$default$3())))) : "";
            String addedList = added.nonEmpty() ? MODULE$.changeList("Added", (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)((IterableOps)added.map((Function1 & Serializable)x$4 -> x$4.owlObject())).map((Function1 & Serializable)item -> MODULE$.markdownForObject((OWLObject)item, markdownRenderer, MODULE$.markdownForObject$default$3())))) : "";
            String header = (String)groupsToLabels.apply(group);
            Differ.Grouping grouping = group;
            if (grouping instanceof Differ.IRIGrouping) {
                Differ.IRIGrouping iRIGrouping = (Differ.IRIGrouping)grouping;
                IRI iri = iRIGrouping.term();
                none$ = new Some((Object)iri.toString());
            } else {
                none$ = None$.MODULE$;
            }
            None$ headerIRI = none$;
            return MODULE$.frameElement(header, (Option<String>)headerIRI, removedList, addedList);
        }).mkString("\n\n");
        String header = new StringBuilder(142).append("# Ontology comparison\n\n## Left\n- Ontology IRI: ").append(this.optionalIRI((Optional<IRI>)diff.left().getOntologyIRI())).append("\n- Version IRI: ").append(this.optionalIRI((Optional<IRI>)diff.left().getVersionIRI())).append("\n- Loaded from: `").append((CharSequence)diff.leftSource()).append("`\n\n## Right\n- Ontology IRI: ").append(this.optionalIRI((Optional<IRI>)diff.right().getOntologyIRI())).append("\n- Version IRI: ").append(this.optionalIRI((Optional<IRI>)diff.right().getVersionIRI())).append("\n- Loaded from: `").append((CharSequence)diff.rightSource()).append("`").toString();
        return new StringBuilder(2).append(header).append("\n\n").append(content).toString();
    }

    public String markdownForObject(OWLObject obj, OWLObjectRenderer renderer, int level) {
        Tuple2 tuple2;
        OWLObject oWLObject = obj;
        if (oWLObject instanceof HasAnnotations) {
            OWLAxiom oWLAxiom;
            OWLObject oWLObject2 = oWLObject;
            String inner = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaSetConverter(((HasAnnotations)oWLObject2).getAnnotations()).asScala()).map((Function1 & Serializable)x$5 -> MODULE$.markdownForObject((OWLObject)x$5, renderer, level + 1))).mkString("\n");
            OWLObject oWLObject3 = obj;
            if (oWLObject3 instanceof OWLAxiom) {
                OWLAxiom oWLAxiom2 = (OWLAxiom)oWLObject3;
                oWLAxiom = oWLAxiom2.getAxiomWithoutAnnotations();
            } else if (oWLObject3 instanceof OWLAnnotation) {
                OWLAnnotation oWLAnnotation = (OWLAnnotation)oWLObject3;
                oWLAxiom = this.factory().getOWLAnnotation(oWLAnnotation.getProperty(), oWLAnnotation.getValue());
            } else {
                oWLAxiom = obj;
            }
            OWLAxiom objWithoutAnnotations = oWLAxiom;
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append("\n").append(inner).toString()), (Object)objWithoutAnnotations);
        } else {
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)obj);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String annotations = (String)tuple22._1();
        OWLObject objToRender = (OWLObject)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)annotations, (Object)objToRender);
        Tuple2 tuple24 = tuple23;
        String annotations2 = (String)tuple24._1();
        OWLObject objToRender2 = (OWLObject)tuple24._2();
        String indentation = StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(""), level * 2, ' ');
        return new StringBuilder(3).append(indentation).append("- ").append(renderer.render(objToRender2)).append(" ").append(annotations2).toString();
    }

    public int markdownForObject$default$3() {
        return 0;
    }

    public String changeList(String header, scala.collection.immutable.Seq<String> renderedAxioms) {
        return new StringBuilder(6).append("#### ").append(header).append("\n").append(renderedAxioms.mkString("\n")).toString();
    }

    public String frameElement(String header, Option<String> headerIRI, String removedList, String addedList) {
        String iri2 = (String)headerIRI.map((Function1 & Serializable)iri -> new StringBuilder(2).append("`").append((String)iri).append("`").toString()).getOrElse((Function0 & Serializable)() -> "");
        return new StringBuilder(7).append("### ").append(header).append(" ").append(iri2).append("\n").append(removedList).append("\n").append(addedList).toString();
    }

    private String optionalIRI(Optional<IRI> iriOpt) {
        return (String)Util$OptionalOption$.MODULE$.toOption$extension(Util$.MODULE$.OptionalOption(iriOpt)).map((Function1 & Serializable)iri -> new StringBuilder(2).append("`").append((CharSequence)iri).append("`").toString()).getOrElse((Function0 & Serializable)() -> "*None*");
    }

    private static final String sortKey$1(Differ.ModifiedOntologyContent modifiedItem) {
        String string;
        Differ.ModifiedOntologyContent modifiedOntologyContent = modifiedItem;
        if (modifiedOntologyContent instanceof Differ.ModifiedAnnotation) {
            Differ.ModifiedAnnotation modifiedAnnotation = (Differ.ModifiedAnnotation)modifiedOntologyContent;
            OWLAnnotation item = modifiedAnnotation.item();
            string = item.toString();
        } else if (modifiedOntologyContent instanceof Differ.ModifiedImport) {
            Differ.ModifiedImport modifiedImport = (Differ.ModifiedImport)modifiedOntologyContent;
            OWLImportsDeclaration item = modifiedImport.item();
            string = item.toString();
        } else if (modifiedOntologyContent instanceof Differ.ModifiedAxiom) {
            Differ.ModifiedAxiom modifiedAxiom = (Differ.ModifiedAxiom)modifiedOntologyContent;
            OWLAxiom item = modifiedAxiom.item();
            string = item.getAxiomType().getName();
        } else {
            throw new MatchError((Object)modifiedOntologyContent);
        }
        return string;
    }

    private MarkdownGroupedDiffRenderer$() {
    }
}

