/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.owl.differ.render;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.geneontology.owl.differ.Differ;
import org.geneontology.owl.differ.ShortFormFunctionalSyntaxObjectRenderer;
import org.geneontology.owl.differ.Util$;
import org.geneontology.owl.differ.render.BasicDiffRenderer;
import org.geneontology.owl.differ.render.BasicDiffRenderer$OWLImportItem$;
import org.geneontology.owl.differ.render.BasicDiffRenderer$OWLObjectItem$;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.util.ShortFormProvider;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.util.Using;
import scala.util.Using$;

public final class BasicDiffRenderer$ {
    public static final BasicDiffRenderer$ MODULE$ = new BasicDiffRenderer$();

    public void renderPlainStream(Differ.BasicDiff diff, OutputStream stream) {
        Using$.MODULE$.resource((Object)new PrintWriter(stream), (Function1 & Serializable)writer -> {
            BasicDiffRenderer$.MODULE$.renderPlainWriter(diff, writer);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public void renderPlainWriter(Differ.BasicDiff diff, Writer givenWriter) {
        Using$.MODULE$.resource((Object)new PrintWriter(givenWriter), (Function1 & Serializable)writer -> {
            BasicDiffRenderer$.$anonfun$renderPlainWriter$1(diff, writer);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public String renderPlain(Differ.BasicDiff diff) {
        return (String)Using$.MODULE$.resource((Object)new ByteArrayOutputStream(), (Function1 & Serializable)stream -> {
            MODULE$.renderPlainStream(diff, (OutputStream)stream);
            return stream.toString(StandardCharsets.UTF_8);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public void renderStream(Differ.BasicDiff diff, ShortFormProvider shortFormProvider, OutputStream stream) {
        Using$.MODULE$.resource((Object)new PrintWriter(stream), (Function1 & Serializable)writer -> {
            BasicDiffRenderer$.MODULE$.renderWriter(diff, shortFormProvider, writer);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public void renderWriter(Differ.BasicDiff diff, ShortFormProvider shortFormProvider, Writer givenWriter) {
        Using$.MODULE$.resource((Object)new PrintWriter(givenWriter), (Function1 & Serializable)writer -> {
            BasicDiffRenderer$.$anonfun$renderWriter$1(diff, shortFormProvider, writer);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public String render(Differ.BasicDiff diff, ShortFormProvider shortFormProvider) {
        return (String)Using$.MODULE$.resource((Object)new ByteArrayOutputStream(), (Function1 & Serializable)stream -> {
            MODULE$.renderStream(diff, shortFormProvider, (OutputStream)stream);
            return stream.toString(StandardCharsets.UTF_8);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private Tuple2<Set<BasicDiffRenderer.OWLItem<?>>, Set<BasicDiffRenderer.OWLItem<?>>> groups(Differ.BasicDiff diff) {
        Set leftUnique = (Set)((IterableOps)((IterableOps)diff.left().imports().map((Function1)BasicDiffRenderer$OWLImportItem$.MODULE$)).$plus$plus((IterableOnce)diff.left().annotations().map((Function1)BasicDiffRenderer$OWLObjectItem$.MODULE$))).$plus$plus((IterableOnce)diff.left().axioms().map((Function1)BasicDiffRenderer$OWLObjectItem$.MODULE$));
        Set rightUnique = (Set)((IterableOps)((IterableOps)diff.right().imports().map((Function1)BasicDiffRenderer$OWLImportItem$.MODULE$)).$plus$plus((IterableOnce)diff.right().annotations().map((Function1)BasicDiffRenderer$OWLObjectItem$.MODULE$))).$plus$plus((IterableOnce)diff.right().axioms().map((Function1)BasicDiffRenderer$OWLObjectItem$.MODULE$));
        return new Tuple2((Object)leftUnique, (Object)rightUnique);
    }

    private void format(Set<String> removedLines, Set<String> addedLines, PrintWriter writer) {
        Seq removedSorted = (Seq)((IterableOnceOps)((IterableOps)removedLines.map((Function1 & Serializable)text -> Util$.MODULE$.replaceNewlines((String)text))).map((Function1 & Serializable)ax -> new StringBuilder(2).append("- ").append((String)ax).toString())).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
        Seq addedSorted = (Seq)((IterableOnceOps)((IterableOps)addedLines.map((Function1 & Serializable)text -> Util$.MODULE$.replaceNewlines((String)text))).map((Function1 & Serializable)ax -> new StringBuilder(2).append("+ ").append((String)ax).toString())).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
        writer.println(new StringBuilder(51).append(removedLines.size()).append(" axioms in left ontology but not in right ontology:").toString());
        removedSorted.foreach((Function1 & Serializable)x$1 -> {
            writer.println(x$1);
            return BoxedUnit.UNIT;
        });
        writer.println();
        writer.println(new StringBuilder(51).append(addedLines.size()).append(" axioms in right ontology but not in left ontology:").toString());
        addedSorted.foreach((Function1 & Serializable)x$1 -> {
            writer.println(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$renderPlainWriter$1(Differ.BasicDiff diff$2, PrintWriter writer) {
        if (diff$2.isEmpty()) {
            writer.println("Ontologies are identical");
            return;
        }
        Tuple2<Set<BasicDiffRenderer.OWLItem<?>>, Set<BasicDiffRenderer.OWLItem<?>>> tuple2 = MODULE$.groups(diff$2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Set left = (Set)tuple2._1();
        Set right = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)left, (Object)right);
        Set left2 = (Set)tuple22._1();
        Set right2 = (Set)tuple22._2();
        Set leftRendered = (Set)left2.map((Function1 & Serializable)x$2 -> x$2.item().toString());
        Set rightRendered = (Set)right2.map((Function1 & Serializable)x$3 -> x$3.item().toString());
        OWLOntologyID oWLOntologyID = diff$2.left().id();
        OWLOntologyID oWLOntologyID2 = diff$2.right().id();
        if (!(oWLOntologyID == null ? oWLOntologyID2 != null : !oWLOntologyID.equals(oWLOntologyID2)) || diff$2.left().id().isAnonymous() && diff$2.right().id().isAnonymous()) {
            MODULE$.format((Set<String>)leftRendered, (Set<String>)rightRendered, writer);
            return;
        }
        MODULE$.format((Set<String>)((Set)leftRendered.$plus((Object)diff$2.left().id().toString())), (Set<String>)((Set)rightRendered.$plus((Object)diff$2.right().id().toString())), writer);
    }

    public static final /* synthetic */ void $anonfun$renderWriter$1(Differ.BasicDiff diff$5, ShortFormProvider shortFormProvider$2, PrintWriter writer) {
        if (diff$5.isEmpty()) {
            writer.println("Ontologies are identical");
            return;
        }
        ShortFormFunctionalSyntaxObjectRenderer renderer = new ShortFormFunctionalSyntaxObjectRenderer(shortFormProvider$2);
        Tuple2<Set<BasicDiffRenderer.OWLItem<?>>, Set<BasicDiffRenderer.OWLItem<?>>> tuple2 = MODULE$.groups(diff$5);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Set left = (Set)tuple2._1();
        Set right = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)left, (Object)right);
        Set left2 = (Set)tuple22._1();
        Set right2 = (Set)tuple22._2();
        Set leftRendered = (Set)left2.map((Function1 & Serializable)x0$1 -> {
            BasicDiffRenderer.OWLItem oWLItem = x0$1;
            if (oWLItem instanceof BasicDiffRenderer.OWLObjectItem) {
                BasicDiffRenderer.OWLObjectItem oWLObjectItem = (BasicDiffRenderer.OWLObjectItem)oWLItem;
                OWLObject item = oWLObjectItem.item();
                return renderer.render(item);
            }
            if (oWLItem instanceof BasicDiffRenderer.OWLImportItem) {
                BasicDiffRenderer.OWLImportItem oWLImportItem = (BasicDiffRenderer.OWLImportItem)oWLItem;
                OWLImportsDeclaration item = oWLImportItem.item();
                return item.toString();
            }
            throw new MatchError((Object)oWLItem);
        });
        Set rightRendered = (Set)right2.map((Function1 & Serializable)x0$2 -> {
            BasicDiffRenderer.OWLItem oWLItem = x0$2;
            if (oWLItem instanceof BasicDiffRenderer.OWLObjectItem) {
                BasicDiffRenderer.OWLObjectItem oWLObjectItem = (BasicDiffRenderer.OWLObjectItem)oWLItem;
                OWLObject item = oWLObjectItem.item();
                return renderer.render(item);
            }
            if (oWLItem instanceof BasicDiffRenderer.OWLImportItem) {
                BasicDiffRenderer.OWLImportItem oWLImportItem = (BasicDiffRenderer.OWLImportItem)oWLItem;
                OWLImportsDeclaration item = oWLImportItem.item();
                return item.toString();
            }
            throw new MatchError((Object)oWLItem);
        });
        OWLOntologyID oWLOntologyID = diff$5.left().id();
        OWLOntologyID oWLOntologyID2 = diff$5.right().id();
        if (!(oWLOntologyID == null ? oWLOntologyID2 != null : !oWLOntologyID.equals(oWLOntologyID2)) || diff$5.left().id().isAnonymous() && diff$5.right().id().isAnonymous()) {
            MODULE$.format((Set<String>)leftRendered, (Set<String>)rightRendered, writer);
            return;
        }
        MODULE$.format((Set<String>)((Set)leftRendered.$plus((Object)diff$5.left().id().toString())), (Set<String>)((Set)rightRendered.$plus((Object)diff$5.right().id().toString())), writer);
    }

    private BasicDiffRenderer$() {
    }
}

