/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.owl.differ.render;

import com.google.common.base.Optional;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.text.StringEscapeUtils;
import org.geneontology.owl.differ.Differ;
import org.geneontology.owl.differ.Differ$GCIGrouping$;
import org.geneontology.owl.differ.Differ$OntologyAnnotationGrouping$;
import org.geneontology.owl.differ.Differ$OntologyImportGrouping$;
import org.geneontology.owl.differ.Differ$RuleGrouping$;
import org.geneontology.owl.differ.ManchesterSyntaxOWLObjectRenderer;
import org.geneontology.owl.differ.Util$;
import org.geneontology.owl.differ.Util$OptionalOption$;
import org.geneontology.owl.differ.shortform.HTMLLinkShortFormProvider;
import org.geneontology.owl.differ.shortform.HTMLSafeIRIShortFormProvider;
import org.geneontology.owl.differ.shortform.HTMLSafeShortFormProvider;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.util.AnnotationValueShortFormProvider;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleIRIShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Using;
import scala.util.Using$;

public final class HTMLDiffRenderer$ {
    public static final HTMLDiffRenderer$ MODULE$ = new HTMLDiffRenderer$();
    private static final OWLDataFactory factory = OWLManager.getOWLDataFactory();
    private static final OWLAnnotationProperty rdfsLabel = MODULE$.factory().getRDFSLabel();

    private OWLDataFactory factory() {
        return factory;
    }

    private OWLAnnotationProperty rdfsLabel() {
        return rdfsLabel;
    }

    public void renderWriter(Differ.GroupedDiff diff, OWLOntologySetProvider renderingOntologyProvider, Writer givenWriter) {
        Using$.MODULE$.resource((Object)new PrintWriter(givenWriter), (Function1 & Serializable)writer -> {
            HTMLDiffRenderer$.$anonfun$renderWriter$1(renderingOntologyProvider, diff, writer);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public void renderStream(Differ.GroupedDiff diff, OWLOntologySetProvider renderingOntologyProvider, OutputStream stream) {
        Using$.MODULE$.resource((Object)new PrintWriter(stream), (Function1 & Serializable)writer -> {
            HTMLDiffRenderer$.MODULE$.renderWriter(diff, renderingOntologyProvider, writer);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public String render(Differ.GroupedDiff diff, OWLOntologySetProvider renderingOntologyProvider) {
        return (String)Using$.MODULE$.resource((Object)new ByteArrayOutputStream(), (Function1 & Serializable)stream -> {
            MODULE$.renderStream(diff, renderingOntologyProvider, (OutputStream)stream);
            return stream.toString(StandardCharsets.UTF_8);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private String optionalIRI(Optional<IRI> iriOpt) {
        return (String)Util$OptionalOption$.MODULE$.toOption$extension(Util$.MODULE$.OptionalOption(iriOpt)).map((Function1 & Serializable)iri -> StringEscapeUtils.escapeHtml4((String)iri.toQuotedString())).getOrElse((Function0 & Serializable)() -> "<i>None</i>");
    }

    private static final String htmlForObject$1(OWLObject obj, ManchesterSyntaxOWLObjectRenderer htmlRenderer$1) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        OWLObject oWLObject = obj;
        if (oWLObject instanceof HasAnnotations) {
            OWLAxiom oWLAxiom;
            OWLObject oWLObject2 = oWLObject;
            String inner = ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(((HasAnnotations)oWLObject2).getAnnotations()).asScala().map((Function1 & Serializable)x$1 -> HTMLDiffRenderer$.htmlForObject$1((OWLObject)x$1, htmlRenderer$1))).mkString("\n");
            OWLObject oWLObject3 = obj;
            if (oWLObject3 instanceof OWLAxiom) {
                OWLAxiom oWLAxiom2 = (OWLAxiom)oWLObject3;
                oWLAxiom = oWLAxiom2.getAxiomWithoutAnnotations();
            } else if (oWLObject3 instanceof OWLAnnotation) {
                OWLAnnotation oWLAnnotation = (OWLAnnotation)oWLObject3;
                oWLAxiom = MODULE$.factory().getOWLAnnotation(oWLAnnotation.getProperty(), oWLAnnotation.getValue());
            } else {
                oWLAxiom = obj;
            }
            OWLAxiom objWithoutAnnotations = oWLAxiom;
            tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(9).append("<ul>").append(inner).append("</ul>").toString()), (Object)objWithoutAnnotations);
        } else {
            tuple22 = tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)obj);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String annotations = (String)tuple2._1();
        OWLObject objToRender = (OWLObject)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)annotations, (Object)objToRender);
        String annotations2 = (String)tuple23._1();
        OWLObject objToRender2 = (OWLObject)tuple23._2();
        return new StringBuilder(38).append("<li><span class=\"axiom\"> ").append(htmlRenderer$1.render(objToRender2)).append(" </span>").append(annotations2).append("</li>").toString();
    }

    private static final String changeList$1(String header, scala.collection.immutable.Seq axioms, ManchesterSyntaxOWLObjectRenderer htmlRenderer$1) {
        return new StringBuilder(83).append("\n      <h4 class=\"status-header\">").append(header).append("</h4>\n        <ul>\n          ").append(((IterableOnceOps)axioms.map((Function1 & Serializable)obj -> HTMLDiffRenderer$.htmlForObject$1(obj, htmlRenderer$1))).mkString("\n")).append("\n        </ul>\n      ").toString();
    }

    private static final String frameElement$1(String header, String headerIRI, String removedList, String addedList) {
        return new StringBuilder(122).append("<div class=\"frame\">\n        <h3>").append(header).append("\n          <span class=\"frame-iri\">").append(headerIRI).append("</span>\n        </h3>\n      ").append(removedList).append("\n      ").append(addedList).append("\n      </div>\n      ").toString();
    }

    private static final String sortKey$1(Differ.ModifiedOntologyContent modifiedItem) {
        Differ.ModifiedOntologyContent modifiedOntologyContent = modifiedItem;
        if (modifiedOntologyContent instanceof Differ.ModifiedOntologyAnnotation) {
            Differ.ModifiedOntologyAnnotation modifiedOntologyAnnotation = (Differ.ModifiedOntologyAnnotation)modifiedOntologyContent;
            OWLAnnotation item = modifiedOntologyAnnotation.item();
            return item.toString();
        }
        if (modifiedOntologyContent instanceof Differ.ModifiedImport) {
            Differ.ModifiedImport modifiedImport = (Differ.ModifiedImport)modifiedOntologyContent;
            OWLImportsDeclaration item = modifiedImport.item();
            return item.toString();
        }
        if (modifiedOntologyContent instanceof Differ.ModifiedAxiom) {
            Differ.ModifiedAxiom modifiedAxiom = (Differ.ModifiedAxiom)modifiedOntologyContent;
            OWLAxiom item = modifiedAxiom.item();
            AxiomType axiomType = item.getAxiomType();
            AxiomType axiomType2 = AxiomType.DECLARATION;
            AxiomType axiomType3 = axiomType;
            if (!(axiomType2 != null ? !axiomType2.equals(axiomType3) : axiomType3 != null)) {
                return new StringBuilder(2).append("1-").append(item.toString()).toString();
            }
            return new StringBuilder(2).append("2-").append(item.toString()).toString();
        }
        throw new MatchError((Object)modifiedOntologyContent);
    }

    public static final /* synthetic */ void $anonfun$renderWriter$5(PrintWriter writer$1, Differ.GroupedDiff diff$1, scala.collection.immutable.Map groupsToLabels$1, ManchesterSyntaxOWLObjectRenderer htmlRenderer$1, Differ.Grouping group) {
        String string;
        writer$1.println();
        scala.collection.immutable.Seq removed = (scala.collection.immutable.Seq)((IterableOnceOps)((IterableOps)diff$1.groups().apply((Object)group)).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.added()))).toSeq().sortBy((Function1 & Serializable)modifiedItem -> HTMLDiffRenderer$.sortKey$1(modifiedItem), (Ordering)Ordering.String$.MODULE$);
        scala.collection.immutable.Seq added = (scala.collection.immutable.Seq)((IterableOnceOps)((IterableOps)diff$1.groups().apply((Object)group)).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.added()))).toSeq().sortBy((Function1 & Serializable)modifiedItem -> HTMLDiffRenderer$.sortKey$1(modifiedItem), (Ordering)Ordering.String$.MODULE$);
        String removedList = removed.nonEmpty() ? HTMLDiffRenderer$.changeList$1("Removed", (scala.collection.immutable.Seq)removed.map((Function1 & Serializable)x$5 -> x$5.owlObject()), htmlRenderer$1) : "";
        String addedList = added.nonEmpty() ? HTMLDiffRenderer$.changeList$1("Added", (scala.collection.immutable.Seq)added.map((Function1 & Serializable)x$6 -> x$6.owlObject()), htmlRenderer$1) : "";
        String header = (String)groupsToLabels$1.apply((Object)group);
        Differ.Grouping grouping = group;
        if (grouping instanceof Differ.IRIGrouping) {
            Differ.IRIGrouping iRIGrouping = (Differ.IRIGrouping)grouping;
            IRI iri = iRIGrouping.term();
            string = new StringBuilder(2).append("- ").append((CharSequence)iri).toString();
        } else {
            string = "";
        }
        String headerIRI = string;
        String frame = HTMLDiffRenderer$.frameElement$1(header, headerIRI, removedList, addedList);
        writer$1.println(frame);
    }

    public static final /* synthetic */ void $anonfun$renderWriter$1(OWLOntologySetProvider renderingOntologyProvider$1, Differ.GroupedDiff diff$1, PrintWriter writer) {
        HTMLSafeShortFormProvider shortFormProvider = new HTMLSafeShortFormProvider((ShortFormProvider)new AnnotationValueShortFormProvider(renderingOntologyProvider$1, (ShortFormProvider)new SimpleShortFormProvider(), (IRIShortFormProvider)new HTMLSafeIRIShortFormProvider((IRIShortFormProvider)new SimpleIRIShortFormProvider()), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)MODULE$.rdfsLabel(), (List)Nil$.MODULE$)).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava()));
        HTMLLinkShortFormProvider htmlLinkShortFormProvider = new HTMLLinkShortFormProvider(shortFormProvider);
        ManchesterSyntaxOWLObjectRenderer labelRenderer = new ManchesterSyntaxOWLObjectRenderer();
        labelRenderer.setShortFormProvider(shortFormProvider);
        ManchesterSyntaxOWLObjectRenderer htmlRenderer = new ManchesterSyntaxOWLObjectRenderer();
        htmlRenderer.setShortFormProvider(htmlLinkShortFormProvider);
        scala.collection.immutable.Map groupsToLabels = ((IterableOnceOps)diff$1.groups().keys().map((Function1 & Serializable)x0$1 -> {
            Differ.Grouping grouping = x0$1;
            if (grouping instanceof Differ.IRIGrouping) {
                Differ.IRIGrouping iRIGrouping = (Differ.IRIGrouping)grouping;
                IRI iri = iRIGrouping.term();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)iRIGrouping), (Object)labelRenderer.render((OWLObject)MODULE$.factory().getOWLClass(iri)));
            }
            if (Differ$GCIGrouping$.MODULE$.equals(grouping)) {
                Differ.Grouping grouping2 = grouping;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)grouping2), (Object)"GCIs");
            }
            if (Differ$RuleGrouping$.MODULE$.equals(grouping)) {
                Differ.Grouping grouping3 = grouping;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)grouping3), (Object)"Rules");
            }
            if (grouping instanceof Differ.NonIRIGrouping) {
                Differ.NonIRIGrouping nonIRIGrouping = (Differ.NonIRIGrouping)grouping;
                OWLObject obj = nonIRIGrouping.obj();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonIRIGrouping), (Object)labelRenderer.render(obj));
            }
            if (Differ$OntologyImportGrouping$.MODULE$.equals(grouping)) {
                Differ.Grouping grouping4 = grouping;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)grouping4), (Object)"Ontology imports");
            }
            if (Differ$OntologyAnnotationGrouping$.MODULE$.equals(grouping)) {
                Differ.Grouping grouping5 = grouping;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)grouping5), (Object)"Ontology annotations");
            }
            throw new MatchError((Object)grouping);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Differ$OntologyImportGrouping$ differ$OntologyImportGrouping$ = Differ$OntologyImportGrouping$.MODULE$;
        Differ$OntologyAnnotationGrouping$ differ$OntologyAnnotationGrouping$ = Differ$OntologyAnnotationGrouping$.MODULE$;
        List sortedGroups = ((List)diff$1.groups().$minus((Object)Differ$OntologyImportGrouping$.MODULE$).$minus((Object)Differ$OntologyAnnotationGrouping$.MODULE$).keys().toList().sortBy((Function1)groupsToLabels, (Ordering)Ordering.String$.MODULE$)).$colon$colon((Object)differ$OntologyAnnotationGrouping$).$colon$colon((Object)differ$OntologyImportGrouping$);
        String header = new StringBuilder(737).append("\n  <!DOCTYPE html>\n  <html>\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n    <style>\n  div.frame {\n      margin-top: 2.5em;\n  }\n  .status-header {\n      font-style: italic;\n      margin-top: 0;\n      margin-bottom: 0;\n  }\n  .frame > ul {\n      margin-top: 0.3em;\n  }\n  h3 {\n      margin-bottom: 0.5em;\n  }\n  .frame-iri {\n      color: gray;\n      font-size: 80%;\n  }\n  </style>\n    <title>OWL diff</title>\n  </head>\n  <body>\n\n  <h2>Ontology comparison</h2>\n  <h3>Left</h3>\n  <ul>\n  <li>Ontology IRI: ").append(MODULE$.optionalIRI((Optional<IRI>)diff$1.left().getOntologyIRI())).append("</li>\n  <li>Version IRI: ").append(MODULE$.optionalIRI((Optional<IRI>)diff$1.left().getVersionIRI())).append("</li>\n  <li>Loaded from: ").append(StringEscapeUtils.escapeHtml4((String)diff$1.leftSource().toQuotedString())).append("</li>\n  </ul>\n  <h3>Right</h3>\n  <ul>\n  <li>Ontology IRI: ").append(MODULE$.optionalIRI((Optional<IRI>)diff$1.right().getOntologyIRI())).append("</li>\n  <li>Version IRI: ").append(MODULE$.optionalIRI((Optional<IRI>)diff$1.right().getVersionIRI())).append("</li>\n  <li>Loaded from: ").append(StringEscapeUtils.escapeHtml4((String)diff$1.rightSource().toQuotedString())).append("</li>\n  </ul>\n  ").toString();
        writer.println(header);
        sortedGroups.map((Function1 & Serializable)group -> {
            HTMLDiffRenderer$.$anonfun$renderWriter$5(writer, diff$1, groupsToLabels, htmlRenderer, group);
            return BoxedUnit.UNIT;
        });
        writer.println("</body>");
    }

    private HTMLDiffRenderer$() {
    }
}

