/*
 * Decompiled with CFR 0.152.
 */
package org.renci.relationgraph;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.geneontology.whelk.AtomicConcept;
import org.geneontology.whelk.AtomicConcept$;
import org.geneontology.whelk.Bridge$;
import org.geneontology.whelk.BuiltIn$;
import org.geneontology.whelk.Concept;
import org.geneontology.whelk.ConceptInclusion;
import org.geneontology.whelk.ExistentialRestriction;
import org.geneontology.whelk.Individual;
import org.geneontology.whelk.Nominal;
import org.geneontology.whelk.Reasoner$;
import org.geneontology.whelk.ReasonerState;
import org.geneontology.whelk.Role;
import org.geneontology.whelk.Role$;
import org.renci.relationgraph.RelationGraph;
import org.renci.relationgraph.RelationGraph$Config$OWLMode$;
import org.renci.relationgraph.RelationGraph$Config$RDFMode$;
import org.semanticweb.owlapi.apibinding.OWLFunctionalSyntaxFactory;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import zio.CanFail$;
import zio.Chunk;
import zio.Queue;
import zio.Queue$;
import zio.Ref;
import zio.Ref$;
import zio.ZIO;
import zio.ZIO$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class RelationGraph$
implements StrictLogging {
    public static final RelationGraph$ MODULE$ = new RelationGraph$();
    private static final Node org$renci$relationgraph$RelationGraph$$RDFType;
    private static final Node RDFSSubClassOf;
    private static final Node OWLEquivalentClass;
    private static final Node OWLRestriction;
    private static final Node OWLOnProperty;
    private static final Node OWLSomeValuesFrom;
    private static final Node OWLOntology;
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
        JenaSystem.init();
        org$renci$relationgraph$RelationGraph$$RDFType = RDF.type.asNode();
        RDFSSubClassOf = RDFS.subClassOf.asNode();
        OWLEquivalentClass = OWL2.equivalentClass.asNode();
        OWLRestriction = OWL2.Restriction.asNode();
        OWLOnProperty = OWL2.onProperty.asNode();
        OWLSomeValuesFrom = OWL2.someValuesFrom.asNode();
        OWLOntology = OWL2.Ontology.asNode();
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public Node org$renci$relationgraph$RelationGraph$$RDFType() {
        return org$renci$relationgraph$RelationGraph$$RDFType;
    }

    private Node RDFSSubClassOf() {
        return RDFSSubClassOf;
    }

    private Node OWLEquivalentClass() {
        return OWLEquivalentClass;
    }

    private Node OWLRestriction() {
        return OWLRestriction;
    }

    private Node OWLOnProperty() {
        return OWLOnProperty;
    }

    private Node OWLSomeValuesFrom() {
        return OWLSomeValuesFrom;
    }

    private Node OWLOntology() {
        return OWLOntology;
    }

    public ZStream<Object, Nothing$, RelationGraph.TriplesGroup> computeRelations(OWLOntology ontology, Set<AtomicConcept> specifiedProperties, RelationGraph.Config outputConfig) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Set whelkOntology = Bridge$.MODULE$.ontologyToAxioms(ontology);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Running reasoner");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Set x$1 = whelkOntology;
        boolean x$2 = outputConfig.disableOwlNothing();
        Map x$3 = Reasoner$.MODULE$.assert$default$2();
        ReasonerState whelk = Reasoner$.MODULE$.assert(x$1, x$3, x$2);
        RelationGraph.IndexedReasonerState indexedWhelk = new RelationGraph.IndexedReasonerState(whelk);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Done running reasoner");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RelationGraph.Hierarchy classes = this.classHierarchy(indexedWhelk.state());
        RelationGraph.Hierarchy properties = this.propertyHierarchy(ontology, specifiedProperties);
        Set allProperties = (Set)properties.subclasses().keySet().map((Function1 & Serializable)c -> Role$.MODULE$.apply(c.id()));
        ZStream ontologyDeclarationStream = ZStream$.MODULE$.succeed((Function0 & Serializable)() -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> new RelationGraph.TriplesGroup((Set<Triple>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Triple[]{Triple.create((Node)NodeFactory.createBlankNode((String)"redundant"), (Node)MODULE$.org$renci$relationgraph$RelationGraph$$RDFType(), (Node)MODULE$.OWLOntology())})))), (Object)"org.renci.relationgraph.RelationGraph.computeRelations.ontologyDeclarationStream(RelationGraph.scala:63)"), (Object)"org.renci.relationgraph.RelationGraph.computeRelations.ontologyDeclarationStream(RelationGraph.scala:63)").when((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            RelationGraph.Config.TriplesMode triplesMode = outputConfig.mode();
            RelationGraph$Config$OWLMode$ relationGraph$Config$OWLMode$ = RelationGraph$Config$OWLMode$.MODULE$;
            return !(triplesMode != null ? !triplesMode.equals(relationGraph$Config$OWLMode$) : relationGraph$Config$OWLMode$ != null);
        }, (Object)"org.renci.relationgraph.RelationGraph.computeRelations.ontologyDeclarationStream(RelationGraph.scala:64)");
        ZStream classesTasks = outputConfig.outputSubclasses() ? this.allClasses(ontology).map((Function1 & Serializable)c -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> MODULE$.processSubclasses((OWLClass)c, indexedWhelk.state(), outputConfig.reflexiveSubclasses(), outputConfig.equivalenceAsSubclass(), outputConfig.outputClasses(), outputConfig.outputIndividuals()), (Object)"org.renci.relationgraph.RelationGraph.computeRelations.classesTasks(RelationGraph.scala:66)"), (Object)"org.renci.relationgraph.RelationGraph.computeRelations.classesTasks(RelationGraph.scala:66)") : ZStream$.MODULE$.empty((Object)"org.renci.relationgraph.RelationGraph.computeRelations.classesTasks(RelationGraph.scala:67)");
        ZIO streamZ = Queue$.MODULE$.unbounded((Object)"org.renci.relationgraph.RelationGraph.computeRelations.streamZ(RelationGraph.scala:69)").flatMap((Function1 & Serializable)queue -> Ref$.MODULE$.make((Function0)(JFunction0.mcI.sp & Serializable)() -> 0, (Object)"org.renci.relationgraph.RelationGraph.computeRelations.streamZ(RelationGraph.scala:70)").flatMap((Function1 & Serializable)activeRestrictions -> ZIO$.MODULE$.foreach(allProperties, (Function1 & Serializable)p -> Ref$.MODULE$.make((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty(), (Object)"org.renci.relationgraph.RelationGraph.computeRelations.streamZ(RelationGraph.scala:71)").map((Function1 & Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), x$1), (Object)"org.renci.relationgraph.RelationGraph.computeRelations.streamZ(RelationGraph.scala:71)"), (Object)"org.renci.relationgraph.RelationGraph.computeRelations.streamZ(RelationGraph.scala:71)").map((Function1 & Serializable)x$2 -> x$2.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"org.renci.relationgraph.RelationGraph.computeRelations.streamZ(RelationGraph.scala:71)").flatMap((Function1 & Serializable)seenRefs -> MODULE$.traverse(specifiedProperties, properties, classes, (Queue<RelationGraph.Restriction>)queue, (Ref<Object>)activeRestrictions, (Map<Role, Ref<Set<AtomicConcept>>>)seenRefs).map((Function1 & Serializable)x$3 -> {
            ZStream restrictionsStream = ZStream$.MODULE$.fromQueue((Function0 & Serializable)() -> queue, (Function0)(JFunction0.mcI.sp & Serializable)() -> ZStream$.MODULE$.fromQueue$default$2(), (Object)"org.renci.relationgraph.RelationGraph.computeRelations.streamZ.restrictionsStream(RelationGraph.scala:73)").map((Function1 & Serializable)r -> MODULE$.processRestrictionAndExtendQueue((RelationGraph.Restriction)r, properties, classes, indexedWhelk, outputConfig.mode(), specifiedProperties.isEmpty(), outputConfig.outputClasses(), outputConfig.outputIndividuals(), (Queue<RelationGraph.Restriction>)queue, (Ref<Object>)activeRestrictions, (Map<Role, Ref<Set<AtomicConcept>>>)seenRefs), (Object)"org.renci.relationgraph.RelationGraph.computeRelations.streamZ.restrictionsStream(RelationGraph.scala:73)");
            ZStream allTasks = ontologyDeclarationStream.$plus$plus((Function0 & Serializable)() -> classesTasks, (Object)"org.renci.relationgraph.RelationGraph.computeRelations.streamZ.allTasks(RelationGraph.scala:74)").$plus$plus((Function0 & Serializable)() -> restrictionsStream, (Object)"org.renci.relationgraph.RelationGraph.computeRelations.streamZ.allTasks(RelationGraph.scala:74)");
            return new Tuple3(x$3, (Object)restrictionsStream, (Object)allTasks);
        }, (Object)"org.renci.relationgraph.RelationGraph.computeRelations.streamZ(RelationGraph.scala:72)").map((Function1 & Serializable)x$4 -> {
            Tuple3 tuple3 = x$4;
            if (tuple3 != null) {
                ZStream allTasks = (ZStream)tuple3._3();
                return allTasks.mapZIOParUnordered((Function0)(JFunction0.mcI.sp & Serializable)() -> Runtime.getRuntime().availableProcessors(), (Function1 & Serializable)x -> (ZIO)Predef$.MODULE$.identity(x), (Object)"org.renci.relationgraph.RelationGraph.computeRelations.streamZ(RelationGraph.scala:75)");
            }
            throw new MatchError((Object)tuple3);
        }, (Object)"org.renci.relationgraph.RelationGraph.computeRelations.streamZ(RelationGraph.scala:72)"), (Object)"org.renci.relationgraph.RelationGraph.computeRelations.streamZ(RelationGraph.scala:71)"), (Object)"org.renci.relationgraph.RelationGraph.computeRelations.streamZ(RelationGraph.scala:70)"), (Object)"org.renci.relationgraph.RelationGraph.computeRelations.streamZ(RelationGraph.scala:69)");
        return ZStream$.MODULE$.unwrap((Function0 & Serializable)() -> streamZ, (Object)"org.renci.relationgraph.RelationGraph.computeRelations(RelationGraph.scala:76)");
    }

    public ZStream<Object, Nothing$, OWLClass> allClasses(OWLOntology ont) {
        return ZStream$.MODULE$.fromIterable((Function0 & Serializable)() -> (Set)((SetOps)CollectionConverters$.MODULE$.SetHasAsScala(ont.getClassesInSignature(Imports.INCLUDED)).asScala().to(IterableFactory$.MODULE$.toFactory((IterableFactory)Predef$.MODULE$.Set()))).$minus((Object)OWLFunctionalSyntaxFactory.OWLThing()).$minus((Object)OWLFunctionalSyntaxFactory.OWLNothing()), (Object)"org.renci.relationgraph.RelationGraph.allClasses(RelationGraph.scala:79)");
    }

    public ZIO<Object, Nothing$, BoxedUnit> traverse(Set<AtomicConcept> specifiedProperties, RelationGraph.Hierarchy properties, RelationGraph.Hierarchy classes, Queue<RelationGraph.Restriction> queue, Ref<Object> activeRestrictions, Map<Role, Ref<Set<AtomicConcept>>> seenRefs) {
        Set queryProperties;
        boolean descendProperties = specifiedProperties.isEmpty();
        Set set = queryProperties = descendProperties ? (Set)((SetOps)properties.subclasses().getOrElse((Object)BuiltIn$.MODULE$.Top(), (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())).$minus((Object)BuiltIn$.MODULE$.Bottom()) : specifiedProperties;
        if (queryProperties.nonEmpty()) {
            return ZIO$.MODULE$.foreachParDiscard((Function0 & Serializable)() -> queryProperties, (Function1 & Serializable)subprop -> MODULE$.traverseProperty((AtomicConcept)subprop, classes, queue, activeRestrictions, seenRefs), (Object)"org.renci.relationgraph.RelationGraph.traverse(RelationGraph.scala:84)");
        }
        return queue.shutdown((Object)"org.renci.relationgraph.RelationGraph.traverse(RelationGraph.scala:87)");
    }

    public ZIO<Object, Nothing$, BoxedUnit> traverseProperty(AtomicConcept property, RelationGraph.Hierarchy classes, Queue<RelationGraph.Restriction> queue, Ref<Object> activeRestrictions, Map<Role, Ref<Set<AtomicConcept>>> seenRefs) {
        Set restrictions = (Set)((SetOps)classes.subclasses().getOrElse((Object)BuiltIn$.MODULE$.Top(), (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())).$minus((Object)BuiltIn$.MODULE$.Bottom()).map((Function1 & Serializable)filler -> new RelationGraph.Restriction(Role$.MODULE$.apply(property.id()), (AtomicConcept)filler));
        Ref propSeenRef = (Ref)seenRefs.apply((Object)Role$.MODULE$.apply(property.id()));
        return propSeenRef.update((Function1 & Serializable)seenForThisProperty -> (Set)seenForThisProperty.$plus$plus((IterableOnce)restrictions.map((Function1 & Serializable)x$5 -> x$5.filler())), (Object)"org.renci.relationgraph.RelationGraph.traverseProperty(RelationGraph.scala:94)").flatMap((Function1 & Serializable)x$9 -> {
            BoxedUnit boxedUnit = x$9;
            return activeRestrictions.update((Function1)(JFunction1.mcII.sp & Serializable)current -> current + restrictions.size(), (Object)"org.renci.relationgraph.RelationGraph.traverseProperty(RelationGraph.scala:97)").flatMap((Function1 & Serializable)x$8 -> {
                BoxedUnit boxedUnit = x$8;
                return queue.offerAll((Iterable)restrictions, (Object)"org.renci.relationgraph.RelationGraph.traverseProperty(RelationGraph.scala:98)").unit((Object)"org.renci.relationgraph.RelationGraph.traverseProperty(RelationGraph.scala:98)").flatMap((Function1 & Serializable)x$7 -> {
                    BoxedUnit boxedUnit = x$7;
                    return activeRestrictions.get((Object)"org.renci.relationgraph.RelationGraph.traverseProperty(RelationGraph.scala:99)").flatMap((Function1 & Serializable)active -> RelationGraph$.$anonfun$traverseProperty$9(queue, BoxesRunTime.unboxToInt((Object)active)), (Object)"org.renci.relationgraph.RelationGraph.traverseProperty(RelationGraph.scala:99)");
                }, (Object)"org.renci.relationgraph.RelationGraph.traverseProperty(RelationGraph.scala:98)");
            }, (Object)"org.renci.relationgraph.RelationGraph.traverseProperty(RelationGraph.scala:97)");
        }, (Object)"org.renci.relationgraph.RelationGraph.traverseProperty(RelationGraph.scala:94)");
    }

    public ZIO<Object, Nothing$, RelationGraph.TriplesGroup> processRestrictionAndExtendQueue(RelationGraph.Restriction restriction, RelationGraph.Hierarchy properties, RelationGraph.Hierarchy classes, RelationGraph.IndexedReasonerState whelk, RelationGraph.Config.TriplesMode mode, boolean descendProperties, boolean outputClasses, boolean outputIndividuals, Queue<RelationGraph.Restriction> queue, Ref<Object> activeRestrictions, Map<Role, Ref<Set<AtomicConcept>>> seenRefs) {
        RelationGraph.TriplesGroup triples = this.processRestriction(restriction, whelk, mode, outputClasses, outputIndividuals);
        boolean bl = triples.redundant().nonEmpty();
        return ZIO$.MODULE$.fromOption((Function0 & Serializable)() -> seenRefs.get((Object)restriction.property()), (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:108)").orDieWith((Function1 & Serializable)x$10 -> new Exception("A property was encountered that was not in the seen map. This should never happen."), CanFail$.MODULE$.canFail(), (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:108)").flatMap((Function1 & Serializable)propSeenRef -> (bl ? propSeenRef.modify((Function1 & Serializable)seenForThisProperty -> {
            Set subClasses = (Set)((SetOps)classes.subclasses().getOrElse((Object)restriction.filler(), (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())).$minus((Object)BuiltIn$.MODULE$.Bottom());
            Set unseenSubClasses = (Set)subClasses.$minus$minus((IterableOnce)seenForThisProperty);
            Set updatedSeenForThisProperty = (Set)seenForThisProperty.$plus$plus((IterableOnce)subClasses);
            Set newRestrictions = (Set)unseenSubClasses.map((Function1 & Serializable)c -> new RelationGraph.Restriction(restriction.property(), (AtomicConcept)c));
            return new Tuple2((Object)newRestrictions, (Object)updatedSeenForThisProperty);
        }, (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:109)") : ZIO$.MODULE$.succeed((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty(), (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:115)")).flatMap((Function1 & Serializable)directFillerSubclassesRestrictions -> {
            ZIO zIO;
            if (bl && descendProperties) {
                AtomicConcept propertyConcept = AtomicConcept$.MODULE$.apply(restriction.property().id());
                Set subProperties = (Set)((SetOps)properties.subclasses().getOrElse((Object)propertyConcept, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())).$minus((Object)BuiltIn$.MODULE$.Bottom());
                zIO = ZIO$.MODULE$.foreach(subProperties, (Function1 & Serializable)subProperty -> {
                    Ref subPropSeenRef = (Ref)seenRefs.apply((Object)Role$.MODULE$.apply(subProperty.id()));
                    return subPropSeenRef.modify((Function1 & Serializable)seenClassesForSubProperty -> {
                        Set maybeRestriction = !seenClassesForSubProperty.apply((Object)restriction.filler()) ? (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RelationGraph.Restriction[]{new RelationGraph.Restriction(Role$.MODULE$.apply(subProperty.id()), restriction.filler())})) : Predef$.MODULE$.Set().empty();
                        return new Tuple2((Object)maybeRestriction, (Object)seenClassesForSubProperty.$plus((Object)restriction.filler()));
                    }, (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:121)");
                }, (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:119)").map((Function1 & Serializable)x$11 -> (Set)x$11.flatten(Predef$.MODULE$.$conforms()), (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:127)");
            } else {
                zIO = ZIO$.MODULE$.succeed((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty(), (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:128)");
            }
            return zIO.map((Function1 & Serializable)directSubPropertyRestrictions -> {
                Set newRestrictions = (Set)directFillerSubclassesRestrictions.$plus$plus((IterableOnce)directSubPropertyRestrictions);
                return new Tuple2(directSubPropertyRestrictions, (Object)newRestrictions);
            }, (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:116)").flatMap((Function1 & Serializable)x$15 -> {
                Tuple2 tuple2 = x$15;
                if (tuple2 != null) {
                    Set newRestrictions = (Set)tuple2._2();
                    return activeRestrictions.update((Function1)(JFunction1.mcII.sp & Serializable)current -> current - 1 + newRestrictions.size(), (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:130)").flatMap((Function1 & Serializable)x$14 -> {
                        BoxedUnit boxedUnit = x$14;
                        return queue.offerAll((Iterable)newRestrictions, (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:131)").flatMap((Function1 & Serializable)x$13 -> {
                            Chunk chunk = x$13;
                            return activeRestrictions.get((Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:132)").flatMap((Function1 & Serializable)active -> RelationGraph$.$anonfun$processRestrictionAndExtendQueue$19(queue, triples, BoxesRunTime.unboxToInt((Object)active)), (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:132)");
                        }, (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:131)");
                    }, (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:130)");
                }
                throw new MatchError((Object)tuple2);
            }, (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:116)");
        }, (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:109)"), (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:108)");
    }

    public RelationGraph.TriplesGroup processRestriction(RelationGraph.Restriction restriction, RelationGraph.IndexedReasonerState whelk, RelationGraph.Config.TriplesMode mode, boolean outputClasses, boolean outputIndividuals) {
        Set<Concept> subConcepts = this.queryExistentialSubclasses(restriction, whelk);
        Set subclasses = outputClasses ? (Set)subConcepts.$minus((Object)BuiltIn$.MODULE$.Bottom()).collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Concept, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AtomicConcept) {
                    AtomicConcept atomicConcept = (AtomicConcept)A1;
                    String id = atomicConcept.id();
                    return (B1)id;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Concept x1) {
                Concept concept = x1;
                return concept instanceof AtomicConcept;
            }
        }) : Predef$.MODULE$.Set().empty();
        Set instances = outputIndividuals ? (Set)subConcepts.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Concept, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Nominal nominal;
                Individual individual;
                A1 A1 = x2;
                if (A1 instanceof Nominal && (individual = (nominal = (Nominal)A1).individual()) != null) {
                    String id = individual.id();
                    return (B1)id;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Concept x2) {
                Nominal nominal;
                Individual individual;
                Concept concept = x2;
                return concept instanceof Nominal && (individual = (nominal = (Nominal)concept).individual()) != null;
            }
        }) : Predef$.MODULE$.Set().empty();
        Node predicate = NodeFactory.createURI((String)restriction.property().id());
        Node target = NodeFactory.createURI((String)restriction.filler().id());
        Set subclassTriples = (Set)subclasses.flatMap((Function1 & Serializable)id -> {
            RelationGraph.Config.TriplesMode triplesMode = mode;
            if (RelationGraph$Config$RDFMode$.MODULE$.equals(triplesMode)) {
                return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Triple[]{Triple.create((Node)NodeFactory.createURI((String)id), (Node)predicate, (Node)target)}));
            }
            if (RelationGraph$Config$OWLMode$.MODULE$.equals(triplesMode)) {
                return MODULE$.owlTriples(NodeFactory.createURI((String)id), predicate, target, MODULE$.RDFSSubClassOf());
            }
            throw new MatchError((Object)triplesMode);
        });
        Set instanceTriples = (Set)instances.flatMap((Function1 & Serializable)id -> {
            RelationGraph.Config.TriplesMode triplesMode = mode;
            if (RelationGraph$Config$RDFMode$.MODULE$.equals(triplesMode)) {
                return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Triple[]{Triple.create((Node)NodeFactory.createURI((String)id), (Node)predicate, (Node)target)}));
            }
            if (RelationGraph$Config$OWLMode$.MODULE$.equals(triplesMode)) {
                return MODULE$.owlTriples(NodeFactory.createURI((String)id), predicate, target, MODULE$.org$renci$relationgraph$RelationGraph$$RDFType());
            }
            throw new MatchError((Object)triplesMode);
        });
        Set outputTriples = (Set)subclassTriples.$plus$plus((IterableOnce)instanceTriples);
        return new RelationGraph.TriplesGroup((Set<Triple>)outputTriples);
    }

    public Set<Concept> queryExistentialSubclasses(RelationGraph.Restriction restriction, RelationGraph.IndexedReasonerState whelk) {
        ExistentialRestriction er = new ExistentialRestriction(restriction.property(), (Concept)restriction.filler());
        Set rs = (Set)whelk.reverseRoleHierarchy().getOrElse((Object)er.role(), (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
        Set cs = (Set)whelk.state().closureSubsBySuperclass().getOrElse((Object)er.concept(), (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
        Set validTargets = (Set)cs.intersect(whelk.allTargets());
        return (Set)((IterableOnceOps)((IterableOps)validTargets.flatMap((Function1 & Serializable)target -> (scala.collection.immutable.Iterable)((IterableOps)whelk.linksByTargetList().getOrElse(target, (Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)RelationGraph$.$anonfun$queryExistentialSubclasses$5(check$ifrefutable$1))).withFilter((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)RelationGraph$.$anonfun$queryExistentialSubclasses$6(rs, x$16))).map((Function1 & Serializable)x$17 -> {
            Tuple2 tuple2 = x$17;
            if (tuple2 != null) {
                List es = (List)tuple2._2();
                return es.iterator();
            }
            throw new MatchError((Object)tuple2);
        }))).flatten(Predef$.MODULE$.$conforms())).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Predef$.MODULE$.Set()));
    }

    public RelationGraph.Hierarchy classHierarchy(ReasonerState reasoner) {
        Map taxonomy = reasoner.computeTaxonomy();
        Map subclassTaxonomy = (Map)taxonomy.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Map accum = (Map)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    AtomicConcept concept = (AtomicConcept)tuple22._1();
                    Tuple2 tuple23 = (Tuple2)tuple22._2();
                    if (tuple23 != null) {
                        Set superclasses = (Set)tuple23._2();
                        return (Map)superclasses.foldLeft((Object)accum, (Function2 & Serializable)(x0$2, x1$2) -> {
                            Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
                            if (tuple2 != null) {
                                Map inner = (Map)tuple2._1();
                                AtomicConcept superclass = (AtomicConcept)tuple2._2();
                                Set updatedSubclasses = (Set)((SetOps)accum.getOrElse((Object)superclass, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())).$plus((Object)concept);
                                return (Map)inner.updated((Object)superclass, (Object)updatedSubclasses);
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        Map equivMap = (Map)taxonomy.map((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                AtomicConcept concept = (AtomicConcept)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Set equivs = (Set)tuple22._1();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)concept), (Object)equivs);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return new RelationGraph.Hierarchy((Map<AtomicConcept, Set<AtomicConcept>>)equivMap, (Map<AtomicConcept, Set<AtomicConcept>>)subclassTaxonomy);
    }

    public RelationGraph.Hierarchy propertyHierarchy(OWLOntology ont, Set<AtomicConcept> requestedProperties) {
        Set subPropAxioms = (Set)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(ont.getAxioms(AxiomType.SUB_OBJECT_PROPERTY)).asScala().to(IterableFactory$.MODULE$.toFactory((IterableFactory)Predef$.MODULE$.Set()))).collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends OWLSubObjectPropertyOfAxiom, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.getSubProperty().isNamed() && A1.getSuperProperty().isNamed() && !A1.getSuperProperty().isOWLTopObjectProperty()) {
                    return (B1)new ConceptInclusion((Concept)AtomicConcept$.MODULE$.apply(((OWLObjectPropertyExpression)A1.getSubProperty()).asOWLObjectProperty().getIRI().toString()), (Concept)AtomicConcept$.MODULE$.apply(((OWLObjectPropertyExpression)A1.getSuperProperty()).asOWLObjectProperty().getIRI().toString()));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(OWLSubObjectPropertyOfAxiom x1) {
                OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom = x1;
                return oWLSubObjectPropertyOfAxiom.getSubProperty().isNamed() && oWLSubObjectPropertyOfAxiom.getSuperProperty().isNamed() && !oWLSubObjectPropertyOfAxiom.getSuperProperty().isOWLTopObjectProperty();
            }
        });
        Set allProps = (Set)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(ont.getObjectPropertiesInSignature(Imports.INCLUDED)).asScala().to(IterableFactory$.MODULE$.toFactory((IterableFactory)Predef$.MODULE$.Set()))).filterNot((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isOWLTopObjectProperty()))).map((Function1 & Serializable)prop -> new ConceptInclusion((Concept)AtomicConcept$.MODULE$.apply(prop.getIRI().toString()), (Concept)AtomicConcept$.MODULE$.apply(prop.getIRI().toString())));
        Set requestedProps = (Set)((IterableOps)requestedProperties.filterNot((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)RelationGraph$.$anonfun$propertyHierarchy$3(x$19)))).map((Function1 & Serializable)prop -> new ConceptInclusion((Concept)prop, (Concept)prop));
        Set allAxioms = subPropAxioms.$plus$plus((IterableOnce)allProps).$plus$plus((IterableOnce)requestedProps).toSet();
        ReasonerState whelk = Reasoner$.MODULE$.assert(allAxioms, Reasoner$.MODULE$.assert$default$2(), Reasoner$.MODULE$.assert$default$3());
        return this.classHierarchy(whelk);
    }

    public RelationGraph.TriplesGroup processSubclasses(OWLClass cls, ReasonerState whelk, boolean reflexiveSubclasses, boolean equivalenceAsSubclass, boolean outputClasses, boolean outputIndividuals) {
        Set set;
        Set individualsTriples;
        Node obj = NodeFactory.createURI((String)cls.getIRI().toString());
        AtomicConcept concept = AtomicConcept$.MODULE$.apply(cls.getIRI().toString());
        Set subConcepts = (Set)((SetOps)whelk.closureSubsBySuperclass().getOrElse((Object)concept, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())).$minus((Object)BuiltIn$.MODULE$.Bottom());
        Set set2 = individualsTriples = outputIndividuals ? (Set)subConcepts.collect((PartialFunction)new Serializable(obj){
            private static final long serialVersionUID = 0L;
            private final Node obj$1;

            public final <A1 extends Concept, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Nominal nominal;
                Individual individual;
                A1 A1 = x1;
                if (A1 instanceof Nominal && (individual = (nominal = (Nominal)A1).individual()) != null) {
                    String id = individual.id();
                    return (B1)Triple.create((Node)NodeFactory.createURI((String)id), (Node)RelationGraph$.MODULE$.org$renci$relationgraph$RelationGraph$$RDFType(), (Node)this.obj$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Concept x1) {
                Nominal nominal;
                Individual individual;
                Concept concept = x1;
                return concept instanceof Nominal && (individual = (nominal = (Nominal)concept).individual()) != null;
            }
            {
                this.obj$1 = obj$1;
            }
        }) : Predef$.MODULE$.Set().empty();
        if (outputClasses) {
            Set allSubclasses = (Set)subConcepts.collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Concept, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof AtomicConcept) {
                        AtomicConcept atomicConcept = (AtomicConcept)A1;
                        return (B1)atomicConcept;
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Concept x2) {
                    Concept concept = x2;
                    return concept instanceof AtomicConcept;
                }
            });
            Tuple2 tuple2 = whelk.directlySubsumedBy((Concept)concept);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Set equivs = (Set)tuple2._1();
            Set equivs2 = equivs;
            boolean unsatisfiable = equivs2.apply((Object)BuiltIn$.MODULE$.Bottom());
            if (unsatisfiable) {
                set = Predef$.MODULE$.Set().empty();
            } else {
                Set adjustedSubclasses;
                Set adjustedEquivs = reflexiveSubclasses ? (Set)equivs2.$plus((Object)concept) : (Set)equivs2.$minus((Object)concept);
                Set equivalentClassTriples = equivalenceAsSubclass ? (Set)adjustedEquivs.map((Function1 & Serializable)c -> Triple.create((Node)NodeFactory.createURI((String)c.id()), (Node)MODULE$.RDFSSubClassOf(), (Node)obj)) : (Set)adjustedEquivs.map((Function1 & Serializable)c -> Triple.create((Node)NodeFactory.createURI((String)c.id()), (Node)MODULE$.OWLEquivalentClass(), (Node)obj));
                Set set3 = adjustedSubclasses = reflexiveSubclasses ? (Set)allSubclasses.$plus((Object)concept) : (Set)allSubclasses.$minus((Object)concept);
                if (equivalenceAsSubclass) {
                    set = (Set)adjustedSubclasses.map((Function1 & Serializable)c -> Triple.create((Node)NodeFactory.createURI((String)c.id()), (Node)MODULE$.RDFSSubClassOf(), (Node)obj));
                } else {
                    Set subclassesMinusEquiv = (Set)adjustedSubclasses.$minus$minus((IterableOnce)adjustedEquivs);
                    set = (Set)((scala.collection.SetOps)subclassesMinusEquiv.map((Function1 & Serializable)c -> Triple.create((Node)NodeFactory.createURI((String)c.id()), (Node)MODULE$.RDFSSubClassOf(), (Node)obj))).$plus$plus((IterableOnce)equivalentClassTriples);
                }
            }
        } else {
            set = Predef$.MODULE$.Set().empty();
        }
        Set classesTriples = set;
        Set outputTriples = (Set)classesTriples.$plus$plus((IterableOnce)individualsTriples);
        return new RelationGraph.TriplesGroup((Set<Triple>)outputTriples);
    }

    public Set<Triple> owlTriples(Node subj, Node pred, Node obj, Node relation) {
        byte[] hash = MessageDigest.getInstance("SHA-256").digest(new StringBuilder(0).append(subj).append(pred).append(obj).toString().getBytes(StandardCharsets.UTF_8));
        String id = Base64.getEncoder().encodeToString(hash);
        Node restrictionNode = NodeFactory.createBlankNode((String)id);
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Triple[]{Triple.create((Node)subj, (Node)relation, (Node)restrictionNode), Triple.create((Node)restrictionNode, (Node)this.org$renci$relationgraph$RelationGraph$$RDFType(), (Node)this.OWLRestriction()), Triple.create((Node)restrictionNode, (Node)this.OWLOnProperty(), (Node)pred), Triple.create((Node)restrictionNode, (Node)this.OWLSomeValuesFrom(), (Node)obj)}));
    }

    private boolean isIncoherent(ReasonerState state) {
        return ((IterableOnceOps)state.closureSubsBySuperclass().apply((Object)BuiltIn$.MODULE$.Bottom())).exists((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)RelationGraph$.$anonfun$isIncoherent$1(t)));
    }

    public static final /* synthetic */ ZIO $anonfun$traverseProperty$9(Queue queue$3, int active) {
        return queue$3.shutdown((Object)"org.renci.relationgraph.RelationGraph.traverseProperty(RelationGraph.scala:100)").when((Function0)(JFunction0.mcZ.sp & Serializable)() -> active < 1, (Object)"org.renci.relationgraph.RelationGraph.traverseProperty(RelationGraph.scala:100)").map((Function1 & Serializable)x$6 -> {
            option = x$6;
            return BoxedUnit.UNIT;
        }, (Object)"org.renci.relationgraph.RelationGraph.traverseProperty(RelationGraph.scala:100)");
    }

    public static final /* synthetic */ ZIO $anonfun$processRestrictionAndExtendQueue$19(Queue queue$4, RelationGraph.TriplesGroup triples$1, int active) {
        return queue$4.shutdown((Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:133)").when((Function0)(JFunction0.mcZ.sp & Serializable)() -> active < 1, (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:133)").map((Function1 & Serializable)x$12 -> {
            Option option = x$12;
            return triples$1;
        }, (Object)"org.renci.relationgraph.RelationGraph.processRestrictionAndExtendQueue(RelationGraph.scala:133)");
    }

    public static final /* synthetic */ boolean $anonfun$queryExistentialSubclasses$5(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$queryExistentialSubclasses$6(Set rs$1, Tuple2 x$16) {
        Tuple2 tuple2 = x$16;
        if (tuple2 != null) {
            Role r = (Role)tuple2._1();
            return rs$1.apply((Object)r);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$propertyHierarchy$3(AtomicConcept x$19) {
        AtomicConcept atomicConcept = x$19;
        AtomicConcept atomicConcept2 = BuiltIn$.MODULE$.Top();
        return !(atomicConcept != null ? !atomicConcept.equals(atomicConcept2) : atomicConcept2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isIncoherent$1(Concept t) {
        if (t.isAnonymous()) return false;
        Concept concept = t;
        AtomicConcept atomicConcept = BuiltIn$.MODULE$.Bottom();
        if (concept == null) {
            if (atomicConcept == null) return false;
            return true;
        } else if (concept.equals(atomicConcept)) return false;
        return true;
    }

    private RelationGraph$() {
    }
}

