package org.geneontology.whelk.owlapi

import org.geneontology.whelk.BuiltIn.Bottom
import org.geneontology.whelk._
import org.semanticweb.owlapi.apibinding.OWLManager
import org.semanticweb.owlapi.model.IRI

import java.io.File
import java.util.UUID
import java.util.concurrent.TimeUnit
import java.util.concurrent.atomic.AtomicLong
import scala.jdk.CollectionConverters._

//object MainTestER extends App {
  class MainTestER(args: Array[String]) {

  def time[T](message: String)(thunk: => T): T = {
    val start = System.nanoTime()
    val result = thunk
    val stop = System.nanoTime()
    val total = TimeUnit.NANOSECONDS.toMillis(stop - start)
    println(s"$message: ${total}ms")
    result
  }

  def timeAccum[T](accum: AtomicLong)(thunk: => T): T = {
    val start = System.nanoTime()
    val result = thunk
    val stop = System.nanoTime()
    val total = stop - start
    accum.addAndGet(total)
    result
  }

  def queryExistential(er: ExistentialRestriction, revHier: Map[Role, Set[Role]], reasoner: ReasonerState): Set[Concept] = {
    val rs = revHier.getOrElse(er.role, Set.empty)
    (for {
      c <- reasoner.closureSubsBySuperclass.getOrElse(er.concept, Set.empty).iterator
      (r, es) <- reasoner.linksByTarget.getOrElse(c, Map.empty)
      if rs(r)
    } yield es.iterator).flatten.toSet
  }

  def queryExistential2(er: ExistentialRestriction, revHier: Map[Role, List[Role]], linksByRole: Map[Role, Map[Concept, Set[Concept]]], reasoner: ReasonerState): Set[Concept] = {
    val rs = revHier.getOrElse(er.role, Nil)
    val cs = reasoner.closureSubsBySuperclass.getOrElse(er.concept, Set.empty)
    (for {
      r <- rs.iterator
      (target, subjects) <- linksByRole.getOrElse(r, Map.empty).iterator
      if cs(target)
    } yield subjects.iterator).flatten.toSet
  }

  def queryExistential3(er: ExistentialRestriction, revHier: Map[Role, List[Role]], linksByRole: Map[Role, Map[Concept, Set[Concept]]], reasoner: ReasonerState): Set[Concept] = {
    val rs = revHier.getOrElse(er.role, Nil)
    val cs = reasoner.closureSubsBySuperclass.getOrElse(er.concept, Set.empty)
    (for {
      r <- rs.iterator
      targetsToSubjects = linksByRole.getOrElse(r, Map.empty)
      subclassTargets = targetsToSubjects.keySet.intersect(cs)
    } yield subclassTargets.flatMap(targetsToSubjects.getOrElse(_, Set.empty))).flatten.toSet
  }

  def queryExistential4(er: ExistentialRestriction, revHier: Map[Role, Set[Role]], allTargets: Set[Concept], linksByTargetList: Map[Concept, List[(Role, List[Concept])]], reasoner: ReasonerState): Set[Concept] = {
    val rs = revHier.getOrElse(er.role, Set.empty)
    val cs = reasoner.closureSubsBySuperclass.getOrElse(er.concept, Set.empty)
    val validTargets = cs.intersect(allTargets)
    (for {
      target <- validTargets
      (r, es) <- linksByTargetList.getOrElse(target, Map.empty)
      if rs(r)
    } yield es.iterator).flatten.toSet
  }

  val ontology = OWLManager.createOWLOntologyManager().loadOntology(IRI.create(new File(args(0))))
  val axioms = Bridge.ontologyToAxioms(ontology)
  val whelk = Reasoner.assert(axioms)
  val allTargets = whelk.linksByTarget.keySet
  val linksByTargetList = whelk.linksByTarget.view.mapValues(_.to(List)).toMap
  val revHier = (for {
    (r, ss) <- whelk.hier.toList
    s <- ss
  } yield {
    s -> r
  }).groupMapReduce(_._1)(e => Set(e._2))(_ ++ _)
  val revHierList = (for {
    (r, ss) <- whelk.hier.toList
    s <- ss
  } yield {
    s -> r
  }).groupMapReduce(_._1)(e => Set(e._2))(_ ++ _).view.mapValues(_.to(List)).toMap
  val linksByRole = (for {
    (target, roleToSubjects) <- whelk.linksByTarget.toList
    (role, subjects) <- roleToSubjects.toList
    subject <- subjects
  } yield (role, target, subject))
    .groupMap(_._1)(item => item._2 -> item._3).map { case (role, targetsAndSubjects) =>
    role -> targetsAndSubjects.groupMapReduce(_._1)(e => Set(e._2))(_ ++ _)
  }
  val negativeExistentials = whelk.negExistsMapByConcept.flatMap(_._2).to(Set)

  //val er = ExistentialRestriction(Role(args(1)), AtomicConcept(args(2)))


  val classes = ontology.getClassesInSignature().asScala.to(Set).map(c => AtomicConcept(c.getIRI.toString))
  val properties = ontology.getObjectPropertiesInSignature().asScala.to(Set).map(p => Role(p.getIRI.toString))

  val oldAccum = new AtomicLong(0)
  val accum1 = new AtomicLong(0)
  val accum2 = new AtomicLong(0)
  val accum3 = new AtomicLong(0)
  val accum4 = new AtomicLong(0)

  val mod = args(1).toInt

  println("Starting")
  var num = 0
  for {
    property <- properties
    cls <- classes
    _ = num += 1
    if num % mod == 0
  } {
    val er = ExistentialRestriction(property, cls)

    //    val normalSubclasses = timeAccum(oldAccum) {
    //      val fresh = AtomicConcept(s"urn:uuid:${UUID.randomUUID.toString}")
    //      val result = Reasoner.assert(Set(ConceptInclusion(fresh, er), ConceptInclusion(er, fresh)), whelk)
    //      (result.closureSubsBySuperclass.getOrElse(er, Set.empty) + Bottom)
    //        .collect { case ac @ AtomicConcept(_) => ac } - fresh
    //    }

    val newSubclasses = timeAccum(accum1) {
      //if (negativeExistentials(er))
      //      whelk.closureSubsBySuperclass(er).collect { case ac @ AtomicConcept(_) => ac } + Bottom
      //  else
      queryExistential(er, revHier, whelk).collect { case ac @ AtomicConcept(_) => ac } + Bottom
    }

    val newSubclasses2 = timeAccum(accum2) {
      queryExistential2(er, revHierList, linksByRole, whelk).collect { case ac @ AtomicConcept(_) => ac } + Bottom
    }

    val newSubclasses3 = timeAccum(accum3) {
      queryExistential3(er, revHierList, linksByRole, whelk).collect { case ac @ AtomicConcept(_) => ac } + Bottom
    }

    val newSubclasses4 = timeAccum(accum4) {
      queryExistential4(er, revHier, allTargets, linksByTargetList, whelk).collect { case ac @ AtomicConcept(_) => ac } + Bottom
    }
  }



  //println(s"Equal? ${normalSubclasses == newSubclasses}")
  //println(s"Equal2? ${normalSubclasses == newSubclasses2}")
  //  println(s"Old: ${normalSubclasses.size}")
  //  println(s"New: ${newSubclasses.size}")
  //  println(s"New2: ${newSubclasses2.size}")
  //  println(s"New3: ${newSubclasses3.size}")
  //  println(s"New4: ${newSubclasses4.size}")
  //  println(s"In old but not new:")
  //  (normalSubclasses -- newSubclasses).foreach(c => println(c.id))
  //println()
  //println(s"In new but not old:")
  //(newSubclasses -- normalSubclasses).foreach(c => println(c.id))

  println(s"Old: ${TimeUnit.NANOSECONDS.toMillis(oldAccum.get())}")
  println(s"1: ${TimeUnit.NANOSECONDS.toMillis(accum1.get())}")
  println(s"2: ${TimeUnit.NANOSECONDS.toMillis(accum2.get())}")
  println(s"3: ${TimeUnit.NANOSECONDS.toMillis(accum3.get())}")
  println(s"4: ${TimeUnit.NANOSECONDS.toMillis(accum4.get())}")

}
