/*
 * Copyright 2018 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.taxonomy.gringlobal.model;

import java.time.LocalDateTime;

import org.genesys.taxonomy.gringlobal.component.CabReader;

import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvDate;

import lombok.Data;


/**
 * @author Matija Obreza
 */
@Data
public class AuthorRow {

	@CsvBindByName(column = "taxonomy_author_id")
	private Long taxonomyAuthorId;

	@CsvBindByName(column = "short_name")
	private String shortName;

	@CsvBindByName(column = "full_name")
	private String fullName;

	@CsvBindByName(column = "short_name_expanded_diacritic")
	private String shortNameExpandedDiacritic;

	@CsvBindByName(column = "full_name_expanded_diacritic")
	private String fullNameExpandedDiacritic;

	@CsvBindByName(column = "note")
	private String note;

	@CsvBindByName(column = "created_date")
	@CsvDate(CabReader.CSV_DATE_FORMAT)
	private LocalDateTime createdDate;

	@CsvBindByName(column = "created_by")
	private Long createdBy;

	@CsvBindByName(column = "modified_date")
	@CsvDate(CabReader.CSV_DATE_FORMAT)
	private LocalDateTime modifiedDate;

	@CsvBindByName(column = "modified_by")
	private Long modifiedBy;

	@CsvBindByName(column = "owned_date")
	@CsvDate(CabReader.CSV_DATE_FORMAT)
	private LocalDateTime ownedDate;

	@CsvBindByName(column = "owned_by")
	private Long ownedBy;

}
