/*
 * Copyright 2020 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.taxonomy.gringlobal.model;

import java.time.LocalDateTime;

import org.genesys.taxonomy.gringlobal.component.CabReader;

import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvDate;

import lombok.Data;

/**
 * @author Matija Obreza
 */
@Data
public class CommonNameRow {

	@CsvBindByName(column = "taxonomy_common_name_id")
	private Long id;

	@CsvBindByName(column = "taxonomy_genus_id")
	private Long taxonomyGenusId;

	@CsvBindByName(column = "taxonomy_species_id")
	private Long taxonomySpeciesId;

	@CsvBindByName(column = "alternate_transcription")
	private String alternateTranscription;

	@CsvBindByName(column = "citation_id")
	private Long citationId;

	@CsvBindByName(column = "language_description")
	private String languageDescription;

	@CsvBindByName(column = "name")
	private String name;

	@CsvBindByName(column = "note")
	private String note;

	@CsvBindByName(column = "simplified_name")
	private String simplifiedName;

	@CsvBindByName(column = "created_date")
	@CsvDate(CabReader.CSV_DATE_FORMAT)
	private LocalDateTime createdDate;

	@CsvBindByName(column = "created_by")
	private Long createdBy;

	@CsvBindByName(column = "modified_date")
	@CsvDate(CabReader.CSV_DATE_FORMAT)
	private LocalDateTime modifiedDate;

	@CsvBindByName(column = "modified_by")
	private Long modifiedBy;

	@CsvBindByName(column = "owned_date")
	@CsvDate(CabReader.CSV_DATE_FORMAT)
	private LocalDateTime ownedDate;

	@CsvBindByName(column = "owned_by")
	private Long ownedBy;

}
