/*
 * Copyright 2020 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.taxonomy.gringlobal.model;

import java.time.LocalDateTime;

import org.genesys.taxonomy.gringlobal.component.CabReader;

import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvDate;

import lombok.Data;

/**
 * taxonomy_family_id, current_taxonomy_family_id, type_taxonomy_genus_id,
 * suprafamily_rank_code, suprafamily_rank_name, family_name, family_authority,
 * alternate_name, subfamily_name, tribe_name, subtribe_name, note,
 * created_date, created_by, modified_date, modified_by, owned_date, owned_by.
 *
 * @author Matija Obreza
 */
@Data
public class FamilyRow {

	@CsvBindByName(column = "taxonomy_family_id")
	private Long taxonomyFamilyId;

	@CsvBindByName(column = "current_taxonomy_family_id")
	private Long currentTaxonomyFamilyId;

	@CsvBindByName(column = "type_taxonomy_genus_id")
	private Long typeTaxonomyGenusId;

	@CsvBindByName(column = "suprafamily_rank_code")
	private String suprafamilyRankCode;

	@CsvBindByName(column = "suprafamily_rank_name")
	private String suprafamilyRankName;

	@CsvBindByName(column = "family_name")
	private String familyName;

	@CsvBindByName(column = "family_authority")
	private String familyAuthority;

	@CsvBindByName(column = "alternate_name")
	private String alternateName;

	@CsvBindByName(column = "subfamily_name")
	private String subfamilyName;

	@CsvBindByName(column = "tribe_name")
	private String tribeName;

	@CsvBindByName(column = "subtribe_name")
	private String subtribeName;

	@CsvBindByName(column = "tamily_type_code")
	private String familyTypeCode;

	@CsvBindByName(column = "note")
	private String note;

	@CsvBindByName(column = "created_date")
	@CsvDate(CabReader.CSV_DATE_FORMAT)
	private LocalDateTime createdDate;

	@CsvBindByName(column = "created_by")
	private Long createdBy;

	@CsvBindByName(column = "modified_date")
	@CsvDate(CabReader.CSV_DATE_FORMAT)
	private LocalDateTime modifiedDate;

	@CsvBindByName(column = "modified_by")
	private Long modifiedBy;

	@CsvBindByName(column = "owned_date")
	@CsvDate(CabReader.CSV_DATE_FORMAT)
	private LocalDateTime ownedDate;

	@CsvBindByName(column = "owned_by")
	private Long ownedBy;

}
