/*
 * Copyright 2020 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.taxonomy.gringlobal.model;

import java.time.LocalDateTime;

import org.genesys.taxonomy.gringlobal.component.CabReader;

import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvDate;

import lombok.Data;
import lombok.ToString;

/**
 * "TAXONOMY_GENUS_ID", "CURRENT_TAXONOMY_GENUS_ID", "TAXONOMY_FAMILY_ID",
 * "QUALIFYING_CODE", "IS_HYBRID", "GENUS_NAME", "GENUS_AUTHORITY",
 * "SUBGENUS_NAME", "SECTION_NAME", "SUBSECTION_NAME", "SERIES_NAME",
 * "SUBSERIES_NAME", "NOTE", "CREATED_DATE", "CREATED_BY", "MODIFIED_DATE",
 * "MODIFIED_BY", "OWNED_DATE", "OWNED_BY".
 */
@Data
public class GenusRow {

	@CsvBindByName(column = "taxonomy_genus_id")
	private Long taxonomyGenusId;

	@CsvBindByName(column = "current_taxonomy_genus_id")
	private Long currentTaxonomyGenusId;

	@CsvBindByName(column = "taxonomy_family_id")
	private Long taxonomyFamilyId;

	@CsvBindByName(column = "qualifying_code")
	private String qualifyingCode;

	@CsvBindByName(column = "hybrid_code")
	private String hybridCode;

	@CsvBindByName(column = "genus_name")
	private String genusName;

	@CsvBindByName(column = "genus_authority")
	private String genusAuthority;

	@CsvBindByName(column = "subgenus_name")
	private String subgenusName;

	@CsvBindByName(column = "section_name")
	private String sectionName;

	@CsvBindByName(column = "subsection_name")
	private String subsectionName;

	@CsvBindByName(column = "series_name")
	private String seriesName;

	@CsvBindByName(column = "subseries_name")
	private String subseriesName;

	@CsvBindByName(column = "is_web_visible")
	private String isWebVisible;
	
	@CsvBindByName(column = "note")
	@ToString.Exclude
	private String note;

	@CsvBindByName(column = "created_date")
	@CsvDate(CabReader.CSV_DATE_FORMAT)
	@ToString.Exclude
	private LocalDateTime createdDate;

	@CsvBindByName(column = "created_by")
	@ToString.Exclude
	private Long createdBy;

	@CsvBindByName(column = "modified_date")
	@CsvDate(CabReader.CSV_DATE_FORMAT)
	@ToString.Exclude
	private LocalDateTime modifiedDate;

	@CsvBindByName(column = "modified_by")
	@ToString.Exclude
	private Long modifiedBy;

	@CsvBindByName(column = "owned_date")
	@CsvDate(CabReader.CSV_DATE_FORMAT)
	@ToString.Exclude
	private LocalDateTime ownedDate;

	@CsvBindByName(column = "owned_by")
	@ToString.Exclude
	private Long ownedBy;

	/**
	 * Gets the genus id.
	 *
	 * @return the genus id
	 */
	public Long getGenusId() {
		return taxonomyGenusId;
	}

}
