/*
 * Copyright 2020 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.taxonomy.gringlobal.model;

import java.time.LocalDateTime;

import org.genesys.taxonomy.gringlobal.component.CabReader;

import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvDate;

import lombok.Data;

/**
 * geography_id current_geography_id country_code adm1 adm1_type_code
 * adm1_abbrev adm2 adm2_type_code adm2_abbrev adm3 adm3_type_code adm3_abbrev
 * adm4 adm4_type_code adm4_abbrev changed_date is_valid note created_date
 * created_by modified_date modified_by owned_date owned_by.
 *
 * @author Matija Obreza
 */
@Data
public class GeographyRow {

	@CsvBindByName(column = "geography_id")
	private Long geographyId;

	@CsvBindByName(column = "current_geography_id")
	private Long currentGeographyId;

	@CsvBindByName(column = "country_code")
	private String countryCode;

	@CsvBindByName(column = "adm1")
	private String adm1;

	@CsvBindByName(column = "adm1_type_code")
	private String adm1TypeCode;

	@CsvBindByName(column = "adm1_abbrev")
	private String adm1Abbrev;

	@CsvBindByName(column = "adm2")
	private String adm2;

	@CsvBindByName(column = "adm2_type_code")
	private String adm2TypeCode;

	@CsvBindByName(column = "adm2_abbrev")
	private String adm2Abbrev;

	@CsvBindByName(column = "adm3")
	private String adm3;

	@CsvBindByName(column = "adm3_type_code")
	private String adm3TypeCode;

	@CsvBindByName(column = "adm3_abbrev")
	private String adm3Abbrev;

	@CsvBindByName(column = "adm4")
	private String adm4;

	@CsvBindByName(column = "adm4_type_code")
	private String adm4TypeCode;

	@CsvBindByName(column = "adm4_abbrev")
	private String adm4Abbrev;

	@CsvBindByName(column = "changed_date")
	@CsvDate(CabReader.CSV_DATE_FORMAT)
	private LocalDateTime changedDate;

	@CsvBindByName(column = "is_valid")
	private String isValid;

	@CsvBindByName(column = "note")
	private String note;

	@CsvBindByName(column = "created_date")
	@CsvDate(CabReader.CSV_DATE_FORMAT)
	private LocalDateTime createdDate;

	@CsvBindByName(column = "created_by")
	private Long createdBy;

	@CsvBindByName(column = "modified_date")
	@CsvDate(CabReader.CSV_DATE_FORMAT)
	private LocalDateTime modifiedDate;

	@CsvBindByName(column = "modified_by")
	private Long modifiedBy;

	@CsvBindByName(column = "owned_date")
	@CsvDate(CabReader.CSV_DATE_FORMAT)
	private LocalDateTime ownedDate;

	@CsvBindByName(column = "owned_by")
	private Long ownedBy;

}
