/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.taxonomy.gringlobal.component;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.bean.CsvToBean;
import com.opencsv.bean.CsvToBeanBuilder;
import com.opencsv.bean.HeaderColumnNameMappingStrategy;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.processor.RowProcessor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;

public class CabReader {
    public static final String CSV_DATE_FORMAT = "yyyy-MM-dd' 'HH:mm:ss";

    public static InputStreamReader bomSafeReader(InputStream inputStream) throws IOException {
        String defaultEncoding = "UTF-8";
        BOMInputStream bOMInputStream = new BOMInputStream(inputStream);
        ByteOrderMark bom = bOMInputStream.getBOM();
        String charsetName = bom == null ? defaultEncoding : bom.getCharsetName();
        InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream((InputStream)bOMInputStream), charsetName);
        return reader;
    }

    public static <T> CsvToBean<T> beanReader(Class<T> clazz, CSVReader reader) {
        HeaderColumnNameMappingStrategy headerMapping = new HeaderColumnNameMappingStrategy();
        headerMapping.setType(clazz);
        return new CsvToBeanBuilder(reader).withMappingStrategy((MappingStrategy)headerMapping).build();
    }

    public static CSVReader openCsvReader(InputStream inputStream, int startAt) throws IOException {
        CSVParser parser = new CSVParserBuilder().withSeparator('\t').withQuoteChar('\"').withEscapeChar('\u0000').withStrictQuotes(false).withIgnoreQuotations(true).build();
        CSVReader csvReader = new CSVReaderBuilder((Reader)CabReader.bomSafeReader(inputStream)).withSkipLines(startAt).withCSVParser((ICSVParser)parser).withRowProcessor(new RowProcessor(){

            public void processRow(String[] row) {
                for (int i = 0; i < row.length; ++i) {
                    row[i] = this.processColumnItem(row[i]);
                }
            }

            public String processColumnItem(String column) {
                if ("\\N".equals(column)) {
                    return null;
                }
                return column;
            }
        }).build();
        return csvReader;
    }
}

