/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.taxonomy.gringlobal.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public interface IGrinSpecies {
    public String getSpeciesName();

    public Long getGenusId();

    public Long getSpeciesId();

    public String getIsSpecificHybrid();

    public boolean isCurrent();

    public String getSpeciesAuthority();

    public String getSubtaxa();

    public String getSubtaxaAuthority();

    public String getSubspeciesName();

    public String getVarietyName();

    public String getName();

    public Long getCurrentTaxonomySpeciesId();

    default public boolean subtaxaMatches(String subtaxa) {
        subtaxa = (String)StringUtils.defaultIfBlank((CharSequence)subtaxa, null);
        String subtaxPattern = (String)StringUtils.defaultIfBlank((CharSequence)this.getSubtaxa(), null);
        if (subtaxa == null) {
            return subtaxPattern == null;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)subtaxPattern, (CharSequence)subtaxa)) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)subtaxPattern)) {
            return false;
        }
        subtaxPattern = subtaxPattern.replaceAll("^(\\w+)\\.\\s+(\\w+)", "($1\\\\.\\\\s*)$2\\$");
        Pattern p = Pattern.compile(subtaxPattern, 2);
        Matcher m = p.matcher(subtaxa);
        boolean found = m.find();
        return found;
    }
}

