/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.taxonomy.gringlobal.model;

public enum Qualifier {
    ACCEPTED(""),
    ALWAYS_SYNONYM("="),
    MOSTLY_SYNONYM("=~"),
    SOMETIMES_SYNONYM("~");

    private String value;

    private Qualifier(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static Qualifier fromString(String value) {
        if ("~".equals(value)) {
            return SOMETIMES_SYNONYM;
        }
        if ("=~".equals(value)) {
            return MOSTLY_SYNONYM;
        }
        if ("=".equals(value)) {
            return ALWAYS_SYNONYM;
        }
        if ("".equals(value) || null == value) {
            return ACCEPTED;
        }
        throw new RuntimeException("No qualifier with code " + value);
    }
}

