/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.taxonomy.gringlobal.model;

import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvDate;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.genesys.taxonomy.gringlobal.model.IGrinSpecies;

public class SpeciesRow
implements IGrinSpecies {
    private static final String PREFIX_SUBSPECIES = "subsp. ";
    private static final String PREFIX_NOTHOSUBSPECIES = "nothosubsp. ";
    private static final String PREFIX_VARIETY = "var. ";
    private static final String PREFIX_SUBVARIETY = "subvar. ";
    private static final String PREFIX_FORMA = "f.";
    @CsvBindByName(column="taxonomy_species_id")
    private Long taxonomySpeciesId;
    @CsvBindByName(column="taxonomy_genus_id")
    private Long taxonomyGenusId;
    @CsvBindByName(column="name")
    private String name;
    @CsvBindByName(column="name_authority")
    private String nameAuthority;
    private final AtomicReference<Object> subtaxa = new AtomicReference();
    private final AtomicReference<Object> subtaxaAuthority = new AtomicReference();
    @CsvBindByName(column="nomen_number")
    private Long nomenNumber;
    @CsvBindByName(column="synonym_code")
    private String synonymCode;
    @CsvBindByName(column="current_taxonomy_species_id")
    private Long currentTaxonomySpeciesId;
    @CsvBindByName(column="is_specific_hybrid")
    private String isSpecificHybrid;
    @CsvBindByName(column="species_name")
    private String speciesName;
    @CsvBindByName(column="species_authority")
    private String speciesAuthority;
    @CsvBindByName(column="is_subspecific_hybrid")
    private String isSubspecificHybrid;
    @CsvBindByName(column="subspecies_name")
    private String subspeciesName;
    @CsvBindByName(column="subspecies_authority")
    private String subspeciesAuthority;
    @CsvBindByName(column="is_varietal_hybrid")
    private String isVarietalHybrid;
    @CsvBindByName(column="variety_name")
    private String varietyName;
    @CsvBindByName(column="variety_authority")
    private String varietyAuthority;
    @CsvBindByName(column="is_subvarietal_hybrid")
    private String isSubvarietalHybrid;
    @CsvBindByName(column="subvariety_name")
    private String subvarietyName;
    @CsvBindByName(column="subvariety_authority")
    private String subvarietyAuthority;
    @CsvBindByName(column="is_forma_hybrid")
    private String isFormaHybrid;
    @CsvBindByName(column="forma_rank_type")
    private String formaRankType;
    @CsvBindByName(column="forma_name")
    private String formaName;
    @CsvBindByName(column="forma_authority")
    private String formaAuthority;
    @CsvBindByName(column="priority1_site_id")
    private Long priority1SiteId;
    @CsvBindByName(column="priority2_site_id")
    private Long priority2SiteId;
    @CsvBindByName(column="curator1_cooperator_id")
    private Long curator1CooperatorId;
    @CsvBindByName(column="curator2_cooperator_id")
    private Long curator2CooperatorId;
    @CsvBindByName(column="restriction_code")
    private String restrictionCode;
    @CsvBindByName(column="life_form_code")
    private String lifeFormCode;
    @CsvBindByName(column="common_fertilization_code")
    private String commonFertilizationCode;
    @CsvBindByName(column="is_name_pending")
    private String isNamePending;
    @CsvBindByName(column="verifier_cooperator_id")
    private Long verifierCooperatorId;
    @CsvBindByName(column="name_verified_date")
    @CsvDate(value="yyyy-MM-dd' 'HH:mm:ss")
    private LocalDateTime nameVerifiedDate;
    @CsvBindByName(column="protologue")
    private String protologue;
    @CsvBindByName(column="protologue_virtual_path")
    private String protologueVirtualPath;
    @CsvBindByName(column="note")
    private String note;
    @CsvBindByName(column="site_note")
    private String siteNote;
    @CsvBindByName(column="alternate_name")
    private String alternateName;
    @CsvBindByName(column="hybrid_parentage")
    private String hybridParentage;
    @CsvBindByName(column="is_web_visible")
    private String isWebVisible;
    @CsvBindByName(column="created_date")
    @CsvDate(value="yyyy-MM-dd' 'HH:mm:ss")
    private LocalDateTime createdDate;
    @CsvBindByName(column="created_by")
    private Long createdBy;
    @CsvBindByName(column="modified_date")
    @CsvDate(value="yyyy-MM-dd' 'HH:mm:ss")
    private LocalDateTime modifiedDate;
    @CsvBindByName(column="modified_by")
    private Long modifiedBy;
    @CsvBindByName(column="owned_date")
    @CsvDate(value="yyyy-MM-dd' 'HH:mm:ss")
    private LocalDateTime ownedDate;
    @CsvBindByName(column="owned_by")
    private Long ownedBy;

    @Override
    public Long getSpeciesId() {
        return this.taxonomySpeciesId;
    }

    @Override
    public Long getGenusId() {
        return this.taxonomyGenusId;
    }

    @Override
    public boolean isCurrent() {
        return this.taxonomySpeciesId.equals(this.currentTaxonomySpeciesId);
    }

    private String toSubtaxa() {
        if (this.formaName != null) {
            String prefix = (String)StringUtils.defaultIfBlank((CharSequence)this.formaRankType, (CharSequence)PREFIX_FORMA) + " ";
            return prefix + this.formaName;
        }
        if (this.subvarietyName != null) {
            return PREFIX_SUBVARIETY + this.subvarietyName;
        }
        if (this.varietyName != null) {
            return PREFIX_VARIETY + this.varietyName;
        }
        if (this.subspeciesName != null) {
            if ("Y".equals(this.isSubspecificHybrid)) {
                return PREFIX_NOTHOSUBSPECIES + this.subspeciesName;
            }
            return PREFIX_SUBSPECIES + this.subspeciesName;
        }
        return null;
    }

    private String toSubtaxaAuthority() {
        if (this.formaName != null) {
            return this.formaAuthority;
        }
        if (this.subvarietyName != null) {
            return this.subvarietyAuthority;
        }
        if (this.varietyName != null) {
            return this.varietyAuthority;
        }
        if (this.subspeciesName != null) {
            return this.subspeciesAuthority;
        }
        return null;
    }

    public Long getTaxonomySpeciesId() {
        return this.taxonomySpeciesId;
    }

    public Long getTaxonomyGenusId() {
        return this.taxonomyGenusId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getNameAuthority() {
        return this.nameAuthority;
    }

    public Long getNomenNumber() {
        return this.nomenNumber;
    }

    public String getSynonymCode() {
        return this.synonymCode;
    }

    @Override
    public Long getCurrentTaxonomySpeciesId() {
        return this.currentTaxonomySpeciesId;
    }

    @Override
    public String getIsSpecificHybrid() {
        return this.isSpecificHybrid;
    }

    @Override
    public String getSpeciesName() {
        return this.speciesName;
    }

    @Override
    public String getSpeciesAuthority() {
        return this.speciesAuthority;
    }

    public String getIsSubspecificHybrid() {
        return this.isSubspecificHybrid;
    }

    @Override
    public String getSubspeciesName() {
        return this.subspeciesName;
    }

    public String getSubspeciesAuthority() {
        return this.subspeciesAuthority;
    }

    public String getIsVarietalHybrid() {
        return this.isVarietalHybrid;
    }

    @Override
    public String getVarietyName() {
        return this.varietyName;
    }

    public String getVarietyAuthority() {
        return this.varietyAuthority;
    }

    public String getIsSubvarietalHybrid() {
        return this.isSubvarietalHybrid;
    }

    public String getSubvarietyName() {
        return this.subvarietyName;
    }

    public String getSubvarietyAuthority() {
        return this.subvarietyAuthority;
    }

    public String getIsFormaHybrid() {
        return this.isFormaHybrid;
    }

    public String getFormaRankType() {
        return this.formaRankType;
    }

    public String getFormaName() {
        return this.formaName;
    }

    public String getFormaAuthority() {
        return this.formaAuthority;
    }

    public Long getPriority1SiteId() {
        return this.priority1SiteId;
    }

    public Long getPriority2SiteId() {
        return this.priority2SiteId;
    }

    public Long getCurator1CooperatorId() {
        return this.curator1CooperatorId;
    }

    public Long getCurator2CooperatorId() {
        return this.curator2CooperatorId;
    }

    public String getRestrictionCode() {
        return this.restrictionCode;
    }

    public String getLifeFormCode() {
        return this.lifeFormCode;
    }

    public String getCommonFertilizationCode() {
        return this.commonFertilizationCode;
    }

    public String getIsNamePending() {
        return this.isNamePending;
    }

    public Long getVerifierCooperatorId() {
        return this.verifierCooperatorId;
    }

    public LocalDateTime getNameVerifiedDate() {
        return this.nameVerifiedDate;
    }

    public String getProtologue() {
        return this.protologue;
    }

    public String getProtologueVirtualPath() {
        return this.protologueVirtualPath;
    }

    public String getNote() {
        return this.note;
    }

    public String getSiteNote() {
        return this.siteNote;
    }

    public String getAlternateName() {
        return this.alternateName;
    }

    public String getHybridParentage() {
        return this.hybridParentage;
    }

    public String getIsWebVisible() {
        return this.isWebVisible;
    }

    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    public Long getCreatedBy() {
        return this.createdBy;
    }

    public LocalDateTime getModifiedDate() {
        return this.modifiedDate;
    }

    public Long getModifiedBy() {
        return this.modifiedBy;
    }

    public LocalDateTime getOwnedDate() {
        return this.ownedDate;
    }

    public Long getOwnedBy() {
        return this.ownedBy;
    }

    public void setTaxonomySpeciesId(Long taxonomySpeciesId) {
        this.taxonomySpeciesId = taxonomySpeciesId;
    }

    public void setTaxonomyGenusId(Long taxonomyGenusId) {
        this.taxonomyGenusId = taxonomyGenusId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNameAuthority(String nameAuthority) {
        this.nameAuthority = nameAuthority;
    }

    public void setNomenNumber(Long nomenNumber) {
        this.nomenNumber = nomenNumber;
    }

    public void setSynonymCode(String synonymCode) {
        this.synonymCode = synonymCode;
    }

    public void setCurrentTaxonomySpeciesId(Long currentTaxonomySpeciesId) {
        this.currentTaxonomySpeciesId = currentTaxonomySpeciesId;
    }

    public void setIsSpecificHybrid(String isSpecificHybrid) {
        this.isSpecificHybrid = isSpecificHybrid;
    }

    public void setSpeciesName(String speciesName) {
        this.speciesName = speciesName;
    }

    public void setSpeciesAuthority(String speciesAuthority) {
        this.speciesAuthority = speciesAuthority;
    }

    public void setIsSubspecificHybrid(String isSubspecificHybrid) {
        this.isSubspecificHybrid = isSubspecificHybrid;
    }

    public void setSubspeciesName(String subspeciesName) {
        this.subspeciesName = subspeciesName;
    }

    public void setSubspeciesAuthority(String subspeciesAuthority) {
        this.subspeciesAuthority = subspeciesAuthority;
    }

    public void setIsVarietalHybrid(String isVarietalHybrid) {
        this.isVarietalHybrid = isVarietalHybrid;
    }

    public void setVarietyName(String varietyName) {
        this.varietyName = varietyName;
    }

    public void setVarietyAuthority(String varietyAuthority) {
        this.varietyAuthority = varietyAuthority;
    }

    public void setIsSubvarietalHybrid(String isSubvarietalHybrid) {
        this.isSubvarietalHybrid = isSubvarietalHybrid;
    }

    public void setSubvarietyName(String subvarietyName) {
        this.subvarietyName = subvarietyName;
    }

    public void setSubvarietyAuthority(String subvarietyAuthority) {
        this.subvarietyAuthority = subvarietyAuthority;
    }

    public void setIsFormaHybrid(String isFormaHybrid) {
        this.isFormaHybrid = isFormaHybrid;
    }

    public void setFormaRankType(String formaRankType) {
        this.formaRankType = formaRankType;
    }

    public void setFormaName(String formaName) {
        this.formaName = formaName;
    }

    public void setFormaAuthority(String formaAuthority) {
        this.formaAuthority = formaAuthority;
    }

    public void setPriority1SiteId(Long priority1SiteId) {
        this.priority1SiteId = priority1SiteId;
    }

    public void setPriority2SiteId(Long priority2SiteId) {
        this.priority2SiteId = priority2SiteId;
    }

    public void setCurator1CooperatorId(Long curator1CooperatorId) {
        this.curator1CooperatorId = curator1CooperatorId;
    }

    public void setCurator2CooperatorId(Long curator2CooperatorId) {
        this.curator2CooperatorId = curator2CooperatorId;
    }

    public void setRestrictionCode(String restrictionCode) {
        this.restrictionCode = restrictionCode;
    }

    public void setLifeFormCode(String lifeFormCode) {
        this.lifeFormCode = lifeFormCode;
    }

    public void setCommonFertilizationCode(String commonFertilizationCode) {
        this.commonFertilizationCode = commonFertilizationCode;
    }

    public void setIsNamePending(String isNamePending) {
        this.isNamePending = isNamePending;
    }

    public void setVerifierCooperatorId(Long verifierCooperatorId) {
        this.verifierCooperatorId = verifierCooperatorId;
    }

    public void setNameVerifiedDate(LocalDateTime nameVerifiedDate) {
        this.nameVerifiedDate = nameVerifiedDate;
    }

    public void setProtologue(String protologue) {
        this.protologue = protologue;
    }

    public void setProtologueVirtualPath(String protologueVirtualPath) {
        this.protologueVirtualPath = protologueVirtualPath;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setSiteNote(String siteNote) {
        this.siteNote = siteNote;
    }

    public void setAlternateName(String alternateName) {
        this.alternateName = alternateName;
    }

    public void setHybridParentage(String hybridParentage) {
        this.hybridParentage = hybridParentage;
    }

    public void setIsWebVisible(String isWebVisible) {
        this.isWebVisible = isWebVisible;
    }

    public void setCreatedDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public void setCreatedBy(Long createdBy) {
        this.createdBy = createdBy;
    }

    public void setModifiedDate(LocalDateTime modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public void setModifiedBy(Long modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public void setOwnedDate(LocalDateTime ownedDate) {
        this.ownedDate = ownedDate;
    }

    public void setOwnedBy(Long ownedBy) {
        this.ownedBy = ownedBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpeciesRow)) {
            return false;
        }
        SpeciesRow other = (SpeciesRow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$taxonomySpeciesId = this.getTaxonomySpeciesId();
        Long other$taxonomySpeciesId = other.getTaxonomySpeciesId();
        if (this$taxonomySpeciesId == null ? other$taxonomySpeciesId != null : !((Object)this$taxonomySpeciesId).equals(other$taxonomySpeciesId)) {
            return false;
        }
        Long this$taxonomyGenusId = this.getTaxonomyGenusId();
        Long other$taxonomyGenusId = other.getTaxonomyGenusId();
        if (this$taxonomyGenusId == null ? other$taxonomyGenusId != null : !((Object)this$taxonomyGenusId).equals(other$taxonomyGenusId)) {
            return false;
        }
        Long this$nomenNumber = this.getNomenNumber();
        Long other$nomenNumber = other.getNomenNumber();
        if (this$nomenNumber == null ? other$nomenNumber != null : !((Object)this$nomenNumber).equals(other$nomenNumber)) {
            return false;
        }
        Long this$currentTaxonomySpeciesId = this.getCurrentTaxonomySpeciesId();
        Long other$currentTaxonomySpeciesId = other.getCurrentTaxonomySpeciesId();
        if (this$currentTaxonomySpeciesId == null ? other$currentTaxonomySpeciesId != null : !((Object)this$currentTaxonomySpeciesId).equals(other$currentTaxonomySpeciesId)) {
            return false;
        }
        Long this$priority1SiteId = this.getPriority1SiteId();
        Long other$priority1SiteId = other.getPriority1SiteId();
        if (this$priority1SiteId == null ? other$priority1SiteId != null : !((Object)this$priority1SiteId).equals(other$priority1SiteId)) {
            return false;
        }
        Long this$priority2SiteId = this.getPriority2SiteId();
        Long other$priority2SiteId = other.getPriority2SiteId();
        if (this$priority2SiteId == null ? other$priority2SiteId != null : !((Object)this$priority2SiteId).equals(other$priority2SiteId)) {
            return false;
        }
        Long this$curator1CooperatorId = this.getCurator1CooperatorId();
        Long other$curator1CooperatorId = other.getCurator1CooperatorId();
        if (this$curator1CooperatorId == null ? other$curator1CooperatorId != null : !((Object)this$curator1CooperatorId).equals(other$curator1CooperatorId)) {
            return false;
        }
        Long this$curator2CooperatorId = this.getCurator2CooperatorId();
        Long other$curator2CooperatorId = other.getCurator2CooperatorId();
        if (this$curator2CooperatorId == null ? other$curator2CooperatorId != null : !((Object)this$curator2CooperatorId).equals(other$curator2CooperatorId)) {
            return false;
        }
        Long this$verifierCooperatorId = this.getVerifierCooperatorId();
        Long other$verifierCooperatorId = other.getVerifierCooperatorId();
        if (this$verifierCooperatorId == null ? other$verifierCooperatorId != null : !((Object)this$verifierCooperatorId).equals(other$verifierCooperatorId)) {
            return false;
        }
        Long this$createdBy = this.getCreatedBy();
        Long other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !((Object)this$createdBy).equals(other$createdBy)) {
            return false;
        }
        Long this$modifiedBy = this.getModifiedBy();
        Long other$modifiedBy = other.getModifiedBy();
        if (this$modifiedBy == null ? other$modifiedBy != null : !((Object)this$modifiedBy).equals(other$modifiedBy)) {
            return false;
        }
        Long this$ownedBy = this.getOwnedBy();
        Long other$ownedBy = other.getOwnedBy();
        if (this$ownedBy == null ? other$ownedBy != null : !((Object)this$ownedBy).equals(other$ownedBy)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$nameAuthority = this.getNameAuthority();
        String other$nameAuthority = other.getNameAuthority();
        if (this$nameAuthority == null ? other$nameAuthority != null : !this$nameAuthority.equals(other$nameAuthority)) {
            return false;
        }
        String this$subtaxa = this.getSubtaxa();
        String other$subtaxa = other.getSubtaxa();
        if (this$subtaxa == null ? other$subtaxa != null : !this$subtaxa.equals(other$subtaxa)) {
            return false;
        }
        String this$subtaxaAuthority = this.getSubtaxaAuthority();
        String other$subtaxaAuthority = other.getSubtaxaAuthority();
        if (this$subtaxaAuthority == null ? other$subtaxaAuthority != null : !this$subtaxaAuthority.equals(other$subtaxaAuthority)) {
            return false;
        }
        String this$synonymCode = this.getSynonymCode();
        String other$synonymCode = other.getSynonymCode();
        if (this$synonymCode == null ? other$synonymCode != null : !this$synonymCode.equals(other$synonymCode)) {
            return false;
        }
        String this$isSpecificHybrid = this.getIsSpecificHybrid();
        String other$isSpecificHybrid = other.getIsSpecificHybrid();
        if (this$isSpecificHybrid == null ? other$isSpecificHybrid != null : !this$isSpecificHybrid.equals(other$isSpecificHybrid)) {
            return false;
        }
        String this$speciesName = this.getSpeciesName();
        String other$speciesName = other.getSpeciesName();
        if (this$speciesName == null ? other$speciesName != null : !this$speciesName.equals(other$speciesName)) {
            return false;
        }
        String this$speciesAuthority = this.getSpeciesAuthority();
        String other$speciesAuthority = other.getSpeciesAuthority();
        if (this$speciesAuthority == null ? other$speciesAuthority != null : !this$speciesAuthority.equals(other$speciesAuthority)) {
            return false;
        }
        String this$isSubspecificHybrid = this.getIsSubspecificHybrid();
        String other$isSubspecificHybrid = other.getIsSubspecificHybrid();
        if (this$isSubspecificHybrid == null ? other$isSubspecificHybrid != null : !this$isSubspecificHybrid.equals(other$isSubspecificHybrid)) {
            return false;
        }
        String this$subspeciesName = this.getSubspeciesName();
        String other$subspeciesName = other.getSubspeciesName();
        if (this$subspeciesName == null ? other$subspeciesName != null : !this$subspeciesName.equals(other$subspeciesName)) {
            return false;
        }
        String this$subspeciesAuthority = this.getSubspeciesAuthority();
        String other$subspeciesAuthority = other.getSubspeciesAuthority();
        if (this$subspeciesAuthority == null ? other$subspeciesAuthority != null : !this$subspeciesAuthority.equals(other$subspeciesAuthority)) {
            return false;
        }
        String this$isVarietalHybrid = this.getIsVarietalHybrid();
        String other$isVarietalHybrid = other.getIsVarietalHybrid();
        if (this$isVarietalHybrid == null ? other$isVarietalHybrid != null : !this$isVarietalHybrid.equals(other$isVarietalHybrid)) {
            return false;
        }
        String this$varietyName = this.getVarietyName();
        String other$varietyName = other.getVarietyName();
        if (this$varietyName == null ? other$varietyName != null : !this$varietyName.equals(other$varietyName)) {
            return false;
        }
        String this$varietyAuthority = this.getVarietyAuthority();
        String other$varietyAuthority = other.getVarietyAuthority();
        if (this$varietyAuthority == null ? other$varietyAuthority != null : !this$varietyAuthority.equals(other$varietyAuthority)) {
            return false;
        }
        String this$isSubvarietalHybrid = this.getIsSubvarietalHybrid();
        String other$isSubvarietalHybrid = other.getIsSubvarietalHybrid();
        if (this$isSubvarietalHybrid == null ? other$isSubvarietalHybrid != null : !this$isSubvarietalHybrid.equals(other$isSubvarietalHybrid)) {
            return false;
        }
        String this$subvarietyName = this.getSubvarietyName();
        String other$subvarietyName = other.getSubvarietyName();
        if (this$subvarietyName == null ? other$subvarietyName != null : !this$subvarietyName.equals(other$subvarietyName)) {
            return false;
        }
        String this$subvarietyAuthority = this.getSubvarietyAuthority();
        String other$subvarietyAuthority = other.getSubvarietyAuthority();
        if (this$subvarietyAuthority == null ? other$subvarietyAuthority != null : !this$subvarietyAuthority.equals(other$subvarietyAuthority)) {
            return false;
        }
        String this$isFormaHybrid = this.getIsFormaHybrid();
        String other$isFormaHybrid = other.getIsFormaHybrid();
        if (this$isFormaHybrid == null ? other$isFormaHybrid != null : !this$isFormaHybrid.equals(other$isFormaHybrid)) {
            return false;
        }
        String this$formaRankType = this.getFormaRankType();
        String other$formaRankType = other.getFormaRankType();
        if (this$formaRankType == null ? other$formaRankType != null : !this$formaRankType.equals(other$formaRankType)) {
            return false;
        }
        String this$formaName = this.getFormaName();
        String other$formaName = other.getFormaName();
        if (this$formaName == null ? other$formaName != null : !this$formaName.equals(other$formaName)) {
            return false;
        }
        String this$formaAuthority = this.getFormaAuthority();
        String other$formaAuthority = other.getFormaAuthority();
        if (this$formaAuthority == null ? other$formaAuthority != null : !this$formaAuthority.equals(other$formaAuthority)) {
            return false;
        }
        String this$restrictionCode = this.getRestrictionCode();
        String other$restrictionCode = other.getRestrictionCode();
        if (this$restrictionCode == null ? other$restrictionCode != null : !this$restrictionCode.equals(other$restrictionCode)) {
            return false;
        }
        String this$lifeFormCode = this.getLifeFormCode();
        String other$lifeFormCode = other.getLifeFormCode();
        if (this$lifeFormCode == null ? other$lifeFormCode != null : !this$lifeFormCode.equals(other$lifeFormCode)) {
            return false;
        }
        String this$commonFertilizationCode = this.getCommonFertilizationCode();
        String other$commonFertilizationCode = other.getCommonFertilizationCode();
        if (this$commonFertilizationCode == null ? other$commonFertilizationCode != null : !this$commonFertilizationCode.equals(other$commonFertilizationCode)) {
            return false;
        }
        String this$isNamePending = this.getIsNamePending();
        String other$isNamePending = other.getIsNamePending();
        if (this$isNamePending == null ? other$isNamePending != null : !this$isNamePending.equals(other$isNamePending)) {
            return false;
        }
        LocalDateTime this$nameVerifiedDate = this.getNameVerifiedDate();
        LocalDateTime other$nameVerifiedDate = other.getNameVerifiedDate();
        if (this$nameVerifiedDate == null ? other$nameVerifiedDate != null : !((Object)this$nameVerifiedDate).equals(other$nameVerifiedDate)) {
            return false;
        }
        String this$protologue = this.getProtologue();
        String other$protologue = other.getProtologue();
        if (this$protologue == null ? other$protologue != null : !this$protologue.equals(other$protologue)) {
            return false;
        }
        String this$protologueVirtualPath = this.getProtologueVirtualPath();
        String other$protologueVirtualPath = other.getProtologueVirtualPath();
        if (this$protologueVirtualPath == null ? other$protologueVirtualPath != null : !this$protologueVirtualPath.equals(other$protologueVirtualPath)) {
            return false;
        }
        String this$note = this.getNote();
        String other$note = other.getNote();
        if (this$note == null ? other$note != null : !this$note.equals(other$note)) {
            return false;
        }
        String this$siteNote = this.getSiteNote();
        String other$siteNote = other.getSiteNote();
        if (this$siteNote == null ? other$siteNote != null : !this$siteNote.equals(other$siteNote)) {
            return false;
        }
        String this$alternateName = this.getAlternateName();
        String other$alternateName = other.getAlternateName();
        if (this$alternateName == null ? other$alternateName != null : !this$alternateName.equals(other$alternateName)) {
            return false;
        }
        String this$hybridParentage = this.getHybridParentage();
        String other$hybridParentage = other.getHybridParentage();
        if (this$hybridParentage == null ? other$hybridParentage != null : !this$hybridParentage.equals(other$hybridParentage)) {
            return false;
        }
        String this$isWebVisible = this.getIsWebVisible();
        String other$isWebVisible = other.getIsWebVisible();
        if (this$isWebVisible == null ? other$isWebVisible != null : !this$isWebVisible.equals(other$isWebVisible)) {
            return false;
        }
        LocalDateTime this$createdDate = this.getCreatedDate();
        LocalDateTime other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        LocalDateTime this$modifiedDate = this.getModifiedDate();
        LocalDateTime other$modifiedDate = other.getModifiedDate();
        if (this$modifiedDate == null ? other$modifiedDate != null : !((Object)this$modifiedDate).equals(other$modifiedDate)) {
            return false;
        }
        LocalDateTime this$ownedDate = this.getOwnedDate();
        LocalDateTime other$ownedDate = other.getOwnedDate();
        return !(this$ownedDate == null ? other$ownedDate != null : !((Object)this$ownedDate).equals(other$ownedDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpeciesRow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $taxonomySpeciesId = this.getTaxonomySpeciesId();
        result = result * 59 + ($taxonomySpeciesId == null ? 43 : ((Object)$taxonomySpeciesId).hashCode());
        Long $taxonomyGenusId = this.getTaxonomyGenusId();
        result = result * 59 + ($taxonomyGenusId == null ? 43 : ((Object)$taxonomyGenusId).hashCode());
        Long $nomenNumber = this.getNomenNumber();
        result = result * 59 + ($nomenNumber == null ? 43 : ((Object)$nomenNumber).hashCode());
        Long $currentTaxonomySpeciesId = this.getCurrentTaxonomySpeciesId();
        result = result * 59 + ($currentTaxonomySpeciesId == null ? 43 : ((Object)$currentTaxonomySpeciesId).hashCode());
        Long $priority1SiteId = this.getPriority1SiteId();
        result = result * 59 + ($priority1SiteId == null ? 43 : ((Object)$priority1SiteId).hashCode());
        Long $priority2SiteId = this.getPriority2SiteId();
        result = result * 59 + ($priority2SiteId == null ? 43 : ((Object)$priority2SiteId).hashCode());
        Long $curator1CooperatorId = this.getCurator1CooperatorId();
        result = result * 59 + ($curator1CooperatorId == null ? 43 : ((Object)$curator1CooperatorId).hashCode());
        Long $curator2CooperatorId = this.getCurator2CooperatorId();
        result = result * 59 + ($curator2CooperatorId == null ? 43 : ((Object)$curator2CooperatorId).hashCode());
        Long $verifierCooperatorId = this.getVerifierCooperatorId();
        result = result * 59 + ($verifierCooperatorId == null ? 43 : ((Object)$verifierCooperatorId).hashCode());
        Long $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : ((Object)$createdBy).hashCode());
        Long $modifiedBy = this.getModifiedBy();
        result = result * 59 + ($modifiedBy == null ? 43 : ((Object)$modifiedBy).hashCode());
        Long $ownedBy = this.getOwnedBy();
        result = result * 59 + ($ownedBy == null ? 43 : ((Object)$ownedBy).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $nameAuthority = this.getNameAuthority();
        result = result * 59 + ($nameAuthority == null ? 43 : $nameAuthority.hashCode());
        String $subtaxa = this.getSubtaxa();
        result = result * 59 + ($subtaxa == null ? 43 : $subtaxa.hashCode());
        String $subtaxaAuthority = this.getSubtaxaAuthority();
        result = result * 59 + ($subtaxaAuthority == null ? 43 : $subtaxaAuthority.hashCode());
        String $synonymCode = this.getSynonymCode();
        result = result * 59 + ($synonymCode == null ? 43 : $synonymCode.hashCode());
        String $isSpecificHybrid = this.getIsSpecificHybrid();
        result = result * 59 + ($isSpecificHybrid == null ? 43 : $isSpecificHybrid.hashCode());
        String $speciesName = this.getSpeciesName();
        result = result * 59 + ($speciesName == null ? 43 : $speciesName.hashCode());
        String $speciesAuthority = this.getSpeciesAuthority();
        result = result * 59 + ($speciesAuthority == null ? 43 : $speciesAuthority.hashCode());
        String $isSubspecificHybrid = this.getIsSubspecificHybrid();
        result = result * 59 + ($isSubspecificHybrid == null ? 43 : $isSubspecificHybrid.hashCode());
        String $subspeciesName = this.getSubspeciesName();
        result = result * 59 + ($subspeciesName == null ? 43 : $subspeciesName.hashCode());
        String $subspeciesAuthority = this.getSubspeciesAuthority();
        result = result * 59 + ($subspeciesAuthority == null ? 43 : $subspeciesAuthority.hashCode());
        String $isVarietalHybrid = this.getIsVarietalHybrid();
        result = result * 59 + ($isVarietalHybrid == null ? 43 : $isVarietalHybrid.hashCode());
        String $varietyName = this.getVarietyName();
        result = result * 59 + ($varietyName == null ? 43 : $varietyName.hashCode());
        String $varietyAuthority = this.getVarietyAuthority();
        result = result * 59 + ($varietyAuthority == null ? 43 : $varietyAuthority.hashCode());
        String $isSubvarietalHybrid = this.getIsSubvarietalHybrid();
        result = result * 59 + ($isSubvarietalHybrid == null ? 43 : $isSubvarietalHybrid.hashCode());
        String $subvarietyName = this.getSubvarietyName();
        result = result * 59 + ($subvarietyName == null ? 43 : $subvarietyName.hashCode());
        String $subvarietyAuthority = this.getSubvarietyAuthority();
        result = result * 59 + ($subvarietyAuthority == null ? 43 : $subvarietyAuthority.hashCode());
        String $isFormaHybrid = this.getIsFormaHybrid();
        result = result * 59 + ($isFormaHybrid == null ? 43 : $isFormaHybrid.hashCode());
        String $formaRankType = this.getFormaRankType();
        result = result * 59 + ($formaRankType == null ? 43 : $formaRankType.hashCode());
        String $formaName = this.getFormaName();
        result = result * 59 + ($formaName == null ? 43 : $formaName.hashCode());
        String $formaAuthority = this.getFormaAuthority();
        result = result * 59 + ($formaAuthority == null ? 43 : $formaAuthority.hashCode());
        String $restrictionCode = this.getRestrictionCode();
        result = result * 59 + ($restrictionCode == null ? 43 : $restrictionCode.hashCode());
        String $lifeFormCode = this.getLifeFormCode();
        result = result * 59 + ($lifeFormCode == null ? 43 : $lifeFormCode.hashCode());
        String $commonFertilizationCode = this.getCommonFertilizationCode();
        result = result * 59 + ($commonFertilizationCode == null ? 43 : $commonFertilizationCode.hashCode());
        String $isNamePending = this.getIsNamePending();
        result = result * 59 + ($isNamePending == null ? 43 : $isNamePending.hashCode());
        LocalDateTime $nameVerifiedDate = this.getNameVerifiedDate();
        result = result * 59 + ($nameVerifiedDate == null ? 43 : ((Object)$nameVerifiedDate).hashCode());
        String $protologue = this.getProtologue();
        result = result * 59 + ($protologue == null ? 43 : $protologue.hashCode());
        String $protologueVirtualPath = this.getProtologueVirtualPath();
        result = result * 59 + ($protologueVirtualPath == null ? 43 : $protologueVirtualPath.hashCode());
        String $note = this.getNote();
        result = result * 59 + ($note == null ? 43 : $note.hashCode());
        String $siteNote = this.getSiteNote();
        result = result * 59 + ($siteNote == null ? 43 : $siteNote.hashCode());
        String $alternateName = this.getAlternateName();
        result = result * 59 + ($alternateName == null ? 43 : $alternateName.hashCode());
        String $hybridParentage = this.getHybridParentage();
        result = result * 59 + ($hybridParentage == null ? 43 : $hybridParentage.hashCode());
        String $isWebVisible = this.getIsWebVisible();
        result = result * 59 + ($isWebVisible == null ? 43 : $isWebVisible.hashCode());
        LocalDateTime $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        LocalDateTime $modifiedDate = this.getModifiedDate();
        result = result * 59 + ($modifiedDate == null ? 43 : ((Object)$modifiedDate).hashCode());
        LocalDateTime $ownedDate = this.getOwnedDate();
        result = result * 59 + ($ownedDate == null ? 43 : ((Object)$ownedDate).hashCode());
        return result;
    }

    public String toString() {
        return "SpeciesRow(taxonomySpeciesId=" + this.getTaxonomySpeciesId() + ", taxonomyGenusId=" + this.getTaxonomyGenusId() + ", name=" + this.getName() + ", nameAuthority=" + this.getNameAuthority() + ", subtaxa=" + this.getSubtaxa() + ", subtaxaAuthority=" + this.getSubtaxaAuthority() + ", nomenNumber=" + this.getNomenNumber() + ", synonymCode=" + this.getSynonymCode() + ", currentTaxonomySpeciesId=" + this.getCurrentTaxonomySpeciesId() + ", isSpecificHybrid=" + this.getIsSpecificHybrid() + ", speciesName=" + this.getSpeciesName() + ", speciesAuthority=" + this.getSpeciesAuthority() + ", isSubspecificHybrid=" + this.getIsSubspecificHybrid() + ", subspeciesName=" + this.getSubspeciesName() + ", subspeciesAuthority=" + this.getSubspeciesAuthority() + ", isVarietalHybrid=" + this.getIsVarietalHybrid() + ", varietyName=" + this.getVarietyName() + ", varietyAuthority=" + this.getVarietyAuthority() + ", isSubvarietalHybrid=" + this.getIsSubvarietalHybrid() + ", subvarietyName=" + this.getSubvarietyName() + ", subvarietyAuthority=" + this.getSubvarietyAuthority() + ", isFormaHybrid=" + this.getIsFormaHybrid() + ", formaRankType=" + this.getFormaRankType() + ", formaName=" + this.getFormaName() + ", formaAuthority=" + this.getFormaAuthority() + ", restrictionCode=" + this.getRestrictionCode() + ", lifeFormCode=" + this.getLifeFormCode() + ", isNamePending=" + this.getIsNamePending() + ", alternateName=" + this.getAlternateName() + ", hybridParentage=" + this.getHybridParentage() + ", isWebVisible=" + this.getIsWebVisible() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubtaxa() {
        Object value = this.subtaxa.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.subtaxa;
            synchronized (atomicReference) {
                value = this.subtaxa.get();
                if (value == null) {
                    String actualValue = this.toSubtaxa();
                    value = actualValue == null ? this.subtaxa : actualValue;
                    this.subtaxa.set(value);
                }
            }
        }
        return (String)(value == this.subtaxa ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubtaxaAuthority() {
        Object value = this.subtaxaAuthority.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.subtaxaAuthority;
            synchronized (atomicReference) {
                value = this.subtaxaAuthority.get();
                if (value == null) {
                    String actualValue = this.toSubtaxaAuthority();
                    value = actualValue == null ? this.subtaxaAuthority : actualValue;
                    this.subtaxaAuthority.set(value);
                }
            }
        }
        return (String)(value == this.subtaxaAuthority ? null : value);
    }
}

