/**
 * Copyright 2013 Bioversity International and
 *                the Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * The code tree likely contains a copy of the License,
 * ('LICENSE'), but you may also obtain a copy at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/
package org.genesys2.rdf.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

/**
 * Language.
 *
 * @author rbruskiewich
 */
public class Language {

	/** The debug. */
	private static Boolean _DEBUG = false;

	/** The Constant defaultCode. */
	private final static String defaultCode = "en";

	/**
	 * Debug.
	 *
	 * @param debug the debug
	 */
	public static void debug(Boolean debug) {
		_DEBUG = debug;
	}

	/** The Constant ISO_639_2. */
	private final static String ISO_639_2 = "http://www.loc.gov/standards/iso639-2/ISO-639-2_8859-1.txt";

	/** The table. */
	private static Map<String, String> table = new HashMap<String, String>();

	/**
	 * Checks if is o_639_2.
	 *
	 * @return the map
	 */
	public static Map<String, String> ISO_639_2() {
		if (table.isEmpty()) {
			init();
		}
		return new HashMap<String, String>(table);
	}

	/**
	 * Gets the language.
	 *
	 * @param code the code
	 * @return the language
	 */
	public static String getLanguage(String code) {
		if (table.isEmpty()) {
			init();
		}
		if (table.containsKey(code))
			return table.get(code);
		else {
			return null;
		}
	}

	/**
	 * Gets the default language code.
	 *
	 * @return the default language code
	 */
	public static String getDefaultLanguageCode() {
		return defaultCode;
	}

	/**
	 * Gets the default language.
	 *
	 * @return the default language
	 */
	public static String getDefaultLanguage() {
		return getLanguage(defaultCode);
	}

	/**
	 * Inits the.
	 */
	private static void init() {
		try {
			URL isolang = new URL(ISO_639_2);
			BufferedReader in = new BufferedReader(new InputStreamReader(isolang.openStream()));
			String inputLine;
			while ((inputLine = in.readLine()) != null) {

				String[] field = inputLine.split("\\|");
				String[] englishName = field[3].split("\\;");

				if (_DEBUG) {
					System.out.println(inputLine);
					System.out.println("alpha-3 (bibliographic) code: " + field[0]);
					System.out.println("\talpha-3 (terminologic) code: " + field[1]);
					System.out.println("\talpha-2 code:\t" + field[2]);
					System.out.println("\tEnglish name:\t" + field[3]);
					System.out.println("\tFrench name:\t" + field[4]);
					System.out.println();
				}
				if (!table.containsKey(field[0])) {
					table.put(field[0], englishName[0]);
				}
				if (field[2].length() > 0 && !table.containsKey(field[2])) {
					table.put(field[2], englishName[0]);
				}
			}
			in.close();

		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
