/**
 * Copyright 2013 Bioversity International and
 *                the Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * The code tree likely contains a copy of the License,
 * ('LICENSE'), but you may also obtain a copy at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys2.rdf.model.dc;

import java.io.IOException;

import org.genesys2.rdf.model.ModelException;
import org.genesys2.rdf.model.rdf.ModelDocument;
import org.genesys2.rdf.model.rdf.Vocabularies;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;

// TODO: Auto-generated Javadoc
/**
 * Wrapper of the Dublin Core Metadata Initiative (RDF) ontology.
 */
public class DublinCore extends ModelDocument {

	/**
	 * <p>
	 * The RDF model that holds the vocabulary terms
	 * </p>
	 * .
	 */
	private static Model m_model = ModelFactory.createDefaultModel();

	/**
	 * <p>
	 * The namespace of the vocabulary as a string
	 * </p>
	 * .
	 */
	public static final String NS = Vocabularies.DUBLIN_CORE_TERMS.getURI();

	/**
	 * <p>
	 * The namespace of the vocabulary as a string
	 * </p>
	 * .
	 *
	 * @return the uri
	 * @see #NS
	 */
	public static String getURI() {
		return NS;
	}

	/**
	 * <p>
	 * The namespace of the vocabulary as a resource
	 * </p>
	 * .
	 */
	public static final Resource NAMESPACE = m_model.createResource(NS);

	// /** <p>A Dublin Core (class type).</p> */
	// public static final Resource Concept = m_model.createResource( NS +
	// "Concept" );

	/**
	 * <p>
	 * Indicates the creator of a document.
	 * </p>
	 */
	public static final Property creator = m_model.createProperty(NS + "creator");

	/**
	 * <p>
	 * Indicates the version of a document.
	 * </p>
	 */
	public static final Property hasVersion = m_model.createProperty(NS + "hasVersion");

	/**
	 * <p>
	 * Indicates the description of a document.
	 * </p>
	 */
	public static final Property description = m_model.createProperty(NS + "description");

	/**
	 * Constructor to initialize Dublin Core Metadata Initiative ontology.
	 *
	 * @throws IOException Signals that an I/O exception has occurred.
	 * @throws ModelException the model exception
	 */
	public DublinCore() throws IOException, ModelException {
		super(Vocabularies.DUBLIN_CORE_TERMS.getURI());
	}
}
