/**
 * org.bioversityinternational.model.rdf.skos.SKOS
 *
 * Created: Sep 25, 2013 - 10:45:05 AM
 *
 * Copyright 2013 Bioversity International and
 *                the Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * The code tree likely contains a copy of the License,
 * ('LICENSE'), but you may also obtain a copy at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Wrapper of the Simple Knowledge Organization System (RDF) ontology
 */
package org.genesys2.rdf.model.dwc;

import org.genesys2.rdf.model.rdf.Vocabularies;

// TODO: Auto-generated Javadoc
/**
 * The Enum DCA.
 */
public enum DCA {

	/** The abcd equivalence. */
	abcdEquivalence("abcdEquivalence"),

	/** The organized in class. */
	organizedInClass("organizedInClass"),

	/** The status. */
	status("status");

	/** The hashtag. */
	private final String hashtag;

	/** The Constant baseuri. */
	static private final String baseuri = Vocabularies.DARWIN_CORE_ATTRIBUTES.getURI();

	/**
	 * Instantiates a new dca.
	 *
	 * @param hashtag the hashtag
	 */
	DCA(String hashtag) {
		this.hashtag = hashtag;
	}

	/**
	 * Term.
	 *
	 * @return the string
	 */
	public String term() {
		return hashtag;
	}

	/**
	 * Gets the uri.
	 *
	 * @return the uri
	 */
	public String getURI() {
		return baseuri + hashtag;
	}
}
