/**
 * Copyright 2013 Bioversity International and
 *                the Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * The code tree likely contains a copy of the License,
 * ('LICENSE'), but you may also obtain a copy at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys2.rdf.model.germplasm;

import java.io.IOException;

import org.genesys2.rdf.model.ModelException;
import org.genesys2.rdf.model.rdf.Vocabularies;

// TODO: Auto-generated Javadoc
/**
 * Wrapper of the Darwin Core (RDF) ontology.
 *
 * @author Richard Bruskiewich
 */
public class DarwinCoreGermplasmType extends DescriptorOntology {

	/**
	 * Constructor to initialize Darwin Core Germplasm Type ontology.
	 *
	 * @throws IOException Signals that an I/O exception has occurred.
	 * @throws ModelException the model exception
	 */
	public DarwinCoreGermplasmType() throws IOException, ModelException {
		super(Vocabularies.DARWIN_CORE_GERMPLASM_TYPES.getURI());
	}
}
