/**
 * Copyright 2013 Bioversity International and
 *                the Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * The code tree likely contains a copy of the License,
 * ('LICENSE'), but you may also obtain a copy at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys2.rdf.model.germplasm;

import java.io.IOException;

import org.genesys2.rdf.model.ModelException;
import org.genesys2.rdf.model.rdf.Vocabularies;

/**
 * MultiCropPassportDescriptorOntology manages the MCPD meta-data as documented
 * by the DarwinCore-Germplasm RDF model.
 * 
 * SPECIAL NOTE: As of September 25th, the DarwinCore Germplasm has has a
 * curious flaw in non-standard RDF: It uses XML QNames in rdf:about and
 * rdf:resource attributes, which may be non-compliant with RDF standards.
 * 
 * For this reason, if you need to access the full URI's as keys in your
 * Map&lt;String,String&gt;, you need to do a QName rewrite to full URI's. A
 * method in the Parser is provided for this purpose, where categories and
 * descriptors are assumed to be the original Map&lt;String,String&gt; data
 * structures returned by their respective lookup functions.
 * 
 * categories = mcpd.parser().fullURIMap(categories) ; descriptors =
 * mcpd.parser().fullURIMap(descriptors) ;
 * 
 * One needs to be cautious in doing this, simply because category and
 * descriptor details may still only be visible via the QNames, not the full
 * URI's
 * 
 * @author Richard Bruskiewich
 */
public class MCPDOntology extends DescriptorOntology {

	/**
	 * Constructor to initialize FAO/Bioversity Multi-Crop Passport Ontology.
	 *
	 * @throws IOException Signals that an I/O exception has occurred.
	 * @throws ModelException the model exception
	 */
	public MCPDOntology() throws IOException, ModelException {
		super(Vocabularies.DARWIN_CORE_GERMPLASM_TERMS.getURI());
	}
}
