/**
 * Copyright 2013 Bioversity International and
 *                the Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * The code tree likely contains a copy of the License,
 * ('LICENSE'), but you may also obtain a copy at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys2.rdf.model.skos;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;

// TODO: Auto-generated Javadoc
/**
 * Wrapper of the Simple Knowledge Organization System (RDF) ontology.
 */
public class SKOS {

	/**
	 * <p>
	 * The RDF model that holds the vocabulary terms
	 * </p>
	 * .
	 */
	private static Model m_model = ModelFactory.createDefaultModel();

	/**
	 * <p>
	 * The namespace of the vocabulary as a string
	 * </p>
	 * .
	 */
	public static final String NS = "http://www.w3.org/2004/02/skos/core#";

	/**
	 * <p>
	 * The namespace of the vocabulary as a string
	 * </p>
	 * .
	 *
	 * @return the uri
	 * @see #NS
	 */
	public static String getURI() {
		return NS;
	}

	/**
	 * <p>
	 * The namespace of the vocabulary as a resource
	 * </p>
	 * .
	 */
	public static final Resource NAMESPACE = m_model.createResource(NS);

	/**
	 * <p>
	 * A SKOS Concept (class type).
	 * </p>
	 */
	public static final Resource Concept = m_model.createResource(NS + "Concept");

	/**
	 * <p>
	 * A SKOS Collection (class type) of related SKOS Concept instances.
	 * </p>
	 */
	public static final Resource Collection = m_model.createResource(NS + "Collection");

	/**
	 * <p>
	 * A SKOS ConceptScheme (class type).
	 * </p>
	 */
	public static final Resource ConceptScheme = m_model.createResource(NS + "ConceptScheme");

	/**
	 * <p>
	 * Indicates the ConceptScheme to which a given SKOS Concept belongs.
	 * </p>
	 */
	public static final Property inScheme = m_model.createProperty(NS + "inScheme");

	/**
	 * <p>
	 * Indicates the ConceptScheme to which a given SKOS Concept belongs.
	 * </p>
	 */
	public static final Property member = m_model.createProperty(NS + "member");

	/**
	 * <p>
	 * A SKOS Concept prefLabel property.
	 * </p>
	 */
	public static final Property prefLabel = m_model.createProperty(NS + "prefLabel");

	/**
	 * <p>
	 * A SKOS Concept altLabel property.
	 * </p>
	 */
	public static final Property altLabel = m_model.createProperty(NS + "altLabel");

	/**
	 * <p>
	 * A SKOS Concept hiddenLabel property.
	 * </p>
	 */
	public static final Property hiddenLabel = m_model.createProperty(NS + "hiddenLabel");

	/**
	 * <p>
	 * A SKOS Concept definition property.
	 * </p>
	 */
	public static final Property definition = m_model.createProperty(NS + "definition");

	/**
	 * <p>
	 * A SKOS Concept broader property.
	 * </p>
	 */
	public static final Property broader = m_model.createProperty(NS + "broader");

	/**
	 * <p>
	 * A SKOS Concept narrower property.
	 * </p>
	 */
	public static final Property narrower = m_model.createProperty(NS + "narrower");

	/**
	 * <p>
	 * A SKOS Concept related property.
	 * </p>
	 */
	public static final Property related = m_model.createProperty(NS + "related");

}
