/*
 * Decompiled with CFR 0.152.
 */
package org.genesys2.rdf.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class Language {
    private static Boolean _DEBUG = false;
    private static final String defaultCode = "en";
    private static final String ISO_639_2 = "http://www.loc.gov/standards/iso639-2/ISO-639-2_8859-1.txt";
    private static Map<String, String> table = new HashMap<String, String>();

    public static void debug(Boolean debug) {
        _DEBUG = debug;
    }

    public static Map<String, String> ISO_639_2() {
        if (table.isEmpty()) {
            Language.init();
        }
        return new HashMap<String, String>(table);
    }

    public static String getLanguage(String code) {
        if (table.isEmpty()) {
            Language.init();
        }
        if (table.containsKey(code)) {
            return table.get(code);
        }
        return null;
    }

    public static String getDefaultLanguageCode() {
        return defaultCode;
    }

    public static String getDefaultLanguage() {
        return Language.getLanguage(defaultCode);
    }

    private static void init() {
        try {
            String inputLine;
            URL isolang = new URL(ISO_639_2);
            BufferedReader in = new BufferedReader(new InputStreamReader(isolang.openStream()));
            while ((inputLine = in.readLine()) != null) {
                String[] field = inputLine.split("\\|");
                String[] englishName = field[3].split("\\;");
                if (_DEBUG.booleanValue()) {
                    System.out.println(inputLine);
                    System.out.println("alpha-3 (bibliographic) code: " + field[0]);
                    System.out.println("\talpha-3 (terminologic) code: " + field[1]);
                    System.out.println("\talpha-2 code:\t" + field[2]);
                    System.out.println("\tEnglish name:\t" + field[3]);
                    System.out.println("\tFrench name:\t" + field[4]);
                    System.out.println();
                }
                if (!table.containsKey(field[0])) {
                    table.put(field[0], englishName[0]);
                }
                if (field[2].length() <= 0 || table.containsKey(field[2])) continue;
                table.put(field[2], englishName[0]);
            }
            in.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

