/*
 * Decompiled with CFR 0.152.
 */
package org.genesys2.rdf.model.dwc;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.IOException;
import java.util.Map;
import org.genesys2.rdf.model.ModelException;
import org.genesys2.rdf.model.dwc.DCA;
import org.genesys2.rdf.model.rdf.ModelDocument;
import org.genesys2.rdf.model.rdf.RDFParserException;
import org.genesys2.rdf.model.rdf.Vocabularies;

public class DarwinCore
extends ModelDocument {
    private static Model m_model = ModelFactory.createDefaultModel();
    public static final String NS = Vocabularies.DARWIN_CORE_TERMS.getURI();
    public static final Resource NAMESPACE = m_model.createResource(NS);
    public static final Resource Taxon = m_model.createResource(String.valueOf(NS) + "Taxon");
    public static final Property scientificName = m_model.createProperty(String.valueOf(NS) + "scientificName");
    public static final Property vernacularName = m_model.createProperty(String.valueOf(NS) + "vernacularName");
    public static final Property genus = m_model.createProperty(String.valueOf(NS) + "genus");

    public static String getURI() {
        return NS;
    }

    public DarwinCore() throws IOException, ModelException {
        super(Vocabularies.DARWIN_CORE_TERMS.getURI());
    }

    @Override
    public Map<String, String> propertyDetails(String termURI, String language) throws RDFParserException {
        Map<String, String> parts = this.parser().parseURI(termURI);
        ModelDocument md = DarwinCore.lookup(parts.get("Namespace"));
        Map<String, String> details = super.propertyDetails(parts.get("URI"), language);
        this._load(details, md.parser().getPropertyValues(parts.get("URI"), DCA.abcdEquivalence.getURI()), DCA.abcdEquivalence.term());
        this._load(details, md.parser().getPropertyValues(parts.get("URI"), DCA.organizedInClass.getURI()), DCA.organizedInClass.term());
        this._load(details, md.parser().getPropertyValues(parts.get("URI"), DCA.status.getURI()), DCA.status.term());
        return details;
    }
}

