/*
 * Decompiled with CFR 0.152.
 */
package org.genesys2.rdf.model.germplasm;

import java.io.IOException;
import java.util.Map;
import org.genesys2.rdf.model.ModelException;
import org.genesys2.rdf.model.rdf.ModelDocument;
import org.genesys2.rdf.model.rdf.RDFParserException;
import org.genesys2.rdf.model.skos.SKOS;

public abstract class DescriptorOntology
extends ModelDocument {
    public static final String NAME = "Name";
    public static final String ALIAS = "Alias";
    public static final String DEFINITION = "Definition";

    protected DescriptorOntology(String modelURI) throws IOException, ModelException {
        super(modelURI);
    }

    protected DescriptorOntology(String modelURI, String language) throws IOException, ModelException {
        this(modelURI);
        this.setLanguage(language);
    }

    public Map<String, String> definition(Map<String, String> details, String descriptorURI, String language) throws RDFParserException {
        Map<String, String> parts = this.parser().parseURI(descriptorURI);
        ModelDocument md = DescriptorOntology.lookup(parts.get("Namespace"));
        this._load(details, md.parser().getPropertyValues(parts.get("URI"), SKOS.prefLabel.getURI(), language, false), NAME);
        this._load(details, md.parser().getPropertyValues(parts.get("URI"), SKOS.altLabel.getURI(), language, true), ALIAS);
        this._load(details, md.parser().getPropertyValues(parts.get("URI"), SKOS.definition.getURI(), language, false), DEFINITION);
        return details;
    }

    public Map<String, String> categories() throws RDFParserException {
        return this.collections();
    }

    public Map<String, String> categoryDetails(String categoryURI, String language) throws RDFParserException {
        Map<String, String> parts = this.parser().parseURI(categoryURI);
        return this.definition(this.classDetails(parts.get("URI"), language), categoryURI, language);
    }

    public Map<String, String> descriptors(String categoryURI) throws RDFParserException {
        return this.members(categoryURI);
    }

    public Map<String, String> descriptorDetails(String descriptorURI, String language) throws RDFParserException {
        Map<String, String> parts = this.parser().parseURI(descriptorURI);
        return this.definition(this.propertyDetails(parts.get("URI"), language), descriptorURI, language);
    }
}

