/*
 * Decompiled with CFR 0.152.
 */
package org.genesys2.rdf.model.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.vocabulary.DCTerms;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.genesys2.rdf.model.Language;
import org.genesys2.rdf.model.ModelException;
import org.genesys2.rdf.model.rdf.Parser;
import org.genesys2.rdf.model.rdf.RDFParserException;
import org.genesys2.rdf.model.rdf.Vocabularies;
import org.genesys2.rdf.model.skos.SKOS;

public abstract class ModelDocument {
    public static final int NONE = 0;
    public static final int INFO = 1;
    public static final int DEBUG = 2;
    public static final int VERBOSE = 3;
    public static int _trace_level = 0;
    public static final String LABEL = "Label";
    public static final String COMMENT = "Comment";
    public static final String DESCRIPTION = "Description";
    public static final String SUB_CLASS_OF = "Subclass of";
    public static final String SUB_PROPERTY_OF = "Subproperty of";
    public static final String MEMBER = "Member";
    public static final String DOMAIN = "Domain";
    public static final String RANGE = "Range";
    protected String modelURI;
    private Model model;
    private Parser parser;
    private String language_code;
    private String language_name;
    private TranslatedModel translatedModel;
    private static Map<String, ModelDocument> catalog = new HashMap<String, ModelDocument>();

    public static void trace(int level) {
        _trace_level = level;
    }

    protected ModelDocument(String modelURI) throws IOException, ModelException {
        if (modelURI == null) {
            throw new ModelException("ModelDocument(modelURI): modelURI cannot be null!");
        }
        if (_trace_level >= 3) {
            System.err.println("ModelDocument(modelURI:'" + modelURI + "')");
        }
        this.modelURI = modelURI;
        this.model = ModelFactory.createDefaultModel();
        this.model.read(this.modelURI);
        this.parser = new Parser(this.model);
    }

    public String URI() {
        return this.modelURI;
    }

    public Parser parser() {
        return this.parser;
    }

    protected void setLanguage(String language) throws IOException, ModelException {
        this.language_code = language.trim();
        this.language_name = Language.getLanguage(this.language_code);
        if (this.language_name == null) {
            throw new ModelException("ModelDocument.setLanguage(): language code '" + this.language_code + "' is unknown?");
        }
    }

    protected ModelDocument translatedModel() {
        return this.translatedModel;
    }

    public void dumpModel(OutputStream out, String format) {
        this.model.write(out, format);
    }

    public void dumpModel(String fileName, String format) {
        try {
            FileOutputStream out = new FileOutputStream(new File(fileName));
            this.dumpModel(out, format);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void dumpModel(String format) {
        this.dumpModel(System.out, format);
    }

    public void dumpModel() {
        this.dumpModel("N3");
    }

    public void dumpModel(OutputStream output) {
        this.dumpModel(output, "N3");
    }

    public Map<String, String> subjectsOfType(String typeURI) throws RDFParserException {
        Map<String, String> subjects = this.parser().subjectsOfType(typeURI);
        return subjects;
    }

    public Map<String, String> classes() throws RDFParserException {
        Map<String, String> classes = this.subjectsOfType(RDFS.Class.getURI());
        return classes;
    }

    public Map<String, String> properties() throws RDFParserException {
        Map<String, String> properties = this.subjectsOfType(RDF.Property.getURI());
        return properties;
    }

    public Map<String, String> members(String collectionURI) throws RDFParserException {
        Map<String, String> members = this.parser().getPropertyValues(collectionURI, SKOS.member.getURI(), true);
        return members;
    }

    public Map<String, String> collections() throws RDFParserException {
        Map<String, String> collections = this.parser().subjectsOfType(SKOS.Collection.getURI());
        for (String uri : collections.keySet()) {
            Map<String, String> members = this.members(uri);
            String value = "";
            for (String member : members.values()) {
                if (value.length() > 0) {
                    value = String.valueOf(value) + "|";
                }
                value = String.valueOf(value) + member;
            }
            collections.put(uri, value);
        }
        return collections;
    }

    protected Map<String, String> _load(Map<String, String> targetMap, Map<String, String> sourceMap, String label) {
        for (String key : sourceMap.keySet()) {
            if (targetMap.containsKey(label)) {
                String value = targetMap.get(label);
                targetMap.put(label, String.valueOf(value) + "|" + sourceMap.get(key));
                continue;
            }
            targetMap.put(label, sourceMap.get(key));
        }
        return targetMap;
    }

    private Map<String, String> generalDetails(ModelDocument md, String termURI, String language) throws RDFParserException {
        HashMap<String, String> details = new HashMap<String, String>();
        this._load(details, md.parser().getPropertyValues(termURI, RDFS.label.getURI(), language, false), LABEL);
        this._load(details, md.parser().getPropertyValues(termURI, RDFS.comment.getURI(), language, false), COMMENT);
        this._load(details, md.parser().getPropertyValues(termURI, DCTerms.description.getURI(), language, false), DESCRIPTION);
        return details;
    }

    public Map<String, String> classDetails(String termURI, String language) throws RDFParserException {
        HashMap<String, String> details = null;
        Map<String, String> parts = this.parser().parseURI(termURI);
        String ns = parts.get("Namespace");
        String uri = parts.get("URI");
        if (ns.equals(Vocabularies.XML_SCHEMA.getURI())) {
            details = new HashMap<String, String>();
            details.put(LABEL, uri);
        } else {
            ModelDocument md = ModelDocument.lookup(ns);
            details = this.generalDetails(md, uri, language);
            this._load(details, md.parser().getPropertyValues(uri, RDFS.subClassOf.getURI(), language, true), SUB_CLASS_OF);
            this._load(details, md.members(uri), MEMBER);
        }
        return details;
    }

    public Map<String, String> propertyDetails(String termURI, String language) throws RDFParserException {
        Map<String, String> parts = this.parser().parseURI(termURI);
        ModelDocument md = ModelDocument.lookup(parts.get("Namespace"));
        Map<String, String> details = this.generalDetails(md, parts.get("URI"), language);
        this._load(details, md.parser().getPropertyValues(parts.get("URI"), RDFS.subPropertyOf.getURI(), language, true), SUB_PROPERTY_OF);
        this._load(details, md.parser().getPropertyValues(parts.get("URI"), RDFS.domain.getURI(), language, true), DOMAIN);
        this._load(details, md.parser().getPropertyValues(parts.get("URI"), RDFS.range.getURI(), language, true), RANGE);
        return details;
    }

    public void dumpSchema(String language) {
        System.out.println("\nReporting RDF Schema for: " + this.modelURI);
        try {
            Map<String, String> cmap = this.classes();
            for (String curi : cmap.keySet()) {
                System.out.printf("\nClass: '%s':\n\n", curi);
                Map<String, String> class_details = this.classDetails(curi, language);
                for (String key : class_details.keySet()) {
                    System.out.printf("%20s: %-255s\n", key, class_details.get(key));
                }
            }
            System.out.println();
            Map<String, String> pmap = this.properties();
            for (String puri : pmap.keySet()) {
                System.out.printf("\nProperty: '%s':\n\n", puri);
                Map<String, String> property_details = this.propertyDetails(puri, language);
                for (String key : property_details.keySet()) {
                    System.out.printf("%20s: %-255s\n", key, property_details.get(key));
                }
            }
            System.out.println();
        }
        catch (RDFParserException me) {
            System.err.println("Caught ModelException: " + me.getMessage());
        }
    }

    public void dumpSchema() {
        this.dumpSchema(null);
    }

    public static ModelDocument lookup(String uri, String language) throws RDFParserException {
        if (_trace_level >= 3) {
            System.err.println("ModelDocument.lookup(" + uri + ")");
        }
        if (uri == null) {
            throw new RDFParserException("ModelDocument.lookup() error: null URI?");
        }
        ModelDocument md = null;
        if (!catalog.containsKey(uri)) {
            Class<ModelDocument> c = Vocabularies.lookup(uri);
            try {
                md = c.newInstance();
                if (language != null) {
                    md.setLanguage(language);
                }
                catalog.put(uri, md);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RDFParserException("ModelDocument.lookup() error!");
            }
            catch (ModelException e) {
                e.printStackTrace();
                throw new RDFParserException("ModelDocument.lookup() error!");
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new RDFParserException("ModelDocument.lookup() error!");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RDFParserException("ModelDocument.lookup() error!");
            }
        } else {
            md = catalog.get(uri);
        }
        return md;
    }

    public static ModelDocument lookup(String uri) throws RDFParserException {
        return ModelDocument.lookup(uri, null);
    }

    private class TranslatedModel
    extends ModelDocument {
        protected TranslatedModel(String modelURI) throws IOException, ModelException {
            super(modelURI);
        }
    }
}

