/*
 * Decompiled with CFR 0.152.
 */
package org.genesys2.rdf.model.rdf;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashMap;
import java.util.Map;
import org.genesys2.rdf.model.rdf.RDFParserException;

public class Parser {
    private static final Boolean _debug = false;
    private Model model = null;
    private Map<String, String> qnames = new HashMap<String, String>();
    private Map<String, String> namespaces = new HashMap<String, String>();
    public static final String NAMESPACE = "Namespace";
    public static final String URI = "URI";
    public static final String TERM = "Term";

    public Parser(Model model) {
        this.model = model;
        for (Map.Entry entry : model.getNsPrefixMap().entrySet()) {
            this.qnames.put((String)entry.getKey(), (String)entry.getValue());
            this.namespaces.put((String)entry.getValue(), (String)entry.getKey());
            if (!_debug.booleanValue()) continue;
            System.out.print("prefix: " + (String)entry.getKey());
            System.out.println(", namespace: " + (String)entry.getValue());
        }
    }

    public Map<String, String> subjectsOfType(String typeURI) throws RDFParserException {
        if (this.model == null) {
            throw new RDFParserException("RDF model not loaded! Call loadModel()!");
        }
        HashMap<String, String> subjects = new HashMap<String, String>();
        StmtIterator statements = this.model.listStatements(null, RDF.type, (RDFNode)this.model.createResource(typeURI));
        while (statements.hasNext()) {
            String key;
            String value;
            Statement statement = statements.nextStatement();
            Resource subject = statement.getSubject();
            if (subject.isAnon()) {
                key = value = subject.getId().toString();
            } else {
                key = subject.getURI();
                value = subject.getLocalName();
            }
            subjects.put(key, value);
        }
        return subjects;
    }

    public Map<String, String> getPropertyValues(String subjectURI, String propertyURI) throws RDFParserException {
        return this.getPropertyValues(subjectURI, propertyURI, null, false);
    }

    public Map<String, String> getPropertyValues(String subjectURI, String propertyURI, Boolean fullId) throws RDFParserException {
        return this.getPropertyValues(subjectURI, propertyURI, null, fullId);
    }

    public Map<String, String> getPropertyValues(String subjectURI, String propertyURI, String language, Boolean fullId) throws RDFParserException {
        if (this.model == null) {
            throw new RDFParserException("RDF model not loaded! Call loadModel()!");
        }
        HashMap<String, String> values = new HashMap<String, String>();
        StmtIterator statements = this.model.listStatements(this.model.createResource(subjectURI), this.model.createProperty(propertyURI), null);
        while (statements.hasNext()) {
            Statement statement = statements.nextStatement();
            RDFNode object = statement.getObject();
            String key = null;
            String value = null;
            if (object.isLiteral()) {
                Literal literal = object.asLiteral();
                String lang = literal.getLanguage();
                if (lang.isEmpty() || language == null || lang.startsWith(language)) {
                    key = literal.toString();
                    value = fullId.booleanValue() ? literal.toString() : literal.getLexicalForm();
                }
            } else {
                Resource objRes = object.asResource();
                if (object.isAnon()) {
                    key = value = objRes.getId().toString();
                } else {
                    key = objRes.getURI();
                    if (fullId.booleanValue()) {
                        Map<String, String> parts = this.parseURI(objRes.getURI());
                        value = parts.get(URI);
                    } else {
                        value = objRes.getLocalName();
                    }
                }
            }
            if (key == null) continue;
            values.put(key, value);
        }
        return values;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> parseURI(String uri) throws RDFParserException {
        if (this.model == null) {
            throw new RDFParserException("RDF model not loaded! Call loadModel()!");
        }
        HashMap<String, String> results = new HashMap<String, String>();
        String[] part = uri.split(":");
        if (part.length <= 1) return results;
        String qname = part[0].toLowerCase();
        String tail = "";
        int i = 1;
        while (i < part.length) {
            tail = String.valueOf(tail) + part[i];
            ++i;
        }
        if (!qname.equals("http")) {
            if (!this.qnames.containsKey(qname)) throw new RDFParserException("Don't recognize XML QName: '" + qname + "'?");
            String ns = this.qnames.get(qname);
            results.put(NAMESPACE, ns);
            results.put(URI, String.valueOf(ns) + tail);
            results.put(TERM, tail);
            return results;
        } else {
            String ns;
            String[] hashpart = uri.split("#");
            if (hashpart.length > 1) {
                ns = String.valueOf(hashpart[0]) + "#";
                results.put(TERM, hashpart[1]);
            } else {
                ns = uri.substring(0, uri.lastIndexOf(47) + 1);
                results.put(TERM, uri.substring(uri.lastIndexOf(47) + 1));
            }
            results.put(NAMESPACE, ns);
            results.put(URI, uri);
        }
        return results;
    }

    public Map<String, String> fullURIMap(Map<String, String> data_map) throws RDFParserException {
        HashMap<String, String> remapped = new HashMap<String, String>();
        for (String key : data_map.keySet()) {
            Map<String, String> parts = this.parseURI(key);
            remapped.put(parts.get(URI), data_map.get(key));
        }
        return remapped;
    }
}

