/*
 * Decompiled with CFR 0.152.
 */
package org.genesys2.rdf.model.rdf;

import org.genesys2.rdf.model.dc.DCMI;
import org.genesys2.rdf.model.dc.DublinCore;
import org.genesys2.rdf.model.dwc.DarwinCore;
import org.genesys2.rdf.model.dwc.DarwinCoreAttributes;
import org.genesys2.rdf.model.foaf.FOAF;
import org.genesys2.rdf.model.germplasm.DarwinCoreGermplasmType;
import org.genesys2.rdf.model.germplasm.MCPDOntology;
import org.genesys2.rdf.model.rdf.ModelDocument;
import org.genesys2.rdf.model.rdf.RDFSchema;
import org.genesys2.rdf.model.w3c.WGS94GeoPositioning;

public enum Vocabularies {
    XML_SCHEMA("http://www.w3.org/2001/XMLSchema#", null),
    RDF_SCHEMA("http://www.w3.org/2000/01/rdf-schema#", RDFSchema.class),
    DUBLIN_CORE_METADATA_INITIATIVE("http://purl.org/dc/dcmitype/", DCMI.class),
    DUBLIN_CORE_TERMS("http://purl.org/dc/terms/", DublinCore.class),
    FOAF("http://xmlns.com/foaf/0.1/", FOAF.class),
    WGS84_GEO_POSITIONING("http://www.w3.org/2003/01/geo/wgs84_pos#", WGS94GeoPositioning.class),
    DARWIN_CORE_TERMS("http://rs.tdwg.org/dwc/terms/", DarwinCore.class),
    DARWIN_CORE_ATTRIBUTES("http://rs.tdwg.org/dwc/terms/attributes/", DarwinCoreAttributes.class),
    DARWIN_CORE_GERMPLASM_TYPES("http://purl.org/germplasm/germplasmType#", DarwinCoreGermplasmType.class),
    DARWIN_CORE_GERMPLASM_TERMS("http://purl.org/germplasm/germplasmTerm#", MCPDOntology.class);

    private final String uri;
    private final Class<ModelDocument> documentClass;

    private Vocabularies(String uri, Class<? extends ModelDocument> documentClass) {
        this.uri = uri;
        this.documentClass = documentClass;
    }

    public String getURI() {
        return this.uri;
    }

    public Class<ModelDocument> getDocClass() {
        return this.documentClass;
    }

    public static Class<ModelDocument> lookup(String uri) {
        Class<ModelDocument> c = null;
        Vocabularies[] vocabulariesArray = Vocabularies.values();
        int n = vocabulariesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Vocabularies v = vocabulariesArray[n2];
            if (v.getURI().equals(uri)) {
                c = v.getDocClass();
                break;
            }
            ++n2;
        }
        return c;
    }
}

