/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.geneweaver.domain.Entity;
import org.geneweaver.io.connector.ChromosomeService;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;

public abstract class AbstractEntity
implements Entity {
    private static ChromosomeService cservice = ChromosomeService.getInstance();
    @Id
    @GeneratedValue
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Long uid;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String delimiter = System.getProperty("delimiter", "|");
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String chr;

    @Override
    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public int hashCode() {
        return Objects.hash(this.chr, this.uid);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractEntity)) {
            return false;
        }
        AbstractEntity other = (AbstractEntity)obj;
        return Objects.equals(this.chr, other.chr) && Objects.equals(this.uid, other.uid);
    }

    @Override
    public final Long getUid() {
        return this.uid;
    }

    public final void setUid(Long uid) {
        this.uid = uid;
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    public void setChr(String chr) {
        this.setChr(chr, false);
    }

    @JsonIgnore
    public void setChr(String chr, boolean force) {
        if (!force) {
            chr = cservice.getChromosome(chr);
        }
        this.chr = chr;
    }

    public String toString() {
        try {
            return this.toCsv();
        }
        catch (Exception ne) {
            return super.toString();
        }
    }
}

