/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.AnchoredEntity;

public class Anchor
extends AbstractEntity
implements AnchoredEntity {
    private String chr;
    private int start;
    private int end;
    private int intensity;

    public Anchor() {
    }

    public Anchor(String chr, int start, int end) {
        this.chr = chr;
        this.start = start;
        this.end = end;
    }

    public Anchor(String chr, int start, int end, int intensity) {
        this.chr = chr;
        this.start = start;
        this.end = end;
        this.intensity = intensity;
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public void setChr(String chrom) {
        this.chr = chrom;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.chr, this.end, this.intensity, this.start);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Anchor)) {
            return false;
        }
        Anchor other = (Anchor)obj;
        return Objects.equals(this.chr, other.chr) && this.end == other.end && this.intensity == other.intensity && this.start == other.start;
    }

    @Override
    public Collection<Anchor> anchors() {
        return Arrays.asList(this);
    }

    public int getIntensity() {
        return this.intensity;
    }

    public void setIntensity(int intensity) {
        this.intensity = intensity;
    }

    @JsonIgnore
    public int span() {
        return this.end - this.start;
    }
}

