/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import java.util.Objects;
import org.apache.commons.beanutils.BeanMap;
import org.geneweaver.domain.AbstractContact;

public class Contact
extends AbstractContact {
    private String geneId;
    private String rsId;

    @Override
    public String getHeader() {
        StringBuilder buf = new StringBuilder();
        buf.append(":START_ID(Gene-Id)");
        buf.append(this.getDelimiter());
        buf.append("method");
        buf.append(this.getDelimiter());
        buf.append("cellType");
        buf.append(this.getDelimiter());
        buf.append("originalAssembly");
        buf.append(this.getDelimiter());
        buf.append(":END_ID(Rs-Id)");
        buf.append(this.getDelimiter());
        buf.append(":TYPE");
        return buf.toString();
    }

    @Override
    public String toCsv() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getGeneId());
        buf.append(this.getDelimiter());
        buf.append(this.getMethod());
        buf.append(this.getDelimiter());
        buf.append(this.getCellType());
        buf.append(this.getDelimiter());
        buf.append(this.getOriginalAssembly());
        buf.append(this.getDelimiter());
        buf.append(this.getRsId());
        buf.append(this.getDelimiter());
        buf.append(this.getClass().getSimpleName().toUpperCase());
        return buf.toString();
    }

    public String getGeneId() {
        return this.geneId;
    }

    public void setGeneId(String geneId) {
        this.geneId = geneId;
    }

    public String getRsId() {
        return this.rsId;
    }

    public void setRsId(String rsId) {
        this.rsId = rsId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.geneId, this.rsId);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Contact)) {
            return false;
        }
        Contact other = (Contact)obj;
        return Objects.equals(this.geneId, other.geneId) && Objects.equals(this.rsId, other.rsId);
    }

    public static Contact of(AbstractContact other) {
        Contact ret = new Contact();
        BeanMap to = new BeanMap((Object)ret);
        to.putAllWriteable(new BeanMap((Object)other));
        return ret;
    }
}

