/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.geneweaver.domain.EQTLBase;
import org.geneweaver.domain.Gene;
import org.geneweaver.domain.Variant;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;

@RelationshipEntity(type="EQTL")
public class EQTL
extends EQTLBase {
    private Type type = Type.PEAK;
    private String marker;
    private String population;
    @StartNode
    private Variant variantFrom;
    private String rsId;
    private String refSeq;
    private String altSeq;
    private double slope;
    private Double pos;
    private String version;
    private String source;
    private String chrGRCm39;
    private Integer bpGRCm39;
    @EndNode
    private Gene geneTo;
    private String geneId;
    private String fullGeneId;
    private String eqtlVariantId;

    public EQTL() {
    }

    public EQTL(String geneId, String variantId, String rsId) {
        this.geneId = geneId;
        this.eqtlVariantId = variantId;
        this.rsId = rsId;
    }

    @Override
    public String getHeader() {
        return this.delimify(":START_ID(Rs-Id)", "type", "chr", "slope:double", "tissueFileName", "tissueGroup", "tissueName", "version", "uberon", "source", "marker", "lod:double", "bp:int", ":END_ID(Gene-Id)", ":TYPE");
    }

    @Override
    public String toCsv() {
        return this.delimify(new Object[]{this.getRsId(), this.getType(), this.getChrGRCm39() != null ? this.getChrGRCm39() : this.getChr(), this.getSlope(), this.getTissueFileName(), this.getTissueGroup(), this.getTissueName(), this.getVersion(), this.getUberon(), this.getSource(), this.getMarker(), this.getLod() != null ? this.getLod() : -1.0, this.getBpGRCm39() != null ? this.getBpGRCm39() : -1, this.getGeneId(), this.getClass().getSimpleName().toUpperCase()});
    }

    public String getEqtlVariantId() {
        return this.eqtlVariantId;
    }

    public void setEqtlVariantId(String variantId) {
        this.eqtlVariantId = variantId;
    }

    public String getRsId() {
        if (this.rsId == null && this.variantFrom != null) {
            return this.variantFrom.getRsId();
        }
        return this.rsId;
    }

    public void setRsId(String rsId) {
        this.rsId = rsId;
    }

    public String getGeneId() {
        if (this.geneId == null && this.geneTo != null) {
            return this.geneTo.getGeneId();
        }
        return this.geneId;
    }

    public void setGeneId(String geneId) {
        this.geneId = geneId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(new Object[]{this.altSeq, this.bpGRCm39, this.chrGRCm39, this.eqtlVariantId, this.fullGeneId, this.geneId, this.geneTo, this.marker, this.population, this.pos, this.refSeq, this.rsId, this.slope, this.source, this.type, this.variantFrom, this.version});
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof EQTL)) {
            return false;
        }
        EQTL other = (EQTL)obj;
        return Objects.equals(this.altSeq, other.altSeq) && Objects.equals(this.bpGRCm39, other.bpGRCm39) && Objects.equals(this.chrGRCm39, other.chrGRCm39) && Objects.equals(this.eqtlVariantId, other.eqtlVariantId) && Objects.equals(this.fullGeneId, other.fullGeneId) && Objects.equals(this.geneId, other.geneId) && Objects.equals(this.geneTo, other.geneTo) && Objects.equals(this.marker, other.marker) && Objects.equals(this.population, other.population) && Objects.equals(this.pos, other.pos) && Objects.equals(this.refSeq, other.refSeq) && Objects.equals(this.rsId, other.rsId) && Double.doubleToLongBits(this.slope) == Double.doubleToLongBits(other.slope) && Objects.equals(this.source, other.source) && this.type == other.type && Objects.equals(this.variantFrom, other.variantFrom) && Objects.equals(this.version, other.version);
    }

    public Variant getVariantFrom() {
        return this.variantFrom;
    }

    public void setVariantFrom(Variant variantFrom) {
        this.variantFrom = variantFrom;
    }

    public Gene getGeneTo() {
        return this.geneTo;
    }

    public void setGeneTo(Gene geneTo) {
        this.geneTo = geneTo;
    }

    public String getRefSeq() {
        return this.refSeq;
    }

    public void setRefSeq(String refSeq) {
        this.refSeq = refSeq;
    }

    public String getAltSeq() {
        return this.altSeq;
    }

    public void setAltSeq(String altSeq) {
        this.altSeq = altSeq;
    }

    public double getSlope() {
        return this.slope;
    }

    public void setSlope(double slope) {
        this.slope = slope;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getFullGeneId() {
        return this.fullGeneId;
    }

    public void setFullGeneId(String fullGeneId) {
        this.fullGeneId = fullGeneId;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getPopulation() {
        return this.population;
    }

    public void setPopulation(String population) {
        this.population = population;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Double getPos() {
        return this.pos;
    }

    public void setPos(Double pos) {
        this.pos = pos;
    }

    public String getChrGRCm39() {
        return this.chrGRCm39;
    }

    public void setChrGRCm39(String chrGRCm39) {
        this.chrGRCm39 = chrGRCm39;
    }

    public Integer getBpGRCm39() {
        return this.bpGRCm39;
    }

    public void setBpGRCm39(Integer bpGRCm39) {
        this.bpGRCm39 = bpGRCm39;
    }

    @Override
    @JsonIgnore
    public String id() {
        return this.geneId;
    }

    @Override
    public String getChr() {
        String chr = this.getChrGRCm39();
        if (chr != null && chr.toLowerCase().startsWith("chr")) {
            return chr.substring(3);
        }
        return super.getChr();
    }

    @Override
    @JsonIgnore
    public Integer getStart() {
        return this.getBpGRCm39();
    }

    @Override
    @JsonIgnore
    public Integer getEnd() {
        return this.getBpGRCm39();
    }

    public static enum Type {
        PEAK,
        INTERVAL;

    }
}

