/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.geneweaver.domain.EQTLBase;
import org.geneweaver.domain.Located;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;

@RelationshipEntity(type="EQTL_OVERLAP")
public class EQTLOverlap
extends EQTLBase {
    @StartNode
    private Located gene;
    @EndNode
    private Located variant;

    @Override
    public String getHeader() {
        return this.delimify(":START_ID(Rs-Id)", "chr", "tissueFileName", "tissueGroup", "tissueName", "uberon", "lod:double", "bp:int", "studyId", ":END_ID(Gene-Id)", ":TYPE");
    }

    @Override
    public String toCsv() {
        return this.delimify(this.variant != null ? this.variant.id() : null, this.getChr(), this.getTissueFileName(), this.getTissueGroup(), this.getTissueName(), this.getUberon(), this.getLod() != null ? this.getLod() : -1.0, this.getBp() != null ? this.getBp() : -1, this.getStudyId(), this.gene != null ? this.gene.id() : null, "EQTL_OVERLAP");
    }

    public Located getGene() {
        return this.gene;
    }

    public void setGene(Located gene) {
        this.gene = gene;
    }

    public Located getVariant() {
        return this.variant;
    }

    public void setVariant(Located variant) {
        this.variant = variant;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.gene, this.variant);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof EQTLOverlap)) {
            return false;
        }
        EQTLOverlap other = (EQTLOverlap)obj;
        return Objects.equals(this.gene, other.gene) && Objects.equals(this.variant, other.variant);
    }

    @Override
    public String toString() {
        if (this.gene == null || this.variant == null) {
            return super.toString();
        }
        return "(Variant{rsId:" + this.variant.id() + "})-[EQTL_OVERLAP]-(Gene{geneId:" + this.gene.id() + ")";
    }

    @Override
    @JsonIgnore
    public String id() {
        return this.gene.id();
    }

    @Override
    @JsonIgnore
    public Integer getStart() {
        return this.getBp();
    }

    @Override
    @JsonIgnore
    public Integer getEnd() {
        return this.getBp();
    }
}

