/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanMap;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.RelationshipEntity;

public interface Entity {
    public static final String NO_CHR = "NO-CHROMOSOME";

    public String getChr();

    public Long getUid();

    @JsonIgnore
    default public boolean isRelationship() {
        return this.getClass().isAnnotationPresent(RelationshipEntity.class);
    }

    @JsonIgnore
    default public boolean isNode() {
        return this.getClass().isAnnotationPresent(NodeEntity.class);
    }

    @JsonIgnore
    default public String getHeader() {
        return null;
    }

    @JsonIgnore
    default public String toCsv() {
        return null;
    }

    default public String delimify(Object ... values) {
        StringBuilder buf = new StringBuilder();
        buf.append(values[0]);
        if (values.length > 1) {
            for (int i = 1; i < values.length; ++i) {
                buf.append(this.getDelimiter());
                buf.append(values[i]);
            }
        }
        return buf.toString();
    }

    @JsonIgnore
    default public String getDelimiter() {
        return System.getProperty("delimiter", "|");
    }

    public static <T extends Entity> T coerce(Map<String, Object> props, T entity) {
        BeanMap map = new BeanMap(entity);
        Set names = map.keySet();
        props.keySet().retainAll(names);
        map.putAll(props);
        return entity;
    }
}

