/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import org.geneweaver.domain.NamedEntity;

public class Fantom5Link
extends NamedEntity {
    private String chrom;
    private int start;
    private int end;
    private Collection<String> ensemblIds = new LinkedList<String>();

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.chrom, this.end, this.ensemblIds, this.start);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Fantom5Link)) {
            return false;
        }
        Fantom5Link other = (Fantom5Link)obj;
        return Objects.equals(this.chrom, other.chrom) && this.end == other.end && Objects.equals(this.ensemblIds, other.ensemblIds) && this.start == other.start;
    }

    public String getChrom() {
        return this.chrom;
    }

    public void setChrom(String chrom) {
        this.chrom = chrom;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public Collection<String> getEnsemblIds() {
        return this.ensemblIds;
    }

    public void setEnsemblIds(Collection<String> ensemblNames) {
        this.ensemblIds = ensemblNames;
    }

    public boolean addEnsemblIds(String ... geneIds) {
        return this.ensemblIds.addAll(Arrays.asList(geneIds));
    }

    public boolean removeEnsemblIds(String ... geneIds) {
        return this.ensemblIds.removeAll(Arrays.asList(geneIds));
    }

    @JsonIgnore
    public int span() {
        return this.end - this.start;
    }
}

