/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import java.util.Objects;
import org.geneweaver.domain.GeneticEntity;
import org.neo4j.ogm.annotation.NodeEntity;

@NodeEntity(label="Gene")
public class Gene
extends GeneticEntity {
    private String geneName;
    private String geneVersion;
    private String geneBiotype;

    public Gene() {
    }

    public Gene(String id, int start, int end) {
        this.setGeneId(id);
        this.setStart(start);
        this.setEnd(end);
    }

    @Override
    public String getHeader() {
        StringBuilder buf = new StringBuilder();
        buf.append("geneId:ID(Gene-Id)");
        buf.append(this.getDelimiter());
        buf.append("geneName");
        buf.append(this.getDelimiter());
        buf.append("geneVersion");
        buf.append(this.getDelimiter());
        buf.append("geneBiotype");
        buf.append(this.getDelimiter());
        buf.append(super.getHeader());
        return buf.toString();
    }

    @Override
    public String toCsv() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getGeneId());
        buf.append(this.getDelimiter());
        buf.append(this.getGeneName());
        buf.append(this.getDelimiter());
        buf.append(this.getGeneVersion());
        buf.append(this.getDelimiter());
        buf.append(this.getGeneBiotype());
        buf.append(this.getDelimiter());
        buf.append(super.toCsv());
        return buf.toString();
    }

    public String getGeneName() {
        return this.geneName;
    }

    public void setGeneName(String gene_name) {
        this.geneName = gene_name;
    }

    public String getGeneBiotype() {
        return this.geneBiotype;
    }

    public void setGeneBiotype(String gene_biotype) {
        this.geneBiotype = gene_biotype;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.geneBiotype, this.geneName, this.geneVersion);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Gene)) {
            return false;
        }
        Gene other = (Gene)obj;
        return Objects.equals(this.geneBiotype, other.geneBiotype) && Objects.equals(this.geneName, other.geneName) && Objects.equals(this.geneVersion, other.geneVersion);
    }

    public String getGeneVersion() {
        return this.geneVersion;
    }

    public void setGeneVersion(String geneVersion) {
        this.geneVersion = geneVersion;
    }

    @Override
    public String id() {
        return this.getGeneId();
    }
}

