/*
 * Decompiled with CFR 0.152.
 */
package org.geneweaver.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.geneweaver.domain.AbstractEntity;
import org.geneweaver.domain.Located;
import org.geneweaver.domain.Species;
import org.neo4j.ogm.annotation.Index;

public abstract class GeneticEntity
extends AbstractEntity
implements Species,
Located {
    @Index(unique=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String geneId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Long build = 0L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean active = true;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String phase;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String strand;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String source;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer species;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer start = 0;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer end = 0;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String sequenceId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String score;

    @Override
    public String getHeader() {
        StringBuilder buf = new StringBuilder();
        buf.append("active:boolean");
        buf.append(this.getDelimiter());
        buf.append("chr");
        buf.append(this.getDelimiter());
        buf.append("type");
        buf.append(this.getDelimiter());
        buf.append("phase");
        buf.append(this.getDelimiter());
        buf.append("strand");
        buf.append(this.getDelimiter());
        buf.append("source");
        buf.append(this.getDelimiter());
        buf.append("species:int");
        buf.append(this.getDelimiter());
        buf.append("start:int");
        buf.append(this.getDelimiter());
        buf.append("end:int");
        buf.append(this.getDelimiter());
        buf.append("sequenceId");
        buf.append(this.getDelimiter());
        buf.append("score");
        buf.append(this.getDelimiter());
        buf.append(":LABEL");
        return buf.toString();
    }

    @Override
    public String toCsv() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getActive());
        buf.append(this.getDelimiter());
        buf.append(this.getChr());
        buf.append(this.getDelimiter());
        buf.append(this.getType());
        buf.append(this.getDelimiter());
        buf.append(this.getPhase());
        buf.append(this.getDelimiter());
        buf.append(this.getStrand());
        buf.append(this.getDelimiter());
        buf.append(this.getSource());
        buf.append(this.getDelimiter());
        buf.append(this.getSpecies());
        buf.append(this.getDelimiter());
        buf.append(this.getStart());
        buf.append(this.getDelimiter());
        buf.append(this.getEnd());
        buf.append(this.getDelimiter());
        buf.append(this.getSequenceId());
        buf.append(this.getDelimiter());
        buf.append(this.getScore());
        buf.append(this.getDelimiter());
        buf.append(this.getClass().getSimpleName().toString());
        return buf.toString();
    }

    public void setBuild(Long build) {
        this.build = build;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.active, this.build, this.end, this.geneId, this.phase, this.score, this.sequenceId, this.source, this.species, this.start, this.strand, this.type);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof GeneticEntity)) {
            return false;
        }
        GeneticEntity other = (GeneticEntity)obj;
        return Objects.equals(this.active, other.active) && Objects.equals(this.build, other.build) && Objects.equals(this.end, other.end) && Objects.equals(this.geneId, other.geneId) && Objects.equals(this.phase, other.phase) && Objects.equals(this.score, other.score) && Objects.equals(this.sequenceId, other.sequenceId) && Objects.equals(this.source, other.source) && Objects.equals(this.species, other.species) && Objects.equals(this.start, other.start) && Objects.equals(this.strand, other.strand) && Objects.equals(this.type, other.type);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public String getStrand() {
        return this.strand;
    }

    public void setStrand(String strand) {
        this.strand = strand;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public Integer getSpecies() {
        return this.species;
    }

    @Override
    public void setSpecies(Integer species) {
        this.species = species;
    }

    @Override
    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    @Override
    public Integer getEnd() {
        return this.end;
    }

    public void setEnd(Integer end) {
        this.end = end;
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(String seq_id) {
        this.sequenceId = seq_id;
    }

    public String getScore() {
        return this.score;
    }

    public void setScore(String score) {
        this.score = score;
    }

    public String getGeneId() {
        return this.geneId;
    }

    public void setGeneId(String geneId) {
        this.geneId = geneId;
    }

    public Long getBuild() {
        return this.build;
    }
}

